/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.DatabaseSqlVulnerabilityAssessmentScanResultsClient;
import com.azure.resourcemanager.sql.fluent.models.SqlVulnerabilityAssessmentScanResultsInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.SqlVulnerabilityAssessmentName;
import com.azure.resourcemanager.sql.models.SqlVulnerabilityAssessmentScanListResult;
import reactor.core.publisher.Mono;

public final class DatabaseSqlVulnerabilityAssessmentScanResultsClientImpl
implements DatabaseSqlVulnerabilityAssessmentScanResultsClient {
    private final DatabaseSqlVulnerabilityAssessmentScanResultsService service;
    private final SqlManagementClientImpl client;

    DatabaseSqlVulnerabilityAssessmentScanResultsClientImpl(SqlManagementClientImpl client) {
        this.service = (DatabaseSqlVulnerabilityAssessmentScanResultsService)RestProxy.create(DatabaseSqlVulnerabilityAssessmentScanResultsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SqlVulnerabilityAssessmentScanResultsInner>> listByScanSinglePageAsync(String resourceGroupName, String serverName, String databaseName, SqlVulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByScan(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(), "2022-11-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlVulnerabilityAssessmentScanListResult)res.getValue()).value(), ((SqlVulnerabilityAssessmentScanListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SqlVulnerabilityAssessmentScanResultsInner>> listByScanSinglePageAsync(String resourceGroupName, String serverName, String databaseName, SqlVulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByScan(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, this.client.getSubscriptionId(), "2022-11-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlVulnerabilityAssessmentScanListResult)res.getValue()).value(), ((SqlVulnerabilityAssessmentScanListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SqlVulnerabilityAssessmentScanResultsInner> listByScanAsync(String resourceGroupName, String serverName, String databaseName, SqlVulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return new PagedFlux(() -> this.listByScanSinglePageAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId), nextLink -> this.listByScanNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SqlVulnerabilityAssessmentScanResultsInner> listByScanAsync(String resourceGroupName, String serverName, String databaseName, SqlVulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        return new PagedFlux(() -> this.listByScanSinglePageAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, context), nextLink -> this.listByScanNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SqlVulnerabilityAssessmentScanResultsInner> listByScan(String resourceGroupName, String serverName, String databaseName, SqlVulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId) {
        return new PagedIterable(this.listByScanAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SqlVulnerabilityAssessmentScanResultsInner> listByScan(String resourceGroupName, String serverName, String databaseName, SqlVulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, Context context) {
        return new PagedIterable(this.listByScanAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SqlVulnerabilityAssessmentScanResultsInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, SqlVulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, String scanResultId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (scanResultId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanResultId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, scanResultId, this.client.getSubscriptionId(), "2022-11-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SqlVulnerabilityAssessmentScanResultsInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, SqlVulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, String scanResultId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (scanId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanId is required and cannot be null."));
        }
        if (scanResultId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scanResultId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-11-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, scanResultId, this.client.getSubscriptionId(), "2022-11-01-preview", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlVulnerabilityAssessmentScanResultsInner> getAsync(String resourceGroupName, String serverName, String databaseName, SqlVulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, String scanResultId) {
        return this.getWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, scanResultId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SqlVulnerabilityAssessmentScanResultsInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SqlVulnerabilityAssessmentScanResultsInner> getWithResponse(String resourceGroupName, String serverName, String databaseName, SqlVulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, String scanResultId, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, scanResultId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SqlVulnerabilityAssessmentScanResultsInner get(String resourceGroupName, String serverName, String databaseName, SqlVulnerabilityAssessmentName vulnerabilityAssessmentName, String scanId, String scanResultId) {
        return (SqlVulnerabilityAssessmentScanResultsInner)((Object)this.getWithResponse(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, scanId, scanResultId, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SqlVulnerabilityAssessmentScanResultsInner>> listByScanNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByScanNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlVulnerabilityAssessmentScanListResult)res.getValue()).value(), ((SqlVulnerabilityAssessmentScanListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SqlVulnerabilityAssessmentScanResultsInner>> listByScanNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByScanNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlVulnerabilityAssessmentScanListResult)res.getValue()).value(), ((SqlVulnerabilityAssessmentScanListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientDatabaseSqlVulnerabilityAssessmentScanResults")
    public static interface DatabaseSqlVulnerabilityAssessmentScanResultsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlVulnerabilityAssessmentScanListResult>> listByScan(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") SqlVulnerabilityAssessmentName var5, @PathParam(value="scanId") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults/{scanResultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlVulnerabilityAssessmentScanResultsInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") SqlVulnerabilityAssessmentName var5, @PathParam(value="scanId") String var6, @PathParam(value="scanResultId") String var7, @PathParam(value="subscriptionId") String var8, @QueryParam(value="api-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlVulnerabilityAssessmentScanListResult>> listByScanNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

