/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.DatabaseSqlVulnerabilityAssessmentExecuteScansClient;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentName;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DatabaseSqlVulnerabilityAssessmentExecuteScansClientImpl
implements DatabaseSqlVulnerabilityAssessmentExecuteScansClient {
    private final DatabaseSqlVulnerabilityAssessmentExecuteScansService service;
    private final SqlManagementClientImpl client;

    DatabaseSqlVulnerabilityAssessmentExecuteScansClientImpl(SqlManagementClientImpl client) {
        this.service = (DatabaseSqlVulnerabilityAssessmentExecuteScansService)RestProxy.create(DatabaseSqlVulnerabilityAssessmentExecuteScansService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> executeWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-11-01-preview";
        return FluxUtil.withContext(context -> this.service.execute(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, this.client.getSubscriptionId(), "2022-11-01-preview", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> executeWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-11-01-preview";
        context = this.client.mergeContext(context);
        return this.service.execute(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, this.client.getSubscriptionId(), "2022-11-01-preview", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginExecuteAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.executeWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginExecuteAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.executeWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginExecute(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        return this.beginExecuteAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginExecute(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        return this.beginExecuteAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> executeAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        return this.beginExecuteAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> executeAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        return this.beginExecuteAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void execute(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName) {
        this.executeAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void execute(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, Context context) {
        this.executeAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientDatabaseSqlVulnerabilityAssessmentExecuteScans")
    public static interface DatabaseSqlVulnerabilityAssessmentExecuteScansService {
        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/initiateScan")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> execute(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, Context var8);
    }
}

