/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.QueryStatisticsPropertiesAutoGenerated;
import com.azure.resourcemanager.sql.models.QueryTimeGrainType;
import java.io.IOException;
import java.util.List;

public final class TopQueriesInner
implements JsonSerializable<TopQueriesInner> {
    private Integer numberOfQueries;
    private String aggregationFunction;
    private String observationMetric;
    private QueryTimeGrainType intervalType;
    private String startTime;
    private String endTime;
    private List<QueryStatisticsPropertiesAutoGenerated> queries;

    public Integer numberOfQueries() {
        return this.numberOfQueries;
    }

    public String aggregationFunction() {
        return this.aggregationFunction;
    }

    public String observationMetric() {
        return this.observationMetric;
    }

    public QueryTimeGrainType intervalType() {
        return this.intervalType;
    }

    public String startTime() {
        return this.startTime;
    }

    public String endTime() {
        return this.endTime;
    }

    public List<QueryStatisticsPropertiesAutoGenerated> queries() {
        return this.queries;
    }

    public TopQueriesInner withQueries(List<QueryStatisticsPropertiesAutoGenerated> queries) {
        this.queries = queries;
        return this;
    }

    public void validate() {
        if (this.queries() != null) {
            this.queries().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("queries", this.queries, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TopQueriesInner fromJson(JsonReader jsonReader) throws IOException {
        return (TopQueriesInner)jsonReader.readObject(reader -> {
            TopQueriesInner deserializedTopQueriesInner = new TopQueriesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("numberOfQueries".equals(fieldName)) {
                    deserializedTopQueriesInner.numberOfQueries = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("aggregationFunction".equals(fieldName)) {
                    deserializedTopQueriesInner.aggregationFunction = reader.getString();
                    continue;
                }
                if ("observationMetric".equals(fieldName)) {
                    deserializedTopQueriesInner.observationMetric = reader.getString();
                    continue;
                }
                if ("intervalType".equals(fieldName)) {
                    deserializedTopQueriesInner.intervalType = QueryTimeGrainType.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedTopQueriesInner.startTime = reader.getString();
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedTopQueriesInner.endTime = reader.getString();
                    continue;
                }
                if ("queries".equals(fieldName)) {
                    List queries;
                    deserializedTopQueriesInner.queries = queries = reader.readArray(reader1 -> QueryStatisticsPropertiesAutoGenerated.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTopQueriesInner;
        });
    }
}

