/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.SyncGroupProperties;
import com.azure.resourcemanager.sql.models.Sku;
import com.azure.resourcemanager.sql.models.SyncConflictResolutionPolicy;
import com.azure.resourcemanager.sql.models.SyncGroupSchema;
import com.azure.resourcemanager.sql.models.SyncGroupState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SyncGroupInner
extends ProxyResource {
    private Sku sku;
    private SyncGroupProperties innerProperties;
    private String type;
    private String name;
    private String id;

    public Sku sku() {
        return this.sku;
    }

    public SyncGroupInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    private SyncGroupProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public Integer interval() {
        return this.innerProperties() == null ? null : this.innerProperties().interval();
    }

    public SyncGroupInner withInterval(Integer interval) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncGroupProperties();
        }
        this.innerProperties().withInterval(interval);
        return this;
    }

    public OffsetDateTime lastSyncTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastSyncTime();
    }

    public SyncConflictResolutionPolicy conflictResolutionPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().conflictResolutionPolicy();
    }

    public SyncGroupInner withConflictResolutionPolicy(SyncConflictResolutionPolicy conflictResolutionPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncGroupProperties();
        }
        this.innerProperties().withConflictResolutionPolicy(conflictResolutionPolicy);
        return this;
    }

    public String syncDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().syncDatabaseId();
    }

    public SyncGroupInner withSyncDatabaseId(String syncDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncGroupProperties();
        }
        this.innerProperties().withSyncDatabaseId(syncDatabaseId);
        return this;
    }

    public String hubDatabaseUsername() {
        return this.innerProperties() == null ? null : this.innerProperties().hubDatabaseUsername();
    }

    public SyncGroupInner withHubDatabaseUsername(String hubDatabaseUsername) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncGroupProperties();
        }
        this.innerProperties().withHubDatabaseUsername(hubDatabaseUsername);
        return this;
    }

    public String hubDatabasePassword() {
        return this.innerProperties() == null ? null : this.innerProperties().hubDatabasePassword();
    }

    public SyncGroupInner withHubDatabasePassword(String hubDatabasePassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncGroupProperties();
        }
        this.innerProperties().withHubDatabasePassword(hubDatabasePassword);
        return this;
    }

    public SyncGroupState syncState() {
        return this.innerProperties() == null ? null : this.innerProperties().syncState();
    }

    public SyncGroupSchema schema() {
        return this.innerProperties() == null ? null : this.innerProperties().schema();
    }

    public SyncGroupInner withSchema(SyncGroupSchema schema) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncGroupProperties();
        }
        this.innerProperties().withSchema(schema);
        return this;
    }

    public Boolean enableConflictLogging() {
        return this.innerProperties() == null ? null : this.innerProperties().enableConflictLogging();
    }

    public SyncGroupInner withEnableConflictLogging(Boolean enableConflictLogging) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncGroupProperties();
        }
        this.innerProperties().withEnableConflictLogging(enableConflictLogging);
        return this;
    }

    public Integer conflictLoggingRetentionInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().conflictLoggingRetentionInDays();
    }

    public SyncGroupInner withConflictLoggingRetentionInDays(Integer conflictLoggingRetentionInDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncGroupProperties();
        }
        this.innerProperties().withConflictLoggingRetentionInDays(conflictLoggingRetentionInDays);
        return this;
    }

    public Boolean usePrivateLinkConnection() {
        return this.innerProperties() == null ? null : this.innerProperties().usePrivateLinkConnection();
    }

    public SyncGroupInner withUsePrivateLinkConnection(Boolean usePrivateLinkConnection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncGroupProperties();
        }
        this.innerProperties().withUsePrivateLinkConnection(usePrivateLinkConnection);
        return this;
    }

    public String privateEndpointName() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointName();
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SyncGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return (SyncGroupInner)((Object)jsonReader.readObject(reader -> {
            SyncGroupInner deserializedSyncGroupInner = new SyncGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSyncGroupInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSyncGroupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSyncGroupInner.type = reader.getString();
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedSyncGroupInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSyncGroupInner.innerProperties = SyncGroupProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSyncGroupInner;
        }));
    }
}

