/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ScheduleItem;
import java.io.IOException;
import java.util.List;

public final class StartStopManagedInstanceScheduleProperties
implements JsonSerializable<StartStopManagedInstanceScheduleProperties> {
    private String description;
    private String timeZoneId;
    private List<ScheduleItem> scheduleList;
    private String nextRunAction;
    private String nextExecutionTime;
    private static final ClientLogger LOGGER = new ClientLogger(StartStopManagedInstanceScheduleProperties.class);

    public String description() {
        return this.description;
    }

    public StartStopManagedInstanceScheduleProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String timeZoneId() {
        return this.timeZoneId;
    }

    public StartStopManagedInstanceScheduleProperties withTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
        return this;
    }

    public List<ScheduleItem> scheduleList() {
        return this.scheduleList;
    }

    public StartStopManagedInstanceScheduleProperties withScheduleList(List<ScheduleItem> scheduleList) {
        this.scheduleList = scheduleList;
        return this;
    }

    public String nextRunAction() {
        return this.nextRunAction;
    }

    public String nextExecutionTime() {
        return this.nextExecutionTime;
    }

    public void validate() {
        if (this.scheduleList() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property scheduleList in model StartStopManagedInstanceScheduleProperties"));
        }
        this.scheduleList().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("scheduleList", this.scheduleList, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("timeZoneId", this.timeZoneId);
        return jsonWriter.writeEndObject();
    }

    public static StartStopManagedInstanceScheduleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (StartStopManagedInstanceScheduleProperties)jsonReader.readObject(reader -> {
            StartStopManagedInstanceScheduleProperties deserializedStartStopManagedInstanceScheduleProperties = new StartStopManagedInstanceScheduleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scheduleList".equals(fieldName)) {
                    List scheduleList;
                    deserializedStartStopManagedInstanceScheduleProperties.scheduleList = scheduleList = reader.readArray(reader1 -> ScheduleItem.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedStartStopManagedInstanceScheduleProperties.description = reader.getString();
                    continue;
                }
                if ("timeZoneId".equals(fieldName)) {
                    deserializedStartStopManagedInstanceScheduleProperties.timeZoneId = reader.getString();
                    continue;
                }
                if ("nextRunAction".equals(fieldName)) {
                    deserializedStartStopManagedInstanceScheduleProperties.nextRunAction = reader.getString();
                    continue;
                }
                if ("nextExecutionTime".equals(fieldName)) {
                    deserializedStartStopManagedInstanceScheduleProperties.nextExecutionTime = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStartStopManagedInstanceScheduleProperties;
        });
    }
}

