/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.BaselineAdjustedResult;
import com.azure.resourcemanager.sql.models.Remediation;
import com.azure.resourcemanager.sql.models.RuleStatus;
import com.azure.resourcemanager.sql.models.VaRule;
import java.io.IOException;
import java.util.List;

public final class SqlVulnerabilityAssessmentScanResultProperties
implements JsonSerializable<SqlVulnerabilityAssessmentScanResultProperties> {
    private String ruleId;
    private RuleStatus status;
    private String errorMessage;
    private Boolean isTrimmed;
    private List<List<String>> queryResults;
    private Remediation remediation;
    private BaselineAdjustedResult baselineAdjustedResult;
    private VaRule ruleMetadata;

    public String ruleId() {
        return this.ruleId;
    }

    public RuleStatus status() {
        return this.status;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Boolean isTrimmed() {
        return this.isTrimmed;
    }

    public List<List<String>> queryResults() {
        return this.queryResults;
    }

    public Remediation remediation() {
        return this.remediation;
    }

    public BaselineAdjustedResult baselineAdjustedResult() {
        return this.baselineAdjustedResult;
    }

    public VaRule ruleMetadata() {
        return this.ruleMetadata;
    }

    public void validate() {
        if (this.remediation() != null) {
            this.remediation().validate();
        }
        if (this.baselineAdjustedResult() != null) {
            this.baselineAdjustedResult().validate();
        }
        if (this.ruleMetadata() != null) {
            this.ruleMetadata().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static SqlVulnerabilityAssessmentScanResultProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SqlVulnerabilityAssessmentScanResultProperties)jsonReader.readObject(reader -> {
            SqlVulnerabilityAssessmentScanResultProperties deserializedSqlVulnerabilityAssessmentScanResultProperties = new SqlVulnerabilityAssessmentScanResultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ruleId".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanResultProperties.ruleId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanResultProperties.status = RuleStatus.fromString(reader.getString());
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanResultProperties.errorMessage = reader.getString();
                    continue;
                }
                if ("isTrimmed".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanResultProperties.isTrimmed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("queryResults".equals(fieldName)) {
                    List queryResults;
                    deserializedSqlVulnerabilityAssessmentScanResultProperties.queryResults = queryResults = reader.readArray(reader1 -> reader1.readArray(reader2 -> reader2.getString()));
                    continue;
                }
                if ("remediation".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanResultProperties.remediation = Remediation.fromJson(reader);
                    continue;
                }
                if ("baselineAdjustedResult".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanResultProperties.baselineAdjustedResult = BaselineAdjustedResult.fromJson(reader);
                    continue;
                }
                if ("ruleMetadata".equals(fieldName)) {
                    deserializedSqlVulnerabilityAssessmentScanResultProperties.ruleMetadata = VaRule.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlVulnerabilityAssessmentScanResultProperties;
        });
    }
}

