/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.RestorableDroppedManagedDatabaseProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class RestorableDroppedManagedDatabaseInner
extends Resource {
    private RestorableDroppedManagedDatabaseProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private RestorableDroppedManagedDatabaseProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public RestorableDroppedManagedDatabaseInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public RestorableDroppedManagedDatabaseInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String databaseName() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseName();
    }

    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    public OffsetDateTime deletionDate() {
        return this.innerProperties() == null ? null : this.innerProperties().deletionDate();
    }

    public OffsetDateTime earliestRestoreDate() {
        return this.innerProperties() == null ? null : this.innerProperties().earliestRestoreDate();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RestorableDroppedManagedDatabaseInner fromJson(JsonReader jsonReader) throws IOException {
        return (RestorableDroppedManagedDatabaseInner)((Object)jsonReader.readObject(reader -> {
            RestorableDroppedManagedDatabaseInner deserializedRestorableDroppedManagedDatabaseInner = new RestorableDroppedManagedDatabaseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRestorableDroppedManagedDatabaseInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRestorableDroppedManagedDatabaseInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRestorableDroppedManagedDatabaseInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedRestorableDroppedManagedDatabaseInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedRestorableDroppedManagedDatabaseInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRestorableDroppedManagedDatabaseInner.innerProperties = RestorableDroppedManagedDatabaseProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestorableDroppedManagedDatabaseInner;
        }));
    }
}

