/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.AuthMetadataLookupModes;
import com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import com.azure.resourcemanager.sql.models.ExternalGovernanceStatus;
import com.azure.resourcemanager.sql.models.FreemiumType;
import com.azure.resourcemanager.sql.models.HybridSecondaryUsage;
import com.azure.resourcemanager.sql.models.HybridSecondaryUsageDetected;
import com.azure.resourcemanager.sql.models.ManagedInstanceDatabaseFormat;
import com.azure.resourcemanager.sql.models.ManagedInstanceExternalAdministrator;
import com.azure.resourcemanager.sql.models.ManagedInstanceLicenseType;
import com.azure.resourcemanager.sql.models.ManagedInstancePecProperty;
import com.azure.resourcemanager.sql.models.ManagedInstanceProxyOverride;
import com.azure.resourcemanager.sql.models.ManagedServerCreateMode;
import com.azure.resourcemanager.sql.models.ProvisioningState;
import com.azure.resourcemanager.sql.models.ServicePrincipal;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class ManagedInstanceProperties
implements JsonSerializable<ManagedInstanceProperties> {
    private ProvisioningState provisioningState;
    private ManagedServerCreateMode managedInstanceCreateMode;
    private String fullyQualifiedDomainName;
    private Boolean isGeneralPurposeV2;
    private String administratorLogin;
    private String administratorLoginPassword;
    private String subnetId;
    private String state;
    private ManagedInstanceLicenseType licenseType;
    private HybridSecondaryUsage hybridSecondaryUsage;
    private HybridSecondaryUsageDetected hybridSecondaryUsageDetected;
    private Integer vCores;
    private Integer storageSizeInGB;
    private Integer storageIOps;
    private Integer storageThroughputMBps;
    private String collation;
    private String dnsZone;
    private String dnsZonePartner;
    private Boolean publicDataEndpointEnabled;
    private String sourceManagedInstanceId;
    private OffsetDateTime restorePointInTime;
    private ManagedInstanceProxyOverride proxyOverride;
    private String timezoneId;
    private String instancePoolId;
    private String maintenanceConfigurationId;
    private List<ManagedInstancePecProperty> privateEndpointConnections;
    private String minimalTlsVersion;
    private BackupStorageRedundancy currentBackupStorageRedundancy;
    private BackupStorageRedundancy requestedBackupStorageRedundancy;
    private Boolean zoneRedundant;
    private String primaryUserAssignedIdentityId;
    private String keyId;
    private ManagedInstanceExternalAdministrator administrators;
    private ServicePrincipal servicePrincipal;
    private String virtualClusterId;
    private ExternalGovernanceStatus externalGovernanceStatus;
    private FreemiumType pricingModel;
    private OffsetDateTime createTime;
    private AuthMetadataLookupModes authenticationMetadata;
    private ManagedInstanceDatabaseFormat databaseFormat;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ManagedServerCreateMode managedInstanceCreateMode() {
        return this.managedInstanceCreateMode;
    }

    public ManagedInstanceProperties withManagedInstanceCreateMode(ManagedServerCreateMode managedInstanceCreateMode) {
        this.managedInstanceCreateMode = managedInstanceCreateMode;
        return this;
    }

    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    public Boolean isGeneralPurposeV2() {
        return this.isGeneralPurposeV2;
    }

    public ManagedInstanceProperties withIsGeneralPurposeV2(Boolean isGeneralPurposeV2) {
        this.isGeneralPurposeV2 = isGeneralPurposeV2;
        return this;
    }

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ManagedInstanceProperties withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ManagedInstanceProperties withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public ManagedInstanceProperties withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String state() {
        return this.state;
    }

    public ManagedInstanceLicenseType licenseType() {
        return this.licenseType;
    }

    public ManagedInstanceProperties withLicenseType(ManagedInstanceLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public HybridSecondaryUsage hybridSecondaryUsage() {
        return this.hybridSecondaryUsage;
    }

    public ManagedInstanceProperties withHybridSecondaryUsage(HybridSecondaryUsage hybridSecondaryUsage) {
        this.hybridSecondaryUsage = hybridSecondaryUsage;
        return this;
    }

    public HybridSecondaryUsageDetected hybridSecondaryUsageDetected() {
        return this.hybridSecondaryUsageDetected;
    }

    public Integer vCores() {
        return this.vCores;
    }

    public ManagedInstanceProperties withVCores(Integer vCores) {
        this.vCores = vCores;
        return this;
    }

    public Integer storageSizeInGB() {
        return this.storageSizeInGB;
    }

    public ManagedInstanceProperties withStorageSizeInGB(Integer storageSizeInGB) {
        this.storageSizeInGB = storageSizeInGB;
        return this;
    }

    public Integer storageIOps() {
        return this.storageIOps;
    }

    public ManagedInstanceProperties withStorageIOps(Integer storageIOps) {
        this.storageIOps = storageIOps;
        return this;
    }

    public Integer storageThroughputMBps() {
        return this.storageThroughputMBps;
    }

    public ManagedInstanceProperties withStorageThroughputMBps(Integer storageThroughputMBps) {
        this.storageThroughputMBps = storageThroughputMBps;
        return this;
    }

    public String collation() {
        return this.collation;
    }

    public ManagedInstanceProperties withCollation(String collation) {
        this.collation = collation;
        return this;
    }

    public String dnsZone() {
        return this.dnsZone;
    }

    public String dnsZonePartner() {
        return this.dnsZonePartner;
    }

    public ManagedInstanceProperties withDnsZonePartner(String dnsZonePartner) {
        this.dnsZonePartner = dnsZonePartner;
        return this;
    }

    public Boolean publicDataEndpointEnabled() {
        return this.publicDataEndpointEnabled;
    }

    public ManagedInstanceProperties withPublicDataEndpointEnabled(Boolean publicDataEndpointEnabled) {
        this.publicDataEndpointEnabled = publicDataEndpointEnabled;
        return this;
    }

    public String sourceManagedInstanceId() {
        return this.sourceManagedInstanceId;
    }

    public ManagedInstanceProperties withSourceManagedInstanceId(String sourceManagedInstanceId) {
        this.sourceManagedInstanceId = sourceManagedInstanceId;
        return this;
    }

    public OffsetDateTime restorePointInTime() {
        return this.restorePointInTime;
    }

    public ManagedInstanceProperties withRestorePointInTime(OffsetDateTime restorePointInTime) {
        this.restorePointInTime = restorePointInTime;
        return this;
    }

    public ManagedInstanceProxyOverride proxyOverride() {
        return this.proxyOverride;
    }

    public ManagedInstanceProperties withProxyOverride(ManagedInstanceProxyOverride proxyOverride) {
        this.proxyOverride = proxyOverride;
        return this;
    }

    public String timezoneId() {
        return this.timezoneId;
    }

    public ManagedInstanceProperties withTimezoneId(String timezoneId) {
        this.timezoneId = timezoneId;
        return this;
    }

    public String instancePoolId() {
        return this.instancePoolId;
    }

    public ManagedInstanceProperties withInstancePoolId(String instancePoolId) {
        this.instancePoolId = instancePoolId;
        return this;
    }

    public String maintenanceConfigurationId() {
        return this.maintenanceConfigurationId;
    }

    public ManagedInstanceProperties withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        this.maintenanceConfigurationId = maintenanceConfigurationId;
        return this;
    }

    public List<ManagedInstancePecProperty> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public String minimalTlsVersion() {
        return this.minimalTlsVersion;
    }

    public ManagedInstanceProperties withMinimalTlsVersion(String minimalTlsVersion) {
        this.minimalTlsVersion = minimalTlsVersion;
        return this;
    }

    public BackupStorageRedundancy currentBackupStorageRedundancy() {
        return this.currentBackupStorageRedundancy;
    }

    public BackupStorageRedundancy requestedBackupStorageRedundancy() {
        return this.requestedBackupStorageRedundancy;
    }

    public ManagedInstanceProperties withRequestedBackupStorageRedundancy(BackupStorageRedundancy requestedBackupStorageRedundancy) {
        this.requestedBackupStorageRedundancy = requestedBackupStorageRedundancy;
        return this;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public ManagedInstanceProperties withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public String primaryUserAssignedIdentityId() {
        return this.primaryUserAssignedIdentityId;
    }

    public ManagedInstanceProperties withPrimaryUserAssignedIdentityId(String primaryUserAssignedIdentityId) {
        this.primaryUserAssignedIdentityId = primaryUserAssignedIdentityId;
        return this;
    }

    public String keyId() {
        return this.keyId;
    }

    public ManagedInstanceProperties withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public ManagedInstanceExternalAdministrator administrators() {
        return this.administrators;
    }

    public ManagedInstanceProperties withAdministrators(ManagedInstanceExternalAdministrator administrators) {
        this.administrators = administrators;
        return this;
    }

    public ServicePrincipal servicePrincipal() {
        return this.servicePrincipal;
    }

    public ManagedInstanceProperties withServicePrincipal(ServicePrincipal servicePrincipal) {
        this.servicePrincipal = servicePrincipal;
        return this;
    }

    public String virtualClusterId() {
        return this.virtualClusterId;
    }

    public ExternalGovernanceStatus externalGovernanceStatus() {
        return this.externalGovernanceStatus;
    }

    public FreemiumType pricingModel() {
        return this.pricingModel;
    }

    public ManagedInstanceProperties withPricingModel(FreemiumType pricingModel) {
        this.pricingModel = pricingModel;
        return this;
    }

    public OffsetDateTime createTime() {
        return this.createTime;
    }

    public AuthMetadataLookupModes authenticationMetadata() {
        return this.authenticationMetadata;
    }

    public ManagedInstanceProperties withAuthenticationMetadata(AuthMetadataLookupModes authenticationMetadata) {
        this.authenticationMetadata = authenticationMetadata;
        return this;
    }

    public ManagedInstanceDatabaseFormat databaseFormat() {
        return this.databaseFormat;
    }

    public ManagedInstanceProperties withDatabaseFormat(ManagedInstanceDatabaseFormat databaseFormat) {
        this.databaseFormat = databaseFormat;
        return this;
    }

    public void validate() {
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.administrators() != null) {
            this.administrators().validate();
        }
        if (this.servicePrincipal() != null) {
            this.servicePrincipal().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("managedInstanceCreateMode", this.managedInstanceCreateMode == null ? null : this.managedInstanceCreateMode.toString());
        jsonWriter.writeBooleanField("isGeneralPurposeV2", this.isGeneralPurposeV2);
        jsonWriter.writeStringField("administratorLogin", this.administratorLogin);
        jsonWriter.writeStringField("administratorLoginPassword", this.administratorLoginPassword);
        jsonWriter.writeStringField("subnetId", this.subnetId);
        jsonWriter.writeStringField("licenseType", this.licenseType == null ? null : this.licenseType.toString());
        jsonWriter.writeStringField("hybridSecondaryUsage", this.hybridSecondaryUsage == null ? null : this.hybridSecondaryUsage.toString());
        jsonWriter.writeNumberField("vCores", (Number)this.vCores);
        jsonWriter.writeNumberField("storageSizeInGB", (Number)this.storageSizeInGB);
        jsonWriter.writeNumberField("storageIOps", (Number)this.storageIOps);
        jsonWriter.writeNumberField("storageThroughputMBps", (Number)this.storageThroughputMBps);
        jsonWriter.writeStringField("collation", this.collation);
        jsonWriter.writeStringField("dnsZonePartner", this.dnsZonePartner);
        jsonWriter.writeBooleanField("publicDataEndpointEnabled", this.publicDataEndpointEnabled);
        jsonWriter.writeStringField("sourceManagedInstanceId", this.sourceManagedInstanceId);
        jsonWriter.writeStringField("restorePointInTime", this.restorePointInTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.restorePointInTime));
        jsonWriter.writeStringField("proxyOverride", this.proxyOverride == null ? null : this.proxyOverride.toString());
        jsonWriter.writeStringField("timezoneId", this.timezoneId);
        jsonWriter.writeStringField("instancePoolId", this.instancePoolId);
        jsonWriter.writeStringField("maintenanceConfigurationId", this.maintenanceConfigurationId);
        jsonWriter.writeStringField("minimalTlsVersion", this.minimalTlsVersion);
        jsonWriter.writeStringField("requestedBackupStorageRedundancy", this.requestedBackupStorageRedundancy == null ? null : this.requestedBackupStorageRedundancy.toString());
        jsonWriter.writeBooleanField("zoneRedundant", this.zoneRedundant);
        jsonWriter.writeStringField("primaryUserAssignedIdentityId", this.primaryUserAssignedIdentityId);
        jsonWriter.writeStringField("keyId", this.keyId);
        jsonWriter.writeJsonField("administrators", (JsonSerializable)this.administrators);
        jsonWriter.writeJsonField("servicePrincipal", (JsonSerializable)this.servicePrincipal);
        jsonWriter.writeStringField("pricingModel", this.pricingModel == null ? null : this.pricingModel.toString());
        jsonWriter.writeStringField("authenticationMetadata", this.authenticationMetadata == null ? null : this.authenticationMetadata.toString());
        jsonWriter.writeStringField("databaseFormat", this.databaseFormat == null ? null : this.databaseFormat.toString());
        return jsonWriter.writeEndObject();
    }

    public static ManagedInstanceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedInstanceProperties)jsonReader.readObject(reader -> {
            ManagedInstanceProperties deserializedManagedInstanceProperties = new ManagedInstanceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedManagedInstanceProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("managedInstanceCreateMode".equals(fieldName)) {
                    deserializedManagedInstanceProperties.managedInstanceCreateMode = ManagedServerCreateMode.fromString(reader.getString());
                    continue;
                }
                if ("fullyQualifiedDomainName".equals(fieldName)) {
                    deserializedManagedInstanceProperties.fullyQualifiedDomainName = reader.getString();
                    continue;
                }
                if ("isGeneralPurposeV2".equals(fieldName)) {
                    deserializedManagedInstanceProperties.isGeneralPurposeV2 = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("administratorLogin".equals(fieldName)) {
                    deserializedManagedInstanceProperties.administratorLogin = reader.getString();
                    continue;
                }
                if ("administratorLoginPassword".equals(fieldName)) {
                    deserializedManagedInstanceProperties.administratorLoginPassword = reader.getString();
                    continue;
                }
                if ("subnetId".equals(fieldName)) {
                    deserializedManagedInstanceProperties.subnetId = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedManagedInstanceProperties.state = reader.getString();
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    deserializedManagedInstanceProperties.licenseType = ManagedInstanceLicenseType.fromString(reader.getString());
                    continue;
                }
                if ("hybridSecondaryUsage".equals(fieldName)) {
                    deserializedManagedInstanceProperties.hybridSecondaryUsage = HybridSecondaryUsage.fromString(reader.getString());
                    continue;
                }
                if ("hybridSecondaryUsageDetected".equals(fieldName)) {
                    deserializedManagedInstanceProperties.hybridSecondaryUsageDetected = HybridSecondaryUsageDetected.fromString(reader.getString());
                    continue;
                }
                if ("vCores".equals(fieldName)) {
                    deserializedManagedInstanceProperties.vCores = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("storageSizeInGB".equals(fieldName)) {
                    deserializedManagedInstanceProperties.storageSizeInGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("storageIOps".equals(fieldName)) {
                    deserializedManagedInstanceProperties.storageIOps = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("storageThroughputMBps".equals(fieldName)) {
                    deserializedManagedInstanceProperties.storageThroughputMBps = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("collation".equals(fieldName)) {
                    deserializedManagedInstanceProperties.collation = reader.getString();
                    continue;
                }
                if ("dnsZone".equals(fieldName)) {
                    deserializedManagedInstanceProperties.dnsZone = reader.getString();
                    continue;
                }
                if ("dnsZonePartner".equals(fieldName)) {
                    deserializedManagedInstanceProperties.dnsZonePartner = reader.getString();
                    continue;
                }
                if ("publicDataEndpointEnabled".equals(fieldName)) {
                    deserializedManagedInstanceProperties.publicDataEndpointEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("sourceManagedInstanceId".equals(fieldName)) {
                    deserializedManagedInstanceProperties.sourceManagedInstanceId = reader.getString();
                    continue;
                }
                if ("restorePointInTime".equals(fieldName)) {
                    deserializedManagedInstanceProperties.restorePointInTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("proxyOverride".equals(fieldName)) {
                    deserializedManagedInstanceProperties.proxyOverride = ManagedInstanceProxyOverride.fromString(reader.getString());
                    continue;
                }
                if ("timezoneId".equals(fieldName)) {
                    deserializedManagedInstanceProperties.timezoneId = reader.getString();
                    continue;
                }
                if ("instancePoolId".equals(fieldName)) {
                    deserializedManagedInstanceProperties.instancePoolId = reader.getString();
                    continue;
                }
                if ("maintenanceConfigurationId".equals(fieldName)) {
                    deserializedManagedInstanceProperties.maintenanceConfigurationId = reader.getString();
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedManagedInstanceProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> ManagedInstancePecProperty.fromJson(reader1));
                    continue;
                }
                if ("minimalTlsVersion".equals(fieldName)) {
                    deserializedManagedInstanceProperties.minimalTlsVersion = reader.getString();
                    continue;
                }
                if ("currentBackupStorageRedundancy".equals(fieldName)) {
                    deserializedManagedInstanceProperties.currentBackupStorageRedundancy = BackupStorageRedundancy.fromString(reader.getString());
                    continue;
                }
                if ("requestedBackupStorageRedundancy".equals(fieldName)) {
                    deserializedManagedInstanceProperties.requestedBackupStorageRedundancy = BackupStorageRedundancy.fromString(reader.getString());
                    continue;
                }
                if ("zoneRedundant".equals(fieldName)) {
                    deserializedManagedInstanceProperties.zoneRedundant = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("primaryUserAssignedIdentityId".equals(fieldName)) {
                    deserializedManagedInstanceProperties.primaryUserAssignedIdentityId = reader.getString();
                    continue;
                }
                if ("keyId".equals(fieldName)) {
                    deserializedManagedInstanceProperties.keyId = reader.getString();
                    continue;
                }
                if ("administrators".equals(fieldName)) {
                    deserializedManagedInstanceProperties.administrators = ManagedInstanceExternalAdministrator.fromJson(reader);
                    continue;
                }
                if ("servicePrincipal".equals(fieldName)) {
                    deserializedManagedInstanceProperties.servicePrincipal = ServicePrincipal.fromJson(reader);
                    continue;
                }
                if ("virtualClusterId".equals(fieldName)) {
                    deserializedManagedInstanceProperties.virtualClusterId = reader.getString();
                    continue;
                }
                if ("externalGovernanceStatus".equals(fieldName)) {
                    deserializedManagedInstanceProperties.externalGovernanceStatus = ExternalGovernanceStatus.fromString(reader.getString());
                    continue;
                }
                if ("pricingModel".equals(fieldName)) {
                    deserializedManagedInstanceProperties.pricingModel = FreemiumType.fromString(reader.getString());
                    continue;
                }
                if ("createTime".equals(fieldName)) {
                    deserializedManagedInstanceProperties.createTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("authenticationMetadata".equals(fieldName)) {
                    deserializedManagedInstanceProperties.authenticationMetadata = AuthMetadataLookupModes.fromString(reader.getString());
                    continue;
                }
                if ("databaseFormat".equals(fieldName)) {
                    deserializedManagedInstanceProperties.databaseFormat = ManagedInstanceDatabaseFormat.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedInstanceProperties;
        });
    }
}

