/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ManagedDatabaseRestoreDetailsBackupSetProperties;
import com.azure.resourcemanager.sql.models.ManagedDatabaseRestoreDetailsUnrestorableFileProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ManagedDatabaseRestoreDetailsProperties
implements JsonSerializable<ManagedDatabaseRestoreDetailsProperties> {
    private String type;
    private String status;
    private String blockReason;
    private String lastUploadedFileName;
    private OffsetDateTime lastUploadedFileTime;
    private String lastRestoredFileName;
    private OffsetDateTime lastRestoredFileTime;
    private Integer percentCompleted;
    private Integer currentRestoredSizeMB;
    private Integer currentRestorePlanSizeMB;
    private String currentBackupType;
    private String currentRestoringFileName;
    private Integer numberOfFilesDetected;
    private Integer numberOfFilesQueued;
    private Integer numberOfFilesSkipped;
    private Integer numberOfFilesRestoring;
    private Integer numberOfFilesRestored;
    private Integer numberOfFilesUnrestorable;
    private List<ManagedDatabaseRestoreDetailsBackupSetProperties> fullBackupSets;
    private List<ManagedDatabaseRestoreDetailsBackupSetProperties> diffBackupSets;
    private List<ManagedDatabaseRestoreDetailsBackupSetProperties> logBackupSets;
    private List<ManagedDatabaseRestoreDetailsUnrestorableFileProperties> unrestorableFiles;

    public String type() {
        return this.type;
    }

    public String status() {
        return this.status;
    }

    public String blockReason() {
        return this.blockReason;
    }

    public String lastUploadedFileName() {
        return this.lastUploadedFileName;
    }

    public OffsetDateTime lastUploadedFileTime() {
        return this.lastUploadedFileTime;
    }

    public String lastRestoredFileName() {
        return this.lastRestoredFileName;
    }

    public OffsetDateTime lastRestoredFileTime() {
        return this.lastRestoredFileTime;
    }

    public Integer percentCompleted() {
        return this.percentCompleted;
    }

    public Integer currentRestoredSizeMB() {
        return this.currentRestoredSizeMB;
    }

    public Integer currentRestorePlanSizeMB() {
        return this.currentRestorePlanSizeMB;
    }

    public String currentBackupType() {
        return this.currentBackupType;
    }

    public String currentRestoringFileName() {
        return this.currentRestoringFileName;
    }

    public Integer numberOfFilesDetected() {
        return this.numberOfFilesDetected;
    }

    public Integer numberOfFilesQueued() {
        return this.numberOfFilesQueued;
    }

    public Integer numberOfFilesSkipped() {
        return this.numberOfFilesSkipped;
    }

    public Integer numberOfFilesRestoring() {
        return this.numberOfFilesRestoring;
    }

    public Integer numberOfFilesRestored() {
        return this.numberOfFilesRestored;
    }

    public Integer numberOfFilesUnrestorable() {
        return this.numberOfFilesUnrestorable;
    }

    public List<ManagedDatabaseRestoreDetailsBackupSetProperties> fullBackupSets() {
        return this.fullBackupSets;
    }

    public List<ManagedDatabaseRestoreDetailsBackupSetProperties> diffBackupSets() {
        return this.diffBackupSets;
    }

    public List<ManagedDatabaseRestoreDetailsBackupSetProperties> logBackupSets() {
        return this.logBackupSets;
    }

    public List<ManagedDatabaseRestoreDetailsUnrestorableFileProperties> unrestorableFiles() {
        return this.unrestorableFiles;
    }

    public void validate() {
        if (this.fullBackupSets() != null) {
            this.fullBackupSets().forEach(e -> e.validate());
        }
        if (this.diffBackupSets() != null) {
            this.diffBackupSets().forEach(e -> e.validate());
        }
        if (this.logBackupSets() != null) {
            this.logBackupSets().forEach(e -> e.validate());
        }
        if (this.unrestorableFiles() != null) {
            this.unrestorableFiles().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ManagedDatabaseRestoreDetailsProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedDatabaseRestoreDetailsProperties)jsonReader.readObject(reader -> {
            ManagedDatabaseRestoreDetailsProperties deserializedManagedDatabaseRestoreDetailsProperties = new ManagedDatabaseRestoreDetailsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.type = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.status = reader.getString();
                    continue;
                }
                if ("blockReason".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.blockReason = reader.getString();
                    continue;
                }
                if ("lastUploadedFileName".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.lastUploadedFileName = reader.getString();
                    continue;
                }
                if ("lastUploadedFileTime".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.lastUploadedFileTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastRestoredFileName".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.lastRestoredFileName = reader.getString();
                    continue;
                }
                if ("lastRestoredFileTime".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.lastRestoredFileTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("percentCompleted".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.percentCompleted = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("currentRestoredSizeMB".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.currentRestoredSizeMB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("currentRestorePlanSizeMB".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.currentRestorePlanSizeMB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("currentBackupType".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.currentBackupType = reader.getString();
                    continue;
                }
                if ("currentRestoringFileName".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.currentRestoringFileName = reader.getString();
                    continue;
                }
                if ("numberOfFilesDetected".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.numberOfFilesDetected = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("numberOfFilesQueued".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.numberOfFilesQueued = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("numberOfFilesSkipped".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.numberOfFilesSkipped = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("numberOfFilesRestoring".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.numberOfFilesRestoring = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("numberOfFilesRestored".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.numberOfFilesRestored = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("numberOfFilesUnrestorable".equals(fieldName)) {
                    deserializedManagedDatabaseRestoreDetailsProperties.numberOfFilesUnrestorable = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("fullBackupSets".equals(fieldName)) {
                    List fullBackupSets;
                    deserializedManagedDatabaseRestoreDetailsProperties.fullBackupSets = fullBackupSets = reader.readArray(reader1 -> ManagedDatabaseRestoreDetailsBackupSetProperties.fromJson(reader1));
                    continue;
                }
                if ("diffBackupSets".equals(fieldName)) {
                    List diffBackupSets;
                    deserializedManagedDatabaseRestoreDetailsProperties.diffBackupSets = diffBackupSets = reader.readArray(reader1 -> ManagedDatabaseRestoreDetailsBackupSetProperties.fromJson(reader1));
                    continue;
                }
                if ("logBackupSets".equals(fieldName)) {
                    List logBackupSets;
                    deserializedManagedDatabaseRestoreDetailsProperties.logBackupSets = logBackupSets = reader.readArray(reader1 -> ManagedDatabaseRestoreDetailsBackupSetProperties.fromJson(reader1));
                    continue;
                }
                if ("unrestorableFiles".equals(fieldName)) {
                    List unrestorableFiles;
                    deserializedManagedDatabaseRestoreDetailsProperties.unrestorableFiles = unrestorableFiles = reader.readArray(reader1 -> ManagedDatabaseRestoreDetailsUnrestorableFileProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedDatabaseRestoreDetailsProperties;
        });
    }
}

