/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.BackupStorageAccessTier;
import com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import com.azure.resourcemanager.sql.models.SetLegalHoldImmutability;
import com.azure.resourcemanager.sql.models.TimeBasedImmutability;
import com.azure.resourcemanager.sql.models.TimeBasedImmutabilityMode;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class LongTermRetentionBackupProperties
implements JsonSerializable<LongTermRetentionBackupProperties> {
    private String serverName;
    private OffsetDateTime serverCreateTime;
    private String databaseName;
    private OffsetDateTime databaseDeletionTime;
    private OffsetDateTime backupTime;
    private OffsetDateTime backupExpirationTime;
    private BackupStorageRedundancy backupStorageRedundancy;
    private BackupStorageRedundancy requestedBackupStorageRedundancy;
    private Boolean isBackupImmutable;
    private TimeBasedImmutability timeBasedImmutability;
    private TimeBasedImmutabilityMode timeBasedImmutabilityMode;
    private SetLegalHoldImmutability legalHoldImmutability;
    private BackupStorageAccessTier backupStorageAccessTier;

    public String serverName() {
        return this.serverName;
    }

    public OffsetDateTime serverCreateTime() {
        return this.serverCreateTime;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public OffsetDateTime databaseDeletionTime() {
        return this.databaseDeletionTime;
    }

    public OffsetDateTime backupTime() {
        return this.backupTime;
    }

    public OffsetDateTime backupExpirationTime() {
        return this.backupExpirationTime;
    }

    public BackupStorageRedundancy backupStorageRedundancy() {
        return this.backupStorageRedundancy;
    }

    public BackupStorageRedundancy requestedBackupStorageRedundancy() {
        return this.requestedBackupStorageRedundancy;
    }

    public LongTermRetentionBackupProperties withRequestedBackupStorageRedundancy(BackupStorageRedundancy requestedBackupStorageRedundancy) {
        this.requestedBackupStorageRedundancy = requestedBackupStorageRedundancy;
        return this;
    }

    public Boolean isBackupImmutable() {
        return this.isBackupImmutable;
    }

    public LongTermRetentionBackupProperties withIsBackupImmutable(Boolean isBackupImmutable) {
        this.isBackupImmutable = isBackupImmutable;
        return this;
    }

    public TimeBasedImmutability timeBasedImmutability() {
        return this.timeBasedImmutability;
    }

    public LongTermRetentionBackupProperties withTimeBasedImmutability(TimeBasedImmutability timeBasedImmutability) {
        this.timeBasedImmutability = timeBasedImmutability;
        return this;
    }

    public TimeBasedImmutabilityMode timeBasedImmutabilityMode() {
        return this.timeBasedImmutabilityMode;
    }

    public LongTermRetentionBackupProperties withTimeBasedImmutabilityMode(TimeBasedImmutabilityMode timeBasedImmutabilityMode) {
        this.timeBasedImmutabilityMode = timeBasedImmutabilityMode;
        return this;
    }

    public SetLegalHoldImmutability legalHoldImmutability() {
        return this.legalHoldImmutability;
    }

    public LongTermRetentionBackupProperties withLegalHoldImmutability(SetLegalHoldImmutability legalHoldImmutability) {
        this.legalHoldImmutability = legalHoldImmutability;
        return this;
    }

    public BackupStorageAccessTier backupStorageAccessTier() {
        return this.backupStorageAccessTier;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("requestedBackupStorageRedundancy", this.requestedBackupStorageRedundancy == null ? null : this.requestedBackupStorageRedundancy.toString());
        jsonWriter.writeBooleanField("isBackupImmutable", this.isBackupImmutable);
        jsonWriter.writeStringField("timeBasedImmutability", this.timeBasedImmutability == null ? null : this.timeBasedImmutability.toString());
        jsonWriter.writeStringField("timeBasedImmutabilityMode", this.timeBasedImmutabilityMode == null ? null : this.timeBasedImmutabilityMode.toString());
        jsonWriter.writeStringField("legalHoldImmutability", this.legalHoldImmutability == null ? null : this.legalHoldImmutability.toString());
        return jsonWriter.writeEndObject();
    }

    public static LongTermRetentionBackupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (LongTermRetentionBackupProperties)jsonReader.readObject(reader -> {
            LongTermRetentionBackupProperties deserializedLongTermRetentionBackupProperties = new LongTermRetentionBackupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serverName".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.serverName = reader.getString();
                    continue;
                }
                if ("serverCreateTime".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.serverCreateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.databaseName = reader.getString();
                    continue;
                }
                if ("databaseDeletionTime".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.databaseDeletionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("backupTime".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.backupTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("backupExpirationTime".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.backupExpirationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("backupStorageRedundancy".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.backupStorageRedundancy = BackupStorageRedundancy.fromString(reader.getString());
                    continue;
                }
                if ("requestedBackupStorageRedundancy".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.requestedBackupStorageRedundancy = BackupStorageRedundancy.fromString(reader.getString());
                    continue;
                }
                if ("isBackupImmutable".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.isBackupImmutable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("timeBasedImmutability".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.timeBasedImmutability = TimeBasedImmutability.fromString(reader.getString());
                    continue;
                }
                if ("timeBasedImmutabilityMode".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.timeBasedImmutabilityMode = TimeBasedImmutabilityMode.fromString(reader.getString());
                    continue;
                }
                if ("legalHoldImmutability".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.legalHoldImmutability = SetLegalHoldImmutability.fromString(reader.getString());
                    continue;
                }
                if ("backupStorageAccessTier".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.backupStorageAccessTier = BackupStorageAccessTier.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLongTermRetentionBackupProperties;
        });
    }
}

