/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.AlwaysEncryptedEnclaveType;
import com.azure.resourcemanager.sql.models.AvailabilityZoneType;
import com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import com.azure.resourcemanager.sql.models.CatalogCollationType;
import com.azure.resourcemanager.sql.models.CreateMode;
import com.azure.resourcemanager.sql.models.DatabaseKey;
import com.azure.resourcemanager.sql.models.DatabaseLicenseType;
import com.azure.resourcemanager.sql.models.DatabaseReadScale;
import com.azure.resourcemanager.sql.models.DatabaseStatus;
import com.azure.resourcemanager.sql.models.FreeLimitExhaustionBehavior;
import com.azure.resourcemanager.sql.models.SampleName;
import com.azure.resourcemanager.sql.models.SecondaryType;
import com.azure.resourcemanager.sql.models.Sku;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class DatabaseProperties
implements JsonSerializable<DatabaseProperties> {
    private CreateMode createMode;
    private String collation;
    private Long maxSizeBytes;
    private SampleName sampleName;
    private String elasticPoolId;
    private String sourceDatabaseId;
    private DatabaseStatus status;
    private UUID databaseId;
    private OffsetDateTime creationDate;
    private String currentServiceObjectiveName;
    private String requestedServiceObjectiveName;
    private String defaultSecondaryLocation;
    private String failoverGroupId;
    private OffsetDateTime restorePointInTime;
    private OffsetDateTime sourceDatabaseDeletionDate;
    private String recoveryServicesRecoveryPointId;
    private String longTermRetentionBackupResourceId;
    private String recoverableDatabaseId;
    private String restorableDroppedDatabaseId;
    private CatalogCollationType catalogCollation;
    private Boolean zoneRedundant;
    private DatabaseLicenseType licenseType;
    private Long maxLogSizeBytes;
    private OffsetDateTime earliestRestoreDate;
    private DatabaseReadScale readScale;
    private Integer highAvailabilityReplicaCount;
    private SecondaryType secondaryType;
    private Sku currentSku;
    private Integer autoPauseDelay;
    private BackupStorageRedundancy currentBackupStorageRedundancy;
    private BackupStorageRedundancy requestedBackupStorageRedundancy;
    private Double minCapacity;
    private OffsetDateTime pausedDate;
    private OffsetDateTime resumedDate;
    private String maintenanceConfigurationId;
    private Boolean isLedgerOn;
    private Boolean isInfraEncryptionEnabled;
    private UUID federatedClientId;
    private Map<String, DatabaseKey> keys;
    private String encryptionProtector;
    private AlwaysEncryptedEnclaveType preferredEnclaveType;
    private Boolean useFreeLimit;
    private FreeLimitExhaustionBehavior freeLimitExhaustionBehavior;
    private String sourceResourceId;
    private Boolean manualCutover;
    private Boolean performCutover;
    private AvailabilityZoneType availabilityZone;
    private Boolean encryptionProtectorAutoRotation;

    public CreateMode createMode() {
        return this.createMode;
    }

    public DatabaseProperties withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public String collation() {
        return this.collation;
    }

    public DatabaseProperties withCollation(String collation) {
        this.collation = collation;
        return this;
    }

    public Long maxSizeBytes() {
        return this.maxSizeBytes;
    }

    public DatabaseProperties withMaxSizeBytes(Long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    public SampleName sampleName() {
        return this.sampleName;
    }

    public DatabaseProperties withSampleName(SampleName sampleName) {
        this.sampleName = sampleName;
        return this;
    }

    public String elasticPoolId() {
        return this.elasticPoolId;
    }

    public DatabaseProperties withElasticPoolId(String elasticPoolId) {
        this.elasticPoolId = elasticPoolId;
        return this;
    }

    public String sourceDatabaseId() {
        return this.sourceDatabaseId;
    }

    public DatabaseProperties withSourceDatabaseId(String sourceDatabaseId) {
        this.sourceDatabaseId = sourceDatabaseId;
        return this;
    }

    public DatabaseStatus status() {
        return this.status;
    }

    public UUID databaseId() {
        return this.databaseId;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public String currentServiceObjectiveName() {
        return this.currentServiceObjectiveName;
    }

    public String requestedServiceObjectiveName() {
        return this.requestedServiceObjectiveName;
    }

    public String defaultSecondaryLocation() {
        return this.defaultSecondaryLocation;
    }

    public String failoverGroupId() {
        return this.failoverGroupId;
    }

    public OffsetDateTime restorePointInTime() {
        return this.restorePointInTime;
    }

    public DatabaseProperties withRestorePointInTime(OffsetDateTime restorePointInTime) {
        this.restorePointInTime = restorePointInTime;
        return this;
    }

    public OffsetDateTime sourceDatabaseDeletionDate() {
        return this.sourceDatabaseDeletionDate;
    }

    public DatabaseProperties withSourceDatabaseDeletionDate(OffsetDateTime sourceDatabaseDeletionDate) {
        this.sourceDatabaseDeletionDate = sourceDatabaseDeletionDate;
        return this;
    }

    public String recoveryServicesRecoveryPointId() {
        return this.recoveryServicesRecoveryPointId;
    }

    public DatabaseProperties withRecoveryServicesRecoveryPointId(String recoveryServicesRecoveryPointId) {
        this.recoveryServicesRecoveryPointId = recoveryServicesRecoveryPointId;
        return this;
    }

    public String longTermRetentionBackupResourceId() {
        return this.longTermRetentionBackupResourceId;
    }

    public DatabaseProperties withLongTermRetentionBackupResourceId(String longTermRetentionBackupResourceId) {
        this.longTermRetentionBackupResourceId = longTermRetentionBackupResourceId;
        return this;
    }

    public String recoverableDatabaseId() {
        return this.recoverableDatabaseId;
    }

    public DatabaseProperties withRecoverableDatabaseId(String recoverableDatabaseId) {
        this.recoverableDatabaseId = recoverableDatabaseId;
        return this;
    }

    public String restorableDroppedDatabaseId() {
        return this.restorableDroppedDatabaseId;
    }

    public DatabaseProperties withRestorableDroppedDatabaseId(String restorableDroppedDatabaseId) {
        this.restorableDroppedDatabaseId = restorableDroppedDatabaseId;
        return this;
    }

    public CatalogCollationType catalogCollation() {
        return this.catalogCollation;
    }

    public DatabaseProperties withCatalogCollation(CatalogCollationType catalogCollation) {
        this.catalogCollation = catalogCollation;
        return this;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public DatabaseProperties withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public DatabaseLicenseType licenseType() {
        return this.licenseType;
    }

    public DatabaseProperties withLicenseType(DatabaseLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public Long maxLogSizeBytes() {
        return this.maxLogSizeBytes;
    }

    public OffsetDateTime earliestRestoreDate() {
        return this.earliestRestoreDate;
    }

    public DatabaseReadScale readScale() {
        return this.readScale;
    }

    public DatabaseProperties withReadScale(DatabaseReadScale readScale) {
        this.readScale = readScale;
        return this;
    }

    public Integer highAvailabilityReplicaCount() {
        return this.highAvailabilityReplicaCount;
    }

    public DatabaseProperties withHighAvailabilityReplicaCount(Integer highAvailabilityReplicaCount) {
        this.highAvailabilityReplicaCount = highAvailabilityReplicaCount;
        return this;
    }

    public SecondaryType secondaryType() {
        return this.secondaryType;
    }

    public DatabaseProperties withSecondaryType(SecondaryType secondaryType) {
        this.secondaryType = secondaryType;
        return this;
    }

    public Sku currentSku() {
        return this.currentSku;
    }

    public Integer autoPauseDelay() {
        return this.autoPauseDelay;
    }

    public DatabaseProperties withAutoPauseDelay(Integer autoPauseDelay) {
        this.autoPauseDelay = autoPauseDelay;
        return this;
    }

    public BackupStorageRedundancy currentBackupStorageRedundancy() {
        return this.currentBackupStorageRedundancy;
    }

    public BackupStorageRedundancy requestedBackupStorageRedundancy() {
        return this.requestedBackupStorageRedundancy;
    }

    public DatabaseProperties withRequestedBackupStorageRedundancy(BackupStorageRedundancy requestedBackupStorageRedundancy) {
        this.requestedBackupStorageRedundancy = requestedBackupStorageRedundancy;
        return this;
    }

    public Double minCapacity() {
        return this.minCapacity;
    }

    public DatabaseProperties withMinCapacity(Double minCapacity) {
        this.minCapacity = minCapacity;
        return this;
    }

    public OffsetDateTime pausedDate() {
        return this.pausedDate;
    }

    public OffsetDateTime resumedDate() {
        return this.resumedDate;
    }

    public String maintenanceConfigurationId() {
        return this.maintenanceConfigurationId;
    }

    public DatabaseProperties withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        this.maintenanceConfigurationId = maintenanceConfigurationId;
        return this;
    }

    public Boolean isLedgerOn() {
        return this.isLedgerOn;
    }

    public DatabaseProperties withIsLedgerOn(Boolean isLedgerOn) {
        this.isLedgerOn = isLedgerOn;
        return this;
    }

    public Boolean isInfraEncryptionEnabled() {
        return this.isInfraEncryptionEnabled;
    }

    public UUID federatedClientId() {
        return this.federatedClientId;
    }

    public DatabaseProperties withFederatedClientId(UUID federatedClientId) {
        this.federatedClientId = federatedClientId;
        return this;
    }

    public Map<String, DatabaseKey> keys() {
        return this.keys;
    }

    public DatabaseProperties withKeys(Map<String, DatabaseKey> keys) {
        this.keys = keys;
        return this;
    }

    public String encryptionProtector() {
        return this.encryptionProtector;
    }

    public DatabaseProperties withEncryptionProtector(String encryptionProtector) {
        this.encryptionProtector = encryptionProtector;
        return this;
    }

    public AlwaysEncryptedEnclaveType preferredEnclaveType() {
        return this.preferredEnclaveType;
    }

    public DatabaseProperties withPreferredEnclaveType(AlwaysEncryptedEnclaveType preferredEnclaveType) {
        this.preferredEnclaveType = preferredEnclaveType;
        return this;
    }

    public Boolean useFreeLimit() {
        return this.useFreeLimit;
    }

    public DatabaseProperties withUseFreeLimit(Boolean useFreeLimit) {
        this.useFreeLimit = useFreeLimit;
        return this;
    }

    public FreeLimitExhaustionBehavior freeLimitExhaustionBehavior() {
        return this.freeLimitExhaustionBehavior;
    }

    public DatabaseProperties withFreeLimitExhaustionBehavior(FreeLimitExhaustionBehavior freeLimitExhaustionBehavior) {
        this.freeLimitExhaustionBehavior = freeLimitExhaustionBehavior;
        return this;
    }

    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    public DatabaseProperties withSourceResourceId(String sourceResourceId) {
        this.sourceResourceId = sourceResourceId;
        return this;
    }

    public Boolean manualCutover() {
        return this.manualCutover;
    }

    public DatabaseProperties withManualCutover(Boolean manualCutover) {
        this.manualCutover = manualCutover;
        return this;
    }

    public Boolean performCutover() {
        return this.performCutover;
    }

    public DatabaseProperties withPerformCutover(Boolean performCutover) {
        this.performCutover = performCutover;
        return this;
    }

    public AvailabilityZoneType availabilityZone() {
        return this.availabilityZone;
    }

    public DatabaseProperties withAvailabilityZone(AvailabilityZoneType availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public Boolean encryptionProtectorAutoRotation() {
        return this.encryptionProtectorAutoRotation;
    }

    public DatabaseProperties withEncryptionProtectorAutoRotation(Boolean encryptionProtectorAutoRotation) {
        this.encryptionProtectorAutoRotation = encryptionProtectorAutoRotation;
        return this;
    }

    public void validate() {
        if (this.currentSku() != null) {
            this.currentSku().validate();
        }
        if (this.keys() != null) {
            this.keys().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        jsonWriter.writeStringField("collation", this.collation);
        jsonWriter.writeNumberField("maxSizeBytes", (Number)this.maxSizeBytes);
        jsonWriter.writeStringField("sampleName", this.sampleName == null ? null : this.sampleName.toString());
        jsonWriter.writeStringField("elasticPoolId", this.elasticPoolId);
        jsonWriter.writeStringField("sourceDatabaseId", this.sourceDatabaseId);
        jsonWriter.writeStringField("restorePointInTime", this.restorePointInTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.restorePointInTime));
        jsonWriter.writeStringField("sourceDatabaseDeletionDate", this.sourceDatabaseDeletionDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.sourceDatabaseDeletionDate));
        jsonWriter.writeStringField("recoveryServicesRecoveryPointId", this.recoveryServicesRecoveryPointId);
        jsonWriter.writeStringField("longTermRetentionBackupResourceId", this.longTermRetentionBackupResourceId);
        jsonWriter.writeStringField("recoverableDatabaseId", this.recoverableDatabaseId);
        jsonWriter.writeStringField("restorableDroppedDatabaseId", this.restorableDroppedDatabaseId);
        jsonWriter.writeStringField("catalogCollation", this.catalogCollation == null ? null : this.catalogCollation.toString());
        jsonWriter.writeBooleanField("zoneRedundant", this.zoneRedundant);
        jsonWriter.writeStringField("licenseType", this.licenseType == null ? null : this.licenseType.toString());
        jsonWriter.writeStringField("readScale", this.readScale == null ? null : this.readScale.toString());
        jsonWriter.writeNumberField("highAvailabilityReplicaCount", (Number)this.highAvailabilityReplicaCount);
        jsonWriter.writeStringField("secondaryType", this.secondaryType == null ? null : this.secondaryType.toString());
        jsonWriter.writeNumberField("autoPauseDelay", (Number)this.autoPauseDelay);
        jsonWriter.writeStringField("requestedBackupStorageRedundancy", this.requestedBackupStorageRedundancy == null ? null : this.requestedBackupStorageRedundancy.toString());
        jsonWriter.writeNumberField("minCapacity", (Number)this.minCapacity);
        jsonWriter.writeStringField("maintenanceConfigurationId", this.maintenanceConfigurationId);
        jsonWriter.writeBooleanField("isLedgerOn", this.isLedgerOn);
        jsonWriter.writeStringField("federatedClientId", Objects.toString(this.federatedClientId, null));
        jsonWriter.writeMapField("keys", this.keys, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("encryptionProtector", this.encryptionProtector);
        jsonWriter.writeStringField("preferredEnclaveType", this.preferredEnclaveType == null ? null : this.preferredEnclaveType.toString());
        jsonWriter.writeBooleanField("useFreeLimit", this.useFreeLimit);
        jsonWriter.writeStringField("freeLimitExhaustionBehavior", this.freeLimitExhaustionBehavior == null ? null : this.freeLimitExhaustionBehavior.toString());
        jsonWriter.writeStringField("sourceResourceId", this.sourceResourceId);
        jsonWriter.writeBooleanField("manualCutover", this.manualCutover);
        jsonWriter.writeBooleanField("performCutover", this.performCutover);
        jsonWriter.writeStringField("availabilityZone", this.availabilityZone == null ? null : this.availabilityZone.toString());
        jsonWriter.writeBooleanField("encryptionProtectorAutoRotation", this.encryptionProtectorAutoRotation);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseProperties)jsonReader.readObject(reader -> {
            DatabaseProperties deserializedDatabaseProperties = new DatabaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createMode".equals(fieldName)) {
                    deserializedDatabaseProperties.createMode = CreateMode.fromString(reader.getString());
                    continue;
                }
                if ("collation".equals(fieldName)) {
                    deserializedDatabaseProperties.collation = reader.getString();
                    continue;
                }
                if ("maxSizeBytes".equals(fieldName)) {
                    deserializedDatabaseProperties.maxSizeBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("sampleName".equals(fieldName)) {
                    deserializedDatabaseProperties.sampleName = SampleName.fromString(reader.getString());
                    continue;
                }
                if ("elasticPoolId".equals(fieldName)) {
                    deserializedDatabaseProperties.elasticPoolId = reader.getString();
                    continue;
                }
                if ("sourceDatabaseId".equals(fieldName)) {
                    deserializedDatabaseProperties.sourceDatabaseId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedDatabaseProperties.status = DatabaseStatus.fromString(reader.getString());
                    continue;
                }
                if ("databaseId".equals(fieldName)) {
                    deserializedDatabaseProperties.databaseId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("creationDate".equals(fieldName)) {
                    deserializedDatabaseProperties.creationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("currentServiceObjectiveName".equals(fieldName)) {
                    deserializedDatabaseProperties.currentServiceObjectiveName = reader.getString();
                    continue;
                }
                if ("requestedServiceObjectiveName".equals(fieldName)) {
                    deserializedDatabaseProperties.requestedServiceObjectiveName = reader.getString();
                    continue;
                }
                if ("defaultSecondaryLocation".equals(fieldName)) {
                    deserializedDatabaseProperties.defaultSecondaryLocation = reader.getString();
                    continue;
                }
                if ("failoverGroupId".equals(fieldName)) {
                    deserializedDatabaseProperties.failoverGroupId = reader.getString();
                    continue;
                }
                if ("restorePointInTime".equals(fieldName)) {
                    deserializedDatabaseProperties.restorePointInTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("sourceDatabaseDeletionDate".equals(fieldName)) {
                    deserializedDatabaseProperties.sourceDatabaseDeletionDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("recoveryServicesRecoveryPointId".equals(fieldName)) {
                    deserializedDatabaseProperties.recoveryServicesRecoveryPointId = reader.getString();
                    continue;
                }
                if ("longTermRetentionBackupResourceId".equals(fieldName)) {
                    deserializedDatabaseProperties.longTermRetentionBackupResourceId = reader.getString();
                    continue;
                }
                if ("recoverableDatabaseId".equals(fieldName)) {
                    deserializedDatabaseProperties.recoverableDatabaseId = reader.getString();
                    continue;
                }
                if ("restorableDroppedDatabaseId".equals(fieldName)) {
                    deserializedDatabaseProperties.restorableDroppedDatabaseId = reader.getString();
                    continue;
                }
                if ("catalogCollation".equals(fieldName)) {
                    deserializedDatabaseProperties.catalogCollation = CatalogCollationType.fromString(reader.getString());
                    continue;
                }
                if ("zoneRedundant".equals(fieldName)) {
                    deserializedDatabaseProperties.zoneRedundant = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    deserializedDatabaseProperties.licenseType = DatabaseLicenseType.fromString(reader.getString());
                    continue;
                }
                if ("maxLogSizeBytes".equals(fieldName)) {
                    deserializedDatabaseProperties.maxLogSizeBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("earliestRestoreDate".equals(fieldName)) {
                    deserializedDatabaseProperties.earliestRestoreDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("readScale".equals(fieldName)) {
                    deserializedDatabaseProperties.readScale = DatabaseReadScale.fromString(reader.getString());
                    continue;
                }
                if ("highAvailabilityReplicaCount".equals(fieldName)) {
                    deserializedDatabaseProperties.highAvailabilityReplicaCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("secondaryType".equals(fieldName)) {
                    deserializedDatabaseProperties.secondaryType = SecondaryType.fromString(reader.getString());
                    continue;
                }
                if ("currentSku".equals(fieldName)) {
                    deserializedDatabaseProperties.currentSku = Sku.fromJson(reader);
                    continue;
                }
                if ("autoPauseDelay".equals(fieldName)) {
                    deserializedDatabaseProperties.autoPauseDelay = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("currentBackupStorageRedundancy".equals(fieldName)) {
                    deserializedDatabaseProperties.currentBackupStorageRedundancy = BackupStorageRedundancy.fromString(reader.getString());
                    continue;
                }
                if ("requestedBackupStorageRedundancy".equals(fieldName)) {
                    deserializedDatabaseProperties.requestedBackupStorageRedundancy = BackupStorageRedundancy.fromString(reader.getString());
                    continue;
                }
                if ("minCapacity".equals(fieldName)) {
                    deserializedDatabaseProperties.minCapacity = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("pausedDate".equals(fieldName)) {
                    deserializedDatabaseProperties.pausedDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("resumedDate".equals(fieldName)) {
                    deserializedDatabaseProperties.resumedDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("maintenanceConfigurationId".equals(fieldName)) {
                    deserializedDatabaseProperties.maintenanceConfigurationId = reader.getString();
                    continue;
                }
                if ("isLedgerOn".equals(fieldName)) {
                    deserializedDatabaseProperties.isLedgerOn = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isInfraEncryptionEnabled".equals(fieldName)) {
                    deserializedDatabaseProperties.isInfraEncryptionEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("federatedClientId".equals(fieldName)) {
                    deserializedDatabaseProperties.federatedClientId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("keys".equals(fieldName)) {
                    Map keys;
                    deserializedDatabaseProperties.keys = keys = reader.readMap(reader1 -> DatabaseKey.fromJson(reader1));
                    continue;
                }
                if ("encryptionProtector".equals(fieldName)) {
                    deserializedDatabaseProperties.encryptionProtector = reader.getString();
                    continue;
                }
                if ("preferredEnclaveType".equals(fieldName)) {
                    deserializedDatabaseProperties.preferredEnclaveType = AlwaysEncryptedEnclaveType.fromString(reader.getString());
                    continue;
                }
                if ("useFreeLimit".equals(fieldName)) {
                    deserializedDatabaseProperties.useFreeLimit = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("freeLimitExhaustionBehavior".equals(fieldName)) {
                    deserializedDatabaseProperties.freeLimitExhaustionBehavior = FreeLimitExhaustionBehavior.fromString(reader.getString());
                    continue;
                }
                if ("sourceResourceId".equals(fieldName)) {
                    deserializedDatabaseProperties.sourceResourceId = reader.getString();
                    continue;
                }
                if ("manualCutover".equals(fieldName)) {
                    deserializedDatabaseProperties.manualCutover = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("performCutover".equals(fieldName)) {
                    deserializedDatabaseProperties.performCutover = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("availabilityZone".equals(fieldName)) {
                    deserializedDatabaseProperties.availabilityZone = AvailabilityZoneType.fromString(reader.getString());
                    continue;
                }
                if ("encryptionProtectorAutoRotation".equals(fieldName)) {
                    deserializedDatabaseProperties.encryptionProtectorAutoRotation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseProperties;
        });
    }
}

