/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.QueryMetricUnitType;
import java.io.IOException;

public final class QueryMetricProperties
implements JsonSerializable<QueryMetricProperties> {
    private String name;
    private String displayName;
    private QueryMetricUnitType unit;
    private Double value;
    private Double min;
    private Double max;
    private Double avg;
    private Double sum;
    private Double stdev;

    public String name() {
        return this.name;
    }

    public String displayName() {
        return this.displayName;
    }

    public QueryMetricUnitType unit() {
        return this.unit;
    }

    public Double value() {
        return this.value;
    }

    public Double min() {
        return this.min;
    }

    public Double max() {
        return this.max;
    }

    public Double avg() {
        return this.avg;
    }

    public Double sum() {
        return this.sum;
    }

    public Double stdev() {
        return this.stdev;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static QueryMetricProperties fromJson(JsonReader jsonReader) throws IOException {
        return (QueryMetricProperties)jsonReader.readObject(reader -> {
            QueryMetricProperties deserializedQueryMetricProperties = new QueryMetricProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedQueryMetricProperties.name = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedQueryMetricProperties.displayName = reader.getString();
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedQueryMetricProperties.unit = QueryMetricUnitType.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedQueryMetricProperties.value = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("min".equals(fieldName)) {
                    deserializedQueryMetricProperties.min = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("max".equals(fieldName)) {
                    deserializedQueryMetricProperties.max = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("avg".equals(fieldName)) {
                    deserializedQueryMetricProperties.avg = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("sum".equals(fieldName)) {
                    deserializedQueryMetricProperties.sum = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("stdev".equals(fieldName)) {
                    deserializedQueryMetricProperties.stdev = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQueryMetricProperties;
        });
    }
}

