/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.CapabilityStatus;
import com.azure.resourcemanager.sql.models.InstancePoolVcoresCapability;
import com.azure.resourcemanager.sql.models.LicenseTypeCapability;
import java.io.IOException;
import java.util.List;

public final class InstancePoolFamilyCapability
implements JsonSerializable<InstancePoolFamilyCapability> {
    private String name;
    private List<LicenseTypeCapability> supportedLicenseTypes;
    private List<InstancePoolVcoresCapability> supportedVcoresValues;
    private CapabilityStatus status;
    private String reason;

    public String name() {
        return this.name;
    }

    public List<LicenseTypeCapability> supportedLicenseTypes() {
        return this.supportedLicenseTypes;
    }

    public List<InstancePoolVcoresCapability> supportedVcoresValues() {
        return this.supportedVcoresValues;
    }

    public CapabilityStatus status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public InstancePoolFamilyCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public void validate() {
        if (this.supportedLicenseTypes() != null) {
            this.supportedLicenseTypes().forEach(e -> e.validate());
        }
        if (this.supportedVcoresValues() != null) {
            this.supportedVcoresValues().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    public static InstancePoolFamilyCapability fromJson(JsonReader jsonReader) throws IOException {
        return (InstancePoolFamilyCapability)jsonReader.readObject(reader -> {
            InstancePoolFamilyCapability deserializedInstancePoolFamilyCapability = new InstancePoolFamilyCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedInstancePoolFamilyCapability.name = reader.getString();
                    continue;
                }
                if ("supportedLicenseTypes".equals(fieldName)) {
                    List supportedLicenseTypes;
                    deserializedInstancePoolFamilyCapability.supportedLicenseTypes = supportedLicenseTypes = reader.readArray(reader1 -> LicenseTypeCapability.fromJson(reader1));
                    continue;
                }
                if ("supportedVcoresValues".equals(fieldName)) {
                    List supportedVcoresValues;
                    deserializedInstancePoolFamilyCapability.supportedVcoresValues = supportedVcoresValues = reader.readArray(reader1 -> InstancePoolVcoresCapability.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedInstancePoolFamilyCapability.status = CapabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedInstancePoolFamilyCapability.reason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInstancePoolFamilyCapability;
        });
    }
}

