/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class LongTermRetentionBackupProperties
implements JsonSerializable<LongTermRetentionBackupProperties> {
    private String serverName;
    private OffsetDateTime serverCreateTime;
    private String databaseName;
    private OffsetDateTime databaseDeletionTime;
    private OffsetDateTime backupTime;
    private OffsetDateTime backupExpirationTime;
    private BackupStorageRedundancy backupStorageRedundancy;
    private BackupStorageRedundancy requestedBackupStorageRedundancy;

    public String serverName() {
        return this.serverName;
    }

    public OffsetDateTime serverCreateTime() {
        return this.serverCreateTime;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public OffsetDateTime databaseDeletionTime() {
        return this.databaseDeletionTime;
    }

    public OffsetDateTime backupTime() {
        return this.backupTime;
    }

    public OffsetDateTime backupExpirationTime() {
        return this.backupExpirationTime;
    }

    public BackupStorageRedundancy backupStorageRedundancy() {
        return this.backupStorageRedundancy;
    }

    public BackupStorageRedundancy requestedBackupStorageRedundancy() {
        return this.requestedBackupStorageRedundancy;
    }

    public LongTermRetentionBackupProperties withRequestedBackupStorageRedundancy(BackupStorageRedundancy requestedBackupStorageRedundancy) {
        this.requestedBackupStorageRedundancy = requestedBackupStorageRedundancy;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("requestedBackupStorageRedundancy", this.requestedBackupStorageRedundancy == null ? null : this.requestedBackupStorageRedundancy.toString());
        return jsonWriter.writeEndObject();
    }

    public static LongTermRetentionBackupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (LongTermRetentionBackupProperties)jsonReader.readObject(reader -> {
            LongTermRetentionBackupProperties deserializedLongTermRetentionBackupProperties = new LongTermRetentionBackupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serverName".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.serverName = reader.getString();
                    continue;
                }
                if ("serverCreateTime".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.serverCreateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.databaseName = reader.getString();
                    continue;
                }
                if ("databaseDeletionTime".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.databaseDeletionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("backupTime".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.backupTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("backupExpirationTime".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.backupExpirationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("backupStorageRedundancy".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.backupStorageRedundancy = BackupStorageRedundancy.fromString(reader.getString());
                    continue;
                }
                if ("requestedBackupStorageRedundancy".equals(fieldName)) {
                    deserializedLongTermRetentionBackupProperties.requestedBackupStorageRedundancy = BackupStorageRedundancy.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLongTermRetentionBackupProperties;
        });
    }
}

