/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.CapabilityStatus;
import com.azure.resourcemanager.sql.models.ManagedInstanceVersionCapability;
import com.azure.resourcemanager.sql.models.ServerVersionCapability;
import java.io.IOException;
import java.util.List;

public final class LocationCapabilitiesInner
implements JsonSerializable<LocationCapabilitiesInner> {
    private String name;
    private List<ServerVersionCapability> supportedServerVersions;
    private List<ManagedInstanceVersionCapability> supportedManagedInstanceVersions;
    private CapabilityStatus status;
    private String reason;

    public String name() {
        return this.name;
    }

    public List<ServerVersionCapability> supportedServerVersions() {
        return this.supportedServerVersions;
    }

    public List<ManagedInstanceVersionCapability> supportedManagedInstanceVersions() {
        return this.supportedManagedInstanceVersions;
    }

    public CapabilityStatus status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public LocationCapabilitiesInner withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public void validate() {
        if (this.supportedServerVersions() != null) {
            this.supportedServerVersions().forEach(e -> e.validate());
        }
        if (this.supportedManagedInstanceVersions() != null) {
            this.supportedManagedInstanceVersions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    public static LocationCapabilitiesInner fromJson(JsonReader jsonReader) throws IOException {
        return (LocationCapabilitiesInner)jsonReader.readObject(reader -> {
            LocationCapabilitiesInner deserializedLocationCapabilitiesInner = new LocationCapabilitiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedLocationCapabilitiesInner.name = reader.getString();
                    continue;
                }
                if ("supportedServerVersions".equals(fieldName)) {
                    List supportedServerVersions;
                    deserializedLocationCapabilitiesInner.supportedServerVersions = supportedServerVersions = reader.readArray(reader1 -> ServerVersionCapability.fromJson(reader1));
                    continue;
                }
                if ("supportedManagedInstanceVersions".equals(fieldName)) {
                    List supportedManagedInstanceVersions;
                    deserializedLocationCapabilitiesInner.supportedManagedInstanceVersions = supportedManagedInstanceVersions = reader.readArray(reader1 -> ManagedInstanceVersionCapability.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedLocationCapabilitiesInner.status = CapabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedLocationCapabilitiesInner.reason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLocationCapabilitiesInner;
        });
    }
}

