/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ManagementOperationState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class DatabaseOperationProperties
implements JsonSerializable<DatabaseOperationProperties> {
    private String databaseName;
    private String operation;
    private String operationFriendlyName;
    private Integer percentComplete;
    private String serverName;
    private OffsetDateTime startTime;
    private ManagementOperationState state;
    private Integer errorCode;
    private String errorDescription;
    private Integer errorSeverity;
    private Boolean isUserError;
    private OffsetDateTime estimatedCompletionTime;
    private String description;
    private Boolean isCancellable;

    public String databaseName() {
        return this.databaseName;
    }

    public String operation() {
        return this.operation;
    }

    public String operationFriendlyName() {
        return this.operationFriendlyName;
    }

    public Integer percentComplete() {
        return this.percentComplete;
    }

    public String serverName() {
        return this.serverName;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public ManagementOperationState state() {
        return this.state;
    }

    public Integer errorCode() {
        return this.errorCode;
    }

    public String errorDescription() {
        return this.errorDescription;
    }

    public Integer errorSeverity() {
        return this.errorSeverity;
    }

    public Boolean isUserError() {
        return this.isUserError;
    }

    public OffsetDateTime estimatedCompletionTime() {
        return this.estimatedCompletionTime;
    }

    public String description() {
        return this.description;
    }

    public Boolean isCancellable() {
        return this.isCancellable;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DatabaseOperationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseOperationProperties)jsonReader.readObject(reader -> {
            DatabaseOperationProperties deserializedDatabaseOperationProperties = new DatabaseOperationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("databaseName".equals(fieldName)) {
                    deserializedDatabaseOperationProperties.databaseName = reader.getString();
                    continue;
                }
                if ("operation".equals(fieldName)) {
                    deserializedDatabaseOperationProperties.operation = reader.getString();
                    continue;
                }
                if ("operationFriendlyName".equals(fieldName)) {
                    deserializedDatabaseOperationProperties.operationFriendlyName = reader.getString();
                    continue;
                }
                if ("percentComplete".equals(fieldName)) {
                    deserializedDatabaseOperationProperties.percentComplete = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("serverName".equals(fieldName)) {
                    deserializedDatabaseOperationProperties.serverName = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedDatabaseOperationProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedDatabaseOperationProperties.state = ManagementOperationState.fromString(reader.getString());
                    continue;
                }
                if ("errorCode".equals(fieldName)) {
                    deserializedDatabaseOperationProperties.errorCode = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("errorDescription".equals(fieldName)) {
                    deserializedDatabaseOperationProperties.errorDescription = reader.getString();
                    continue;
                }
                if ("errorSeverity".equals(fieldName)) {
                    deserializedDatabaseOperationProperties.errorSeverity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("isUserError".equals(fieldName)) {
                    deserializedDatabaseOperationProperties.isUserError = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("estimatedCompletionTime".equals(fieldName)) {
                    deserializedDatabaseOperationProperties.estimatedCompletionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDatabaseOperationProperties.description = reader.getString();
                    continue;
                }
                if ("isCancellable".equals(fieldName)) {
                    deserializedDatabaseOperationProperties.isCancellable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseOperationProperties;
        });
    }
}

