/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.AdministratorType;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public final class AdministratorProperties
implements JsonSerializable<AdministratorProperties> {
    private AdministratorType administratorType;
    private String login;
    private UUID sid;
    private UUID tenantId;
    private Boolean azureADOnlyAuthentication;
    private static final ClientLogger LOGGER = new ClientLogger(AdministratorProperties.class);

    public AdministratorType administratorType() {
        return this.administratorType;
    }

    public AdministratorProperties withAdministratorType(AdministratorType administratorType) {
        this.administratorType = administratorType;
        return this;
    }

    public String login() {
        return this.login;
    }

    public AdministratorProperties withLogin(String login) {
        this.login = login;
        return this;
    }

    public UUID sid() {
        return this.sid;
    }

    public AdministratorProperties withSid(UUID sid) {
        this.sid = sid;
        return this;
    }

    public UUID tenantId() {
        return this.tenantId;
    }

    public AdministratorProperties withTenantId(UUID tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public Boolean azureADOnlyAuthentication() {
        return this.azureADOnlyAuthentication;
    }

    public void validate() {
        if (this.administratorType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property administratorType in model AdministratorProperties"));
        }
        if (this.login() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property login in model AdministratorProperties"));
        }
        if (this.sid() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sid in model AdministratorProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("administratorType", this.administratorType == null ? null : this.administratorType.toString());
        jsonWriter.writeStringField("login", this.login);
        jsonWriter.writeStringField("sid", Objects.toString(this.sid, null));
        jsonWriter.writeStringField("tenantId", Objects.toString(this.tenantId, null));
        return jsonWriter.writeEndObject();
    }

    public static AdministratorProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AdministratorProperties)jsonReader.readObject(reader -> {
            AdministratorProperties deserializedAdministratorProperties = new AdministratorProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("administratorType".equals(fieldName)) {
                    deserializedAdministratorProperties.administratorType = AdministratorType.fromString(reader.getString());
                    continue;
                }
                if ("login".equals(fieldName)) {
                    deserializedAdministratorProperties.login = reader.getString();
                    continue;
                }
                if ("sid".equals(fieldName)) {
                    deserializedAdministratorProperties.sid = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedAdministratorProperties.tenantId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("azureADOnlyAuthentication".equals(fieldName)) {
                    deserializedAdministratorProperties.azureADOnlyAuthentication = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAdministratorProperties;
        });
    }
}

