/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.CapabilityStatus;
import com.azure.resourcemanager.sql.models.EditionCapability;
import com.azure.resourcemanager.sql.models.ElasticPoolEditionCapability;
import java.io.IOException;
import java.util.List;

public final class ServerVersionCapability
implements JsonSerializable<ServerVersionCapability> {
    private String name;
    private List<EditionCapability> supportedEditions;
    private List<ElasticPoolEditionCapability> supportedElasticPoolEditions;
    private CapabilityStatus status;
    private String reason;

    public String name() {
        return this.name;
    }

    public List<EditionCapability> supportedEditions() {
        return this.supportedEditions;
    }

    public List<ElasticPoolEditionCapability> supportedElasticPoolEditions() {
        return this.supportedElasticPoolEditions;
    }

    public CapabilityStatus status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public ServerVersionCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public void validate() {
        if (this.supportedEditions() != null) {
            this.supportedEditions().forEach(e -> e.validate());
        }
        if (this.supportedElasticPoolEditions() != null) {
            this.supportedElasticPoolEditions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    public static ServerVersionCapability fromJson(JsonReader jsonReader) throws IOException {
        return (ServerVersionCapability)jsonReader.readObject(reader -> {
            ServerVersionCapability deserializedServerVersionCapability = new ServerVersionCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedServerVersionCapability.name = reader.getString();
                    continue;
                }
                if ("supportedEditions".equals(fieldName)) {
                    List supportedEditions;
                    deserializedServerVersionCapability.supportedEditions = supportedEditions = reader.readArray(reader1 -> EditionCapability.fromJson(reader1));
                    continue;
                }
                if ("supportedElasticPoolEditions".equals(fieldName)) {
                    List supportedElasticPoolEditions;
                    deserializedServerVersionCapability.supportedElasticPoolEditions = supportedElasticPoolEditions = reader.readArray(reader1 -> ElasticPoolEditionCapability.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedServerVersionCapability.status = CapabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedServerVersionCapability.reason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerVersionCapability;
        });
    }
}

