/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.NetworkIsolationSettings;
import com.azure.resourcemanager.sql.models.OperationMode;
import com.azure.resourcemanager.sql.models.StorageKeyType;
import java.io.IOException;

public final class DatabaseExtensionsProperties
implements JsonSerializable<DatabaseExtensionsProperties> {
    private OperationMode operationMode;
    private StorageKeyType storageKeyType;
    private String storageKey;
    private String storageUri;
    private String administratorLogin;
    private String administratorLoginPassword;
    private String authenticationType;
    private String databaseEdition;
    private String serviceObjectiveName;
    private String maxSizeBytes;
    private NetworkIsolationSettings networkIsolation;
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseExtensionsProperties.class);

    public OperationMode operationMode() {
        return this.operationMode;
    }

    public DatabaseExtensionsProperties withOperationMode(OperationMode operationMode) {
        this.operationMode = operationMode;
        return this;
    }

    public StorageKeyType storageKeyType() {
        return this.storageKeyType;
    }

    public DatabaseExtensionsProperties withStorageKeyType(StorageKeyType storageKeyType) {
        this.storageKeyType = storageKeyType;
        return this;
    }

    public String storageKey() {
        return this.storageKey;
    }

    public DatabaseExtensionsProperties withStorageKey(String storageKey) {
        this.storageKey = storageKey;
        return this;
    }

    public String storageUri() {
        return this.storageUri;
    }

    public DatabaseExtensionsProperties withStorageUri(String storageUri) {
        this.storageUri = storageUri;
        return this;
    }

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public DatabaseExtensionsProperties withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public DatabaseExtensionsProperties withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public String authenticationType() {
        return this.authenticationType;
    }

    public DatabaseExtensionsProperties withAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public String databaseEdition() {
        return this.databaseEdition;
    }

    public DatabaseExtensionsProperties withDatabaseEdition(String databaseEdition) {
        this.databaseEdition = databaseEdition;
        return this;
    }

    public String serviceObjectiveName() {
        return this.serviceObjectiveName;
    }

    public DatabaseExtensionsProperties withServiceObjectiveName(String serviceObjectiveName) {
        this.serviceObjectiveName = serviceObjectiveName;
        return this;
    }

    public String maxSizeBytes() {
        return this.maxSizeBytes;
    }

    public DatabaseExtensionsProperties withMaxSizeBytes(String maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    public NetworkIsolationSettings networkIsolation() {
        return this.networkIsolation;
    }

    public DatabaseExtensionsProperties withNetworkIsolation(NetworkIsolationSettings networkIsolation) {
        this.networkIsolation = networkIsolation;
        return this;
    }

    public void validate() {
        if (this.operationMode() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operationMode in model DatabaseExtensionsProperties"));
        }
        if (this.storageKeyType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageKeyType in model DatabaseExtensionsProperties"));
        }
        if (this.storageKey() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageKey in model DatabaseExtensionsProperties"));
        }
        if (this.storageUri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageUri in model DatabaseExtensionsProperties"));
        }
        if (this.networkIsolation() != null) {
            this.networkIsolation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operationMode", this.operationMode == null ? null : this.operationMode.toString());
        jsonWriter.writeStringField("storageKeyType", this.storageKeyType == null ? null : this.storageKeyType.toString());
        jsonWriter.writeStringField("storageKey", this.storageKey);
        jsonWriter.writeStringField("storageUri", this.storageUri);
        jsonWriter.writeStringField("administratorLogin", this.administratorLogin);
        jsonWriter.writeStringField("administratorLoginPassword", this.administratorLoginPassword);
        jsonWriter.writeStringField("authenticationType", this.authenticationType);
        jsonWriter.writeStringField("databaseEdition", this.databaseEdition);
        jsonWriter.writeStringField("serviceObjectiveName", this.serviceObjectiveName);
        jsonWriter.writeStringField("maxSizeBytes", this.maxSizeBytes);
        jsonWriter.writeJsonField("networkIsolation", (JsonSerializable)this.networkIsolation);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseExtensionsProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseExtensionsProperties)jsonReader.readObject(reader -> {
            DatabaseExtensionsProperties deserializedDatabaseExtensionsProperties = new DatabaseExtensionsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operationMode".equals(fieldName)) {
                    deserializedDatabaseExtensionsProperties.operationMode = OperationMode.fromString(reader.getString());
                    continue;
                }
                if ("storageKeyType".equals(fieldName)) {
                    deserializedDatabaseExtensionsProperties.storageKeyType = StorageKeyType.fromString(reader.getString());
                    continue;
                }
                if ("storageKey".equals(fieldName)) {
                    deserializedDatabaseExtensionsProperties.storageKey = reader.getString();
                    continue;
                }
                if ("storageUri".equals(fieldName)) {
                    deserializedDatabaseExtensionsProperties.storageUri = reader.getString();
                    continue;
                }
                if ("administratorLogin".equals(fieldName)) {
                    deserializedDatabaseExtensionsProperties.administratorLogin = reader.getString();
                    continue;
                }
                if ("administratorLoginPassword".equals(fieldName)) {
                    deserializedDatabaseExtensionsProperties.administratorLoginPassword = reader.getString();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedDatabaseExtensionsProperties.authenticationType = reader.getString();
                    continue;
                }
                if ("databaseEdition".equals(fieldName)) {
                    deserializedDatabaseExtensionsProperties.databaseEdition = reader.getString();
                    continue;
                }
                if ("serviceObjectiveName".equals(fieldName)) {
                    deserializedDatabaseExtensionsProperties.serviceObjectiveName = reader.getString();
                    continue;
                }
                if ("maxSizeBytes".equals(fieldName)) {
                    deserializedDatabaseExtensionsProperties.maxSizeBytes = reader.getString();
                    continue;
                }
                if ("networkIsolation".equals(fieldName)) {
                    deserializedDatabaseExtensionsProperties.networkIsolation = NetworkIsolationSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseExtensionsProperties;
        });
    }
}

