/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.FailoverGroupProperties;
import com.azure.resourcemanager.sql.models.FailoverGroupReadOnlyEndpoint;
import com.azure.resourcemanager.sql.models.FailoverGroupReadWriteEndpoint;
import com.azure.resourcemanager.sql.models.FailoverGroupReplicationRole;
import com.azure.resourcemanager.sql.models.PartnerInfo;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class FailoverGroupInner
extends ProxyResource {
    private String location;
    private Map<String, String> tags;
    private FailoverGroupProperties innerProperties;
    private String type;
    private String name;
    private String id;

    public String location() {
        return this.location;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public FailoverGroupInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private FailoverGroupProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public FailoverGroupReadWriteEndpoint readWriteEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().readWriteEndpoint();
    }

    public FailoverGroupInner withReadWriteEndpoint(FailoverGroupReadWriteEndpoint readWriteEndpoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FailoverGroupProperties();
        }
        this.innerProperties().withReadWriteEndpoint(readWriteEndpoint);
        return this;
    }

    public FailoverGroupReadOnlyEndpoint readOnlyEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().readOnlyEndpoint();
    }

    public FailoverGroupInner withReadOnlyEndpoint(FailoverGroupReadOnlyEndpoint readOnlyEndpoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FailoverGroupProperties();
        }
        this.innerProperties().withReadOnlyEndpoint(readOnlyEndpoint);
        return this;
    }

    public FailoverGroupReplicationRole replicationRole() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationRole();
    }

    public String replicationState() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationState();
    }

    public List<PartnerInfo> partnerServers() {
        return this.innerProperties() == null ? null : this.innerProperties().partnerServers();
    }

    public FailoverGroupInner withPartnerServers(List<PartnerInfo> partnerServers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FailoverGroupProperties();
        }
        this.innerProperties().withPartnerServers(partnerServers);
        return this;
    }

    public List<String> databases() {
        return this.innerProperties() == null ? null : this.innerProperties().databases();
    }

    public FailoverGroupInner withDatabases(List<String> databases) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FailoverGroupProperties();
        }
        this.innerProperties().withDatabases(databases);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static FailoverGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return (FailoverGroupInner)((Object)jsonReader.readObject(reader -> {
            FailoverGroupInner deserializedFailoverGroupInner = new FailoverGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedFailoverGroupInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedFailoverGroupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFailoverGroupInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedFailoverGroupInner.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedFailoverGroupInner.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedFailoverGroupInner.innerProperties = FailoverGroupProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFailoverGroupInner;
        }));
    }
}

