/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ReadWriteEndpointFailoverPolicy;
import java.io.IOException;

public final class FailoverGroupReadWriteEndpoint
implements JsonSerializable<FailoverGroupReadWriteEndpoint> {
    private ReadWriteEndpointFailoverPolicy failoverPolicy;
    private Integer failoverWithDataLossGracePeriodMinutes;
    private static final ClientLogger LOGGER = new ClientLogger(FailoverGroupReadWriteEndpoint.class);

    public ReadWriteEndpointFailoverPolicy failoverPolicy() {
        return this.failoverPolicy;
    }

    public FailoverGroupReadWriteEndpoint withFailoverPolicy(ReadWriteEndpointFailoverPolicy failoverPolicy) {
        this.failoverPolicy = failoverPolicy;
        return this;
    }

    public Integer failoverWithDataLossGracePeriodMinutes() {
        return this.failoverWithDataLossGracePeriodMinutes;
    }

    public FailoverGroupReadWriteEndpoint withFailoverWithDataLossGracePeriodMinutes(Integer failoverWithDataLossGracePeriodMinutes) {
        this.failoverWithDataLossGracePeriodMinutes = failoverWithDataLossGracePeriodMinutes;
        return this;
    }

    public void validate() {
        if (this.failoverPolicy() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property failoverPolicy in model FailoverGroupReadWriteEndpoint"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("failoverPolicy", this.failoverPolicy == null ? null : this.failoverPolicy.toString());
        jsonWriter.writeNumberField("failoverWithDataLossGracePeriodMinutes", (Number)this.failoverWithDataLossGracePeriodMinutes);
        return jsonWriter.writeEndObject();
    }

    public static FailoverGroupReadWriteEndpoint fromJson(JsonReader jsonReader) throws IOException {
        return (FailoverGroupReadWriteEndpoint)jsonReader.readObject(reader -> {
            FailoverGroupReadWriteEndpoint deserializedFailoverGroupReadWriteEndpoint = new FailoverGroupReadWriteEndpoint();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("failoverPolicy".equals(fieldName)) {
                    deserializedFailoverGroupReadWriteEndpoint.failoverPolicy = ReadWriteEndpointFailoverPolicy.fromString(reader.getString());
                    continue;
                }
                if ("failoverWithDataLossGracePeriodMinutes".equals(fieldName)) {
                    deserializedFailoverGroupReadWriteEndpoint.failoverWithDataLossGracePeriodMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFailoverGroupReadWriteEndpoint;
        });
    }
}

