/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.NetworkIsolationSettings;
import com.azure.resourcemanager.sql.models.StorageKeyType;
import java.io.IOException;

public final class ImportNewDatabaseDefinition
implements JsonSerializable<ImportNewDatabaseDefinition> {
    private String databaseName;
    private String edition;
    private String serviceObjectiveName;
    private String maxSizeBytes;
    private StorageKeyType storageKeyType;
    private String storageKey;
    private String storageUri;
    private String administratorLogin;
    private String administratorLoginPassword;
    private String authenticationType;
    private NetworkIsolationSettings networkIsolation;
    private static final ClientLogger LOGGER = new ClientLogger(ImportNewDatabaseDefinition.class);

    public String databaseName() {
        return this.databaseName;
    }

    public ImportNewDatabaseDefinition withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public String edition() {
        return this.edition;
    }

    public ImportNewDatabaseDefinition withEdition(String edition) {
        this.edition = edition;
        return this;
    }

    public String serviceObjectiveName() {
        return this.serviceObjectiveName;
    }

    public ImportNewDatabaseDefinition withServiceObjectiveName(String serviceObjectiveName) {
        this.serviceObjectiveName = serviceObjectiveName;
        return this;
    }

    public String maxSizeBytes() {
        return this.maxSizeBytes;
    }

    public ImportNewDatabaseDefinition withMaxSizeBytes(String maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    public StorageKeyType storageKeyType() {
        return this.storageKeyType;
    }

    public ImportNewDatabaseDefinition withStorageKeyType(StorageKeyType storageKeyType) {
        this.storageKeyType = storageKeyType;
        return this;
    }

    public String storageKey() {
        return this.storageKey;
    }

    public ImportNewDatabaseDefinition withStorageKey(String storageKey) {
        this.storageKey = storageKey;
        return this;
    }

    public String storageUri() {
        return this.storageUri;
    }

    public ImportNewDatabaseDefinition withStorageUri(String storageUri) {
        this.storageUri = storageUri;
        return this;
    }

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ImportNewDatabaseDefinition withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ImportNewDatabaseDefinition withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public String authenticationType() {
        return this.authenticationType;
    }

    public ImportNewDatabaseDefinition withAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public NetworkIsolationSettings networkIsolation() {
        return this.networkIsolation;
    }

    public ImportNewDatabaseDefinition withNetworkIsolation(NetworkIsolationSettings networkIsolation) {
        this.networkIsolation = networkIsolation;
        return this;
    }

    public void validate() {
        if (this.storageKeyType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageKeyType in model ImportNewDatabaseDefinition"));
        }
        if (this.storageKey() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageKey in model ImportNewDatabaseDefinition"));
        }
        if (this.storageUri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageUri in model ImportNewDatabaseDefinition"));
        }
        if (this.administratorLogin() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property administratorLogin in model ImportNewDatabaseDefinition"));
        }
        if (this.administratorLoginPassword() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property administratorLoginPassword in model ImportNewDatabaseDefinition"));
        }
        if (this.networkIsolation() != null) {
            this.networkIsolation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageKeyType", this.storageKeyType == null ? null : this.storageKeyType.toString());
        jsonWriter.writeStringField("storageKey", this.storageKey);
        jsonWriter.writeStringField("storageUri", this.storageUri);
        jsonWriter.writeStringField("administratorLogin", this.administratorLogin);
        jsonWriter.writeStringField("administratorLoginPassword", this.administratorLoginPassword);
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeStringField("edition", this.edition);
        jsonWriter.writeStringField("serviceObjectiveName", this.serviceObjectiveName);
        jsonWriter.writeStringField("maxSizeBytes", this.maxSizeBytes);
        jsonWriter.writeStringField("authenticationType", this.authenticationType);
        jsonWriter.writeJsonField("networkIsolation", (JsonSerializable)this.networkIsolation);
        return jsonWriter.writeEndObject();
    }

    public static ImportNewDatabaseDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (ImportNewDatabaseDefinition)jsonReader.readObject(reader -> {
            ImportNewDatabaseDefinition deserializedImportNewDatabaseDefinition = new ImportNewDatabaseDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageKeyType".equals(fieldName)) {
                    deserializedImportNewDatabaseDefinition.storageKeyType = StorageKeyType.fromString(reader.getString());
                    continue;
                }
                if ("storageKey".equals(fieldName)) {
                    deserializedImportNewDatabaseDefinition.storageKey = reader.getString();
                    continue;
                }
                if ("storageUri".equals(fieldName)) {
                    deserializedImportNewDatabaseDefinition.storageUri = reader.getString();
                    continue;
                }
                if ("administratorLogin".equals(fieldName)) {
                    deserializedImportNewDatabaseDefinition.administratorLogin = reader.getString();
                    continue;
                }
                if ("administratorLoginPassword".equals(fieldName)) {
                    deserializedImportNewDatabaseDefinition.administratorLoginPassword = reader.getString();
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedImportNewDatabaseDefinition.databaseName = reader.getString();
                    continue;
                }
                if ("edition".equals(fieldName)) {
                    deserializedImportNewDatabaseDefinition.edition = reader.getString();
                    continue;
                }
                if ("serviceObjectiveName".equals(fieldName)) {
                    deserializedImportNewDatabaseDefinition.serviceObjectiveName = reader.getString();
                    continue;
                }
                if ("maxSizeBytes".equals(fieldName)) {
                    deserializedImportNewDatabaseDefinition.maxSizeBytes = reader.getString();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedImportNewDatabaseDefinition.authenticationType = reader.getString();
                    continue;
                }
                if ("networkIsolation".equals(fieldName)) {
                    deserializedImportNewDatabaseDefinition.networkIsolation = NetworkIsolationSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImportNewDatabaseDefinition;
        });
    }
}

