/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.CoreUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.DatabaseSecurityAlertPolicyInner;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyName;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyState;
import com.azure.resourcemanager.sql.models.SqlDatabase;
import com.azure.resourcemanager.sql.models.SqlDatabaseThreatDetectionPolicy;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactor.core.publisher.Mono;

public class SqlDatabaseThreatDetectionPolicyImpl
extends ExternalChildResourceImpl<SqlDatabaseThreatDetectionPolicy, DatabaseSecurityAlertPolicyInner, SqlDatabaseImpl, SqlDatabase>
implements SqlDatabaseThreatDetectionPolicy,
SqlDatabaseThreatDetectionPolicy.SqlDatabaseThreatDetectionPolicyDefinition,
SqlDatabaseThreatDetectionPolicy.Update {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;
    private String policyName;

    protected SqlDatabaseThreatDetectionPolicyImpl(String name, SqlDatabaseImpl parent, DatabaseSecurityAlertPolicyInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.sqlServerName();
        this.policyName = name;
    }

    public String name() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).name();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public String id() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).id();
    }

    @Override
    public Region region() {
        return Region.fromName((String)((SqlDatabaseImpl)this.parent()).regionName());
    }

    @Override
    public String kind() {
        return ((SqlServerImpl)((SqlDatabaseImpl)this.parent()).parent()).kind();
    }

    @Override
    public SecurityAlertPolicyState currentState() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).state() == null ? null : SecurityAlertPolicyState.fromString(((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).state().toString());
    }

    @Override
    public String disabledAlerts() {
        List<String> disabledAlerts = ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).disabledAlerts();
        if (disabledAlerts == null) {
            return null;
        }
        return String.join((CharSequence)";", disabledAlerts);
    }

    @Override
    public List<String> disabledAlertList() {
        return CoreUtils.isNullOrEmpty(((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).disabledAlerts()) ? Collections.emptyList() : ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).disabledAlerts();
    }

    @Override
    public String emailAddresses() {
        List<String> emailAddresses = ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).emailAddresses();
        if (emailAddresses == null) {
            return null;
        }
        return String.join((CharSequence)";", emailAddresses);
    }

    @Override
    public List<String> emailAddressList() {
        return CoreUtils.isNullOrEmpty(((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).emailAddresses()) ? Collections.emptyList() : ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).emailAddresses();
    }

    @Override
    public boolean emailAccountAdmins() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).emailAccountAdmins());
    }

    @Override
    public String storageEndpoint() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).storageEndpoint();
    }

    @Override
    public String storageAccountAccessKey() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).storageAccountAccessKey();
    }

    @Override
    public int retentionDays() {
        return ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).retentionDays();
    }

    @Override
    public boolean isDefaultSecurityAlertPolicy() {
        return SecurityAlertPolicyName.DEFAULT.toString().equalsIgnoreCase(this.name());
    }

    protected Mono<DatabaseSecurityAlertPolicyInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabaseSecurityAlertPolicies().getAsync(this.resourceGroupName, this.sqlServerName, ((SqlDatabaseImpl)this.parent()).name(), SecurityAlertPolicyName.fromString(this.name()));
    }

    public Mono<SqlDatabaseThreatDetectionPolicy> createResourceAsync() {
        SqlDatabaseThreatDetectionPolicyImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabaseSecurityAlertPolicies().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, ((SqlDatabaseImpl)this.parent()).name(), SecurityAlertPolicyName.fromString(this.policyName), (DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).map(databaseSecurityAlertPolicyInner -> {
            self.setInner(databaseSecurityAlertPolicyInner);
            this.policyName = databaseSecurityAlertPolicyInner.name();
            return self;
        });
    }

    public Mono<SqlDatabaseThreatDetectionPolicy> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public SqlDatabaseThreatDetectionPolicy.Update update() {
        super.prepareUpdate();
        return this;
    }

    public Mono<Void> deleteResourceAsync() {
        return null;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withPolicyEnabled() {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withState(SecurityAlertPolicyState.ENABLED);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withPolicyDisabled() {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withState(SecurityAlertPolicyState.DISABLED);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withDefaultSecurityAlertPolicy() {
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withStorageEndpoint(String storageEndpoint) {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withStorageEndpoint(storageEndpoint);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withStorageAccountAccessKey(String storageAccountAccessKey) {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withStorageAccountAccessKey(storageAccountAccessKey);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withAlertsFilter(String alertsFilter) {
        if (alertsFilter != null) {
            ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withDisabledAlerts(Stream.of(alertsFilter.split(Pattern.quote(";"))).collect(Collectors.toList()));
        }
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withAlertsFilter(List<String> alertsFilter) {
        if (alertsFilter != null) {
            ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withDisabledAlerts(alertsFilter);
        }
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withEmailAddresses(String addresses) {
        if (addresses != null) {
            ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withEmailAddresses(Stream.of(addresses.split(Pattern.quote(";"))).collect(Collectors.toList()));
        }
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withEmailAddresses(List<String> addresses) {
        if (addresses != null) {
            ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withEmailAddresses(addresses);
        }
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withRetentionDays(int retentionDays) {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withRetentionDays(retentionDays);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withEmailToAccountAdmins() {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withEmailAccountAdmins(true);
        return this;
    }

    @Override
    public SqlDatabaseThreatDetectionPolicyImpl withoutEmailToAccountAdmins() {
        ((DatabaseSecurityAlertPolicyInner)((Object)this.innerModel())).withEmailAccountAdmins(false);
        return this;
    }
}

