/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.SyncMemberProperties;
import com.azure.resourcemanager.sql.models.SyncDirection;
import com.azure.resourcemanager.sql.models.SyncMemberDbType;
import com.azure.resourcemanager.sql.models.SyncMemberState;
import java.io.IOException;
import java.util.UUID;

public final class SyncMemberInner
extends ProxyResource {
    private SyncMemberProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private SyncMemberProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public SyncMemberDbType databaseType() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseType();
    }

    public SyncMemberInner withDatabaseType(SyncMemberDbType databaseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncMemberProperties();
        }
        this.innerProperties().withDatabaseType(databaseType);
        return this;
    }

    public String syncAgentId() {
        return this.innerProperties() == null ? null : this.innerProperties().syncAgentId();
    }

    public SyncMemberInner withSyncAgentId(String syncAgentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncMemberProperties();
        }
        this.innerProperties().withSyncAgentId(syncAgentId);
        return this;
    }

    public UUID sqlServerDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().sqlServerDatabaseId();
    }

    public SyncMemberInner withSqlServerDatabaseId(UUID sqlServerDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncMemberProperties();
        }
        this.innerProperties().withSqlServerDatabaseId(sqlServerDatabaseId);
        return this;
    }

    public String syncMemberAzureDatabaseResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().syncMemberAzureDatabaseResourceId();
    }

    public SyncMemberInner withSyncMemberAzureDatabaseResourceId(String syncMemberAzureDatabaseResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncMemberProperties();
        }
        this.innerProperties().withSyncMemberAzureDatabaseResourceId(syncMemberAzureDatabaseResourceId);
        return this;
    }

    public Boolean usePrivateLinkConnection() {
        return this.innerProperties() == null ? null : this.innerProperties().usePrivateLinkConnection();
    }

    public SyncMemberInner withUsePrivateLinkConnection(Boolean usePrivateLinkConnection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncMemberProperties();
        }
        this.innerProperties().withUsePrivateLinkConnection(usePrivateLinkConnection);
        return this;
    }

    public String privateEndpointName() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointName();
    }

    public String serverName() {
        return this.innerProperties() == null ? null : this.innerProperties().serverName();
    }

    public SyncMemberInner withServerName(String serverName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncMemberProperties();
        }
        this.innerProperties().withServerName(serverName);
        return this;
    }

    public String databaseName() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseName();
    }

    public SyncMemberInner withDatabaseName(String databaseName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncMemberProperties();
        }
        this.innerProperties().withDatabaseName(databaseName);
        return this;
    }

    public String username() {
        return this.innerProperties() == null ? null : this.innerProperties().username();
    }

    public SyncMemberInner withUsername(String username) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncMemberProperties();
        }
        this.innerProperties().withUsername(username);
        return this;
    }

    public String password() {
        return this.innerProperties() == null ? null : this.innerProperties().password();
    }

    public SyncMemberInner withPassword(String password) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncMemberProperties();
        }
        this.innerProperties().withPassword(password);
        return this;
    }

    public SyncDirection syncDirection() {
        return this.innerProperties() == null ? null : this.innerProperties().syncDirection();
    }

    public SyncMemberInner withSyncDirection(SyncDirection syncDirection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SyncMemberProperties();
        }
        this.innerProperties().withSyncDirection(syncDirection);
        return this;
    }

    public SyncMemberState syncState() {
        return this.innerProperties() == null ? null : this.innerProperties().syncState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SyncMemberInner fromJson(JsonReader jsonReader) throws IOException {
        return (SyncMemberInner)((Object)jsonReader.readObject(reader -> {
            SyncMemberInner deserializedSyncMemberInner = new SyncMemberInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSyncMemberInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSyncMemberInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSyncMemberInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSyncMemberInner.innerProperties = SyncMemberProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSyncMemberInner;
        }));
    }
}

