/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ColumnDataType;
import com.azure.resourcemanager.sql.models.TableTemporalType;
import java.io.IOException;

public final class DatabaseColumnProperties
implements JsonSerializable<DatabaseColumnProperties> {
    private ColumnDataType columnType;
    private TableTemporalType temporalType;
    private Boolean memoryOptimized;
    private Boolean isComputed;

    public ColumnDataType columnType() {
        return this.columnType;
    }

    public DatabaseColumnProperties withColumnType(ColumnDataType columnType) {
        this.columnType = columnType;
        return this;
    }

    public TableTemporalType temporalType() {
        return this.temporalType;
    }

    public DatabaseColumnProperties withTemporalType(TableTemporalType temporalType) {
        this.temporalType = temporalType;
        return this;
    }

    public Boolean memoryOptimized() {
        return this.memoryOptimized;
    }

    public DatabaseColumnProperties withMemoryOptimized(Boolean memoryOptimized) {
        this.memoryOptimized = memoryOptimized;
        return this;
    }

    public Boolean isComputed() {
        return this.isComputed;
    }

    public DatabaseColumnProperties withIsComputed(Boolean isComputed) {
        this.isComputed = isComputed;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("columnType", this.columnType == null ? null : this.columnType.toString());
        jsonWriter.writeStringField("temporalType", this.temporalType == null ? null : this.temporalType.toString());
        jsonWriter.writeBooleanField("memoryOptimized", this.memoryOptimized);
        jsonWriter.writeBooleanField("isComputed", this.isComputed);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseColumnProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseColumnProperties)jsonReader.readObject(reader -> {
            DatabaseColumnProperties deserializedDatabaseColumnProperties = new DatabaseColumnProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("columnType".equals(fieldName)) {
                    deserializedDatabaseColumnProperties.columnType = ColumnDataType.fromString(reader.getString());
                    continue;
                }
                if ("temporalType".equals(fieldName)) {
                    deserializedDatabaseColumnProperties.temporalType = TableTemporalType.fromString(reader.getString());
                    continue;
                }
                if ("memoryOptimized".equals(fieldName)) {
                    deserializedDatabaseColumnProperties.memoryOptimized = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isComputed".equals(fieldName)) {
                    deserializedDatabaseColumnProperties.isComputed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseColumnProperties;
        });
    }
}

