/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class SecurityAlertPolicyProperties
implements JsonSerializable<SecurityAlertPolicyProperties> {
    private SecurityAlertPolicyState state;
    private List<String> disabledAlerts;
    private List<String> emailAddresses;
    private Boolean emailAccountAdmins;
    private String storageEndpoint;
    private String storageAccountAccessKey;
    private Integer retentionDays;
    private OffsetDateTime creationTime;
    private static final ClientLogger LOGGER = new ClientLogger(SecurityAlertPolicyProperties.class);

    public SecurityAlertPolicyState state() {
        return this.state;
    }

    public SecurityAlertPolicyProperties withState(SecurityAlertPolicyState state) {
        this.state = state;
        return this;
    }

    public List<String> disabledAlerts() {
        return this.disabledAlerts;
    }

    public SecurityAlertPolicyProperties withDisabledAlerts(List<String> disabledAlerts) {
        this.disabledAlerts = disabledAlerts;
        return this;
    }

    public List<String> emailAddresses() {
        return this.emailAddresses;
    }

    public SecurityAlertPolicyProperties withEmailAddresses(List<String> emailAddresses) {
        this.emailAddresses = emailAddresses;
        return this;
    }

    public Boolean emailAccountAdmins() {
        return this.emailAccountAdmins;
    }

    public SecurityAlertPolicyProperties withEmailAccountAdmins(Boolean emailAccountAdmins) {
        this.emailAccountAdmins = emailAccountAdmins;
        return this;
    }

    public String storageEndpoint() {
        return this.storageEndpoint;
    }

    public SecurityAlertPolicyProperties withStorageEndpoint(String storageEndpoint) {
        this.storageEndpoint = storageEndpoint;
        return this;
    }

    public String storageAccountAccessKey() {
        return this.storageAccountAccessKey;
    }

    public SecurityAlertPolicyProperties withStorageAccountAccessKey(String storageAccountAccessKey) {
        this.storageAccountAccessKey = storageAccountAccessKey;
        return this;
    }

    public Integer retentionDays() {
        return this.retentionDays;
    }

    public SecurityAlertPolicyProperties withRetentionDays(Integer retentionDays) {
        this.retentionDays = retentionDays;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public void validate() {
        if (this.state() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property state in model SecurityAlertPolicyProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeArrayField("disabledAlerts", this.disabledAlerts, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("emailAddresses", this.emailAddresses, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("emailAccountAdmins", this.emailAccountAdmins);
        jsonWriter.writeStringField("storageEndpoint", this.storageEndpoint);
        jsonWriter.writeStringField("storageAccountAccessKey", this.storageAccountAccessKey);
        jsonWriter.writeNumberField("retentionDays", (Number)this.retentionDays);
        return jsonWriter.writeEndObject();
    }

    public static SecurityAlertPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityAlertPolicyProperties)jsonReader.readObject(reader -> {
            SecurityAlertPolicyProperties deserializedSecurityAlertPolicyProperties = new SecurityAlertPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedSecurityAlertPolicyProperties.state = SecurityAlertPolicyState.fromString(reader.getString());
                    continue;
                }
                if ("disabledAlerts".equals(fieldName)) {
                    List disabledAlerts;
                    deserializedSecurityAlertPolicyProperties.disabledAlerts = disabledAlerts = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("emailAddresses".equals(fieldName)) {
                    List emailAddresses;
                    deserializedSecurityAlertPolicyProperties.emailAddresses = emailAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("emailAccountAdmins".equals(fieldName)) {
                    deserializedSecurityAlertPolicyProperties.emailAccountAdmins = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("storageEndpoint".equals(fieldName)) {
                    deserializedSecurityAlertPolicyProperties.storageEndpoint = reader.getString();
                    continue;
                }
                if ("storageAccountAccessKey".equals(fieldName)) {
                    deserializedSecurityAlertPolicyProperties.storageAccountAccessKey = reader.getString();
                    continue;
                }
                if ("retentionDays".equals(fieldName)) {
                    deserializedSecurityAlertPolicyProperties.retentionDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedSecurityAlertPolicyProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityAlertPolicyProperties;
        });
    }
}

