/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ServerInfo
implements JsonSerializable<ServerInfo> {
    private String serverId;
    private static final ClientLogger LOGGER = new ClientLogger(ServerInfo.class);

    public String serverId() {
        return this.serverId;
    }

    public ServerInfo withServerId(String serverId) {
        this.serverId = serverId;
        return this;
    }

    public void validate() {
        if (this.serverId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serverId in model ServerInfo"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serverId", this.serverId);
        return jsonWriter.writeEndObject();
    }

    public static ServerInfo fromJson(JsonReader jsonReader) throws IOException {
        return (ServerInfo)jsonReader.readObject(reader -> {
            ServerInfo deserializedServerInfo = new ServerInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serverId".equals(fieldName)) {
                    deserializedServerInfo.serverId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerInfo;
        });
    }
}

