/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.CapabilityStatus;
import com.azure.resourcemanager.sql.models.ReadScaleCapability;
import com.azure.resourcemanager.sql.models.ServiceObjectiveCapability;
import com.azure.resourcemanager.sql.models.StorageCapability;
import java.io.IOException;
import java.util.List;

public final class EditionCapability
implements JsonSerializable<EditionCapability> {
    private String name;
    private List<ServiceObjectiveCapability> supportedServiceLevelObjectives;
    private Boolean zoneRedundant;
    private ReadScaleCapability readScale;
    private List<StorageCapability> supportedStorageCapabilities;
    private CapabilityStatus status;
    private String reason;

    public String name() {
        return this.name;
    }

    public List<ServiceObjectiveCapability> supportedServiceLevelObjectives() {
        return this.supportedServiceLevelObjectives;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public ReadScaleCapability readScale() {
        return this.readScale;
    }

    public List<StorageCapability> supportedStorageCapabilities() {
        return this.supportedStorageCapabilities;
    }

    public CapabilityStatus status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public EditionCapability withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public void validate() {
        if (this.supportedServiceLevelObjectives() != null) {
            this.supportedServiceLevelObjectives().forEach(e -> e.validate());
        }
        if (this.readScale() != null) {
            this.readScale().validate();
        }
        if (this.supportedStorageCapabilities() != null) {
            this.supportedStorageCapabilities().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    public static EditionCapability fromJson(JsonReader jsonReader) throws IOException {
        return (EditionCapability)jsonReader.readObject(reader -> {
            EditionCapability deserializedEditionCapability = new EditionCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedEditionCapability.name = reader.getString();
                    continue;
                }
                if ("supportedServiceLevelObjectives".equals(fieldName)) {
                    List supportedServiceLevelObjectives;
                    deserializedEditionCapability.supportedServiceLevelObjectives = supportedServiceLevelObjectives = reader.readArray(reader1 -> ServiceObjectiveCapability.fromJson(reader1));
                    continue;
                }
                if ("zoneRedundant".equals(fieldName)) {
                    deserializedEditionCapability.zoneRedundant = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("readScale".equals(fieldName)) {
                    deserializedEditionCapability.readScale = ReadScaleCapability.fromJson(reader);
                    continue;
                }
                if ("supportedStorageCapabilities".equals(fieldName)) {
                    List supportedStorageCapabilities;
                    deserializedEditionCapability.supportedStorageCapabilities = supportedStorageCapabilities = reader.readArray(reader1 -> StorageCapability.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedEditionCapability.status = CapabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedEditionCapability.reason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEditionCapability;
        });
    }
}

