/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.JobCredentialProperties;
import java.io.IOException;

public final class JobCredentialInner
extends ProxyResource {
    private JobCredentialProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private JobCredentialProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String username() {
        return this.innerProperties() == null ? null : this.innerProperties().username();
    }

    public JobCredentialInner withUsername(String username) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobCredentialProperties();
        }
        this.innerProperties().withUsername(username);
        return this;
    }

    public String password() {
        return this.innerProperties() == null ? null : this.innerProperties().password();
    }

    public JobCredentialInner withPassword(String password) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobCredentialProperties();
        }
        this.innerProperties().withPassword(password);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static JobCredentialInner fromJson(JsonReader jsonReader) throws IOException {
        return (JobCredentialInner)((Object)jsonReader.readObject(reader -> {
            JobCredentialInner deserializedJobCredentialInner = new JobCredentialInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedJobCredentialInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedJobCredentialInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedJobCredentialInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedJobCredentialInner.innerProperties = JobCredentialProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobCredentialInner;
        }));
    }
}

