/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.ServerConnectionPoliciesClient;
import com.azure.resourcemanager.sql.fluent.models.ServerConnectionPolicyInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.ConnectionPolicyName;
import com.azure.resourcemanager.sql.models.ServerConnectionType;
import reactor.core.publisher.Mono;

public final class ServerConnectionPoliciesClientImpl
implements ServerConnectionPoliciesClient {
    private final ClientLogger logger = new ClientLogger(ServerConnectionPoliciesClientImpl.class);
    private final ServerConnectionPoliciesService service;
    private final SqlManagementClientImpl client;

    ServerConnectionPoliciesClientImpl(SqlManagementClientImpl client) {
        this.service = (ServerConnectionPoliciesService)RestProxy.create(ServerConnectionPoliciesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<ServerConnectionPolicyInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, ConnectionPolicyName connectionPolicyName, ServerConnectionType connectionType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (connectionPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionPolicyName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        ServerConnectionPolicyInner parameters = new ServerConnectionPolicyInner();
        parameters.withConnectionType(connectionType);
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, connectionPolicyName, parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ServerConnectionPolicyInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, ConnectionPolicyName connectionPolicyName, ServerConnectionType connectionType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (connectionPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionPolicyName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        ServerConnectionPolicyInner parameters = new ServerConnectionPolicyInner();
        parameters.withConnectionType(connectionType);
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, connectionPolicyName, parameters, context);
    }

    @Override
    public Mono<ServerConnectionPolicyInner> createOrUpdateAsync(String resourceGroupName, String serverName, ConnectionPolicyName connectionPolicyName, ServerConnectionType connectionType) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, connectionPolicyName, connectionType).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ServerConnectionPolicyInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<ServerConnectionPolicyInner> createOrUpdateAsync(String resourceGroupName, String serverName, ConnectionPolicyName connectionPolicyName) {
        ServerConnectionType connectionType = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, connectionPolicyName, connectionType).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ServerConnectionPolicyInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ServerConnectionPolicyInner createOrUpdate(String resourceGroupName, String serverName, ConnectionPolicyName connectionPolicyName) {
        ServerConnectionType connectionType = null;
        return (ServerConnectionPolicyInner)((Object)this.createOrUpdateAsync(resourceGroupName, serverName, connectionPolicyName, connectionType).block());
    }

    @Override
    public Response<ServerConnectionPolicyInner> createOrUpdateWithResponse(String resourceGroupName, String serverName, ConnectionPolicyName connectionPolicyName, ServerConnectionType connectionType, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, connectionPolicyName, connectionType, context).block();
    }

    @Override
    public Mono<Response<ServerConnectionPolicyInner>> getWithResponseAsync(String resourceGroupName, String serverName, ConnectionPolicyName connectionPolicyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (connectionPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionPolicyName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, connectionPolicyName, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ServerConnectionPolicyInner>> getWithResponseAsync(String resourceGroupName, String serverName, ConnectionPolicyName connectionPolicyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (connectionPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionPolicyName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, connectionPolicyName, context);
    }

    @Override
    public Mono<ServerConnectionPolicyInner> getAsync(String resourceGroupName, String serverName, ConnectionPolicyName connectionPolicyName) {
        return this.getWithResponseAsync(resourceGroupName, serverName, connectionPolicyName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ServerConnectionPolicyInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ServerConnectionPolicyInner get(String resourceGroupName, String serverName, ConnectionPolicyName connectionPolicyName) {
        return (ServerConnectionPolicyInner)((Object)this.getAsync(resourceGroupName, serverName, connectionPolicyName).block());
    }

    @Override
    public Response<ServerConnectionPolicyInner> getWithResponse(String resourceGroupName, String serverName, ConnectionPolicyName connectionPolicyName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serverName, connectionPolicyName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientS")
    private static interface ServerConnectionPoliciesService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/connectionPolicies/{connectionPolicyName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerConnectionPolicyInner>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @PathParam(value="connectionPolicyName") ConnectionPolicyName var6, @BodyParam(value="application/json") ServerConnectionPolicyInner var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/connectionPolicies/{connectionPolicyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerConnectionPolicyInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @PathParam(value="connectionPolicyName") ConnectionPolicyName var6, Context var7);
    }
}

