/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.VirtualNetworkRuleInner;
import com.azure.resourcemanager.sql.implementation.SqlChildrenOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.azure.resourcemanager.sql.implementation.SqlVirtualNetworkRuleImpl;
import com.azure.resourcemanager.sql.implementation.SqlVirtualNetworkRulesAsExternalChildResourcesImpl;
import com.azure.resourcemanager.sql.models.SqlServer;
import com.azure.resourcemanager.sql.models.SqlVirtualNetworkRule;
import com.azure.resourcemanager.sql.models.SqlVirtualNetworkRuleOperations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlVirtualNetworkRuleOperationsImpl
extends SqlChildrenOperationsImpl<SqlVirtualNetworkRule>
implements SqlVirtualNetworkRuleOperations,
SqlVirtualNetworkRuleOperations.SqlVirtualNetworkRuleActionsDefinition {
    private SqlVirtualNetworkRulesAsExternalChildResourcesImpl sqlVirtualNetworkRules;

    SqlVirtualNetworkRuleOperationsImpl(SqlServer parent, SqlServerManager sqlServerManager) {
        super(parent, sqlServerManager);
        Objects.requireNonNull(parent);
        this.sqlVirtualNetworkRules = new SqlVirtualNetworkRulesAsExternalChildResourcesImpl(sqlServerManager, "SqlVirtualNetworkRule");
    }

    SqlVirtualNetworkRuleOperationsImpl(SqlServerManager sqlServerManager) {
        super(null, sqlServerManager);
        this.sqlVirtualNetworkRules = new SqlVirtualNetworkRulesAsExternalChildResourcesImpl(sqlServerManager, "SqlVirtualNetworkRule");
    }

    @Override
    public SqlVirtualNetworkRule getBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        VirtualNetworkRuleInner inner = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getVirtualNetworkRules().get(resourceGroupName, sqlServerName, name);
        return inner != null ? new SqlVirtualNetworkRuleImpl(resourceGroupName, sqlServerName, inner.name(), inner, this.sqlServerManager) : null;
    }

    @Override
    public Mono<SqlVirtualNetworkRule> getBySqlServerAsync(String resourceGroupName, String sqlServerName, String name) {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getVirtualNetworkRules().getAsync(resourceGroupName, sqlServerName, name).map(inner -> new SqlVirtualNetworkRuleImpl(resourceGroupName, sqlServerName, inner.name(), (VirtualNetworkRuleInner)((Object)inner), this.sqlServerManager));
    }

    @Override
    public SqlVirtualNetworkRule getBySqlServer(SqlServer sqlServer, String name) {
        if (sqlServer == null) {
            return null;
        }
        VirtualNetworkRuleInner inner = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getVirtualNetworkRules().get(sqlServer.resourceGroupName(), sqlServer.name(), name);
        return inner != null ? new SqlVirtualNetworkRuleImpl(inner.name(), (SqlServerImpl)sqlServer, inner, this.sqlServerManager) : null;
    }

    @Override
    public Mono<SqlVirtualNetworkRule> getBySqlServerAsync(SqlServer sqlServer, String name) {
        Objects.requireNonNull(sqlServer);
        return ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getVirtualNetworkRules().getAsync(sqlServer.resourceGroupName(), sqlServer.name(), name).map(inner -> new SqlVirtualNetworkRuleImpl(inner.name(), (SqlServerImpl)sqlServer, (VirtualNetworkRuleInner)((Object)inner), (SqlServerManager)((Object)((Object)sqlServer.manager()))));
    }

    @Override
    public void deleteBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getVirtualNetworkRules().delete(resourceGroupName, sqlServerName, name);
    }

    @Override
    public Mono<Void> deleteBySqlServerAsync(String resourceGroupName, String sqlServerName, String name) {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getVirtualNetworkRules().deleteAsync(resourceGroupName, sqlServerName, name);
    }

    @Override
    public List<SqlVirtualNetworkRule> listBySqlServer(String resourceGroupName, String sqlServerName) {
        ArrayList<SqlVirtualNetworkRuleImpl> virtualNetworkRuleSet = new ArrayList<SqlVirtualNetworkRuleImpl>();
        for (VirtualNetworkRuleInner inner : ((SqlManagementClient)this.sqlServerManager.serviceClient()).getVirtualNetworkRules().listByServer(resourceGroupName, sqlServerName)) {
            virtualNetworkRuleSet.add(new SqlVirtualNetworkRuleImpl(resourceGroupName, sqlServerName, inner.name(), inner, this.sqlServerManager));
        }
        return Collections.unmodifiableList(virtualNetworkRuleSet);
    }

    @Override
    public PagedFlux<SqlVirtualNetworkRule> listBySqlServerAsync(String resourceGroupName, String sqlServerName) {
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getVirtualNetworkRules().listByServerAsync(resourceGroupName, sqlServerName), inner -> new SqlVirtualNetworkRuleImpl(resourceGroupName, sqlServerName, inner.name(), (VirtualNetworkRuleInner)((Object)inner), this.sqlServerManager));
    }

    @Override
    public List<SqlVirtualNetworkRule> listBySqlServer(SqlServer sqlServer) {
        ArrayList<SqlVirtualNetworkRuleImpl> virtualNetworkRuleSet = new ArrayList<SqlVirtualNetworkRuleImpl>();
        if (sqlServer != null) {
            for (VirtualNetworkRuleInner inner : ((SqlManagementClient)this.sqlServerManager.serviceClient()).getVirtualNetworkRules().listByServer(sqlServer.resourceGroupName(), sqlServer.name())) {
                virtualNetworkRuleSet.add(new SqlVirtualNetworkRuleImpl(inner.name(), (SqlServerImpl)sqlServer, inner, this.sqlServerManager));
            }
        }
        return Collections.unmodifiableList(virtualNetworkRuleSet);
    }

    @Override
    public PagedFlux<SqlVirtualNetworkRule> listBySqlServerAsync(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        return PagedConverter.mapPage(((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getVirtualNetworkRules().listByServerAsync(sqlServer.resourceGroupName(), sqlServer.name()), inner -> new SqlVirtualNetworkRuleImpl(inner.name(), (SqlServerImpl)sqlServer, (VirtualNetworkRuleInner)((Object)inner), this.sqlServerManager));
    }

    @Override
    public SqlVirtualNetworkRuleImpl define(String name) {
        SqlVirtualNetworkRuleImpl result = this.sqlVirtualNetworkRules.defineIndependentVirtualNetworkRule(name);
        return this.sqlServer != null ? result.withExistingSqlServer(this.sqlServer) : result;
    }
}

