/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.DatabaseVulnerabilityAssessmentRuleBaselinesClient;
import com.azure.resourcemanager.sql.fluent.models.DatabaseVulnerabilityAssessmentRuleBaselineInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.DatabaseVulnerabilityAssessmentRuleBaselineItem;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentName;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentPolicyBaselineName;
import java.util.List;
import reactor.core.publisher.Mono;

public final class DatabaseVulnerabilityAssessmentRuleBaselinesClientImpl
implements DatabaseVulnerabilityAssessmentRuleBaselinesClient {
    private final ClientLogger logger = new ClientLogger(DatabaseVulnerabilityAssessmentRuleBaselinesClientImpl.class);
    private final DatabaseVulnerabilityAssessmentRuleBaselinesService service;
    private final SqlManagementClientImpl client;

    DatabaseVulnerabilityAssessmentRuleBaselinesClientImpl(SqlManagementClientImpl client) {
        this.service = (DatabaseVulnerabilityAssessmentRuleBaselinesService)RestProxy.create(DatabaseVulnerabilityAssessmentRuleBaselinesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, this.client.getSubscriptionId(), "2017-03-01-preview", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatabaseVulnerabilityAssessmentRuleBaselineInner> getAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        return this.getWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((DatabaseVulnerabilityAssessmentRuleBaselineInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseVulnerabilityAssessmentRuleBaselineInner get(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        return (DatabaseVulnerabilityAssessmentRuleBaselineInner)((Object)this.getAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatabaseVulnerabilityAssessmentRuleBaselineInner> getWithResponse(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (baselineResults != null) {
            baselineResults.forEach(e -> e.validate());
        }
        String apiVersion = "2017-03-01-preview";
        DatabaseVulnerabilityAssessmentRuleBaselineInner parameters = new DatabaseVulnerabilityAssessmentRuleBaselineInner();
        parameters.withBaselineResults(baselineResults);
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, this.client.getSubscriptionId(), "2017-03-01-preview", parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (baselineResults != null) {
            baselineResults.forEach(e -> e.validate());
        }
        String apiVersion = "2017-03-01-preview";
        DatabaseVulnerabilityAssessmentRuleBaselineInner parameters = new DatabaseVulnerabilityAssessmentRuleBaselineInner();
        parameters.withBaselineResults(baselineResults);
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, this.client.getSubscriptionId(), "2017-03-01-preview", parameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatabaseVulnerabilityAssessmentRuleBaselineInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, baselineResults).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((DatabaseVulnerabilityAssessmentRuleBaselineInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatabaseVulnerabilityAssessmentRuleBaselineInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults = null;
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, baselineResults).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((DatabaseVulnerabilityAssessmentRuleBaselineInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseVulnerabilityAssessmentRuleBaselineInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults = null;
        return (DatabaseVulnerabilityAssessmentRuleBaselineInner)((Object)this.createOrUpdateAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, baselineResults).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatabaseVulnerabilityAssessmentRuleBaselineInner> createOrUpdateWithResponse(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, baselineResults, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, this.client.getSubscriptionId(), "2017-03-01-preview", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        return this.deleteWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName) {
        this.deleteAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String serverName, String databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, String ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientD")
    private static interface DatabaseVulnerabilityAssessmentRuleBaselinesService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var5, @PathParam(value="ruleId") String var6, @PathParam(value="baselineName") VulnerabilityAssessmentPolicyBaselineName var7, @PathParam(value="subscriptionId") String var8, @QueryParam(value="api-version") String var9, Context var10);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var5, @PathParam(value="ruleId") String var6, @PathParam(value="baselineName") VulnerabilityAssessmentPolicyBaselineName var7, @PathParam(value="subscriptionId") String var8, @QueryParam(value="api-version") String var9, @BodyParam(value="application/json") DatabaseVulnerabilityAssessmentRuleBaselineInner var10, Context var11);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="vulnerabilityAssessmentName") VulnerabilityAssessmentName var5, @PathParam(value="ruleId") String var6, @PathParam(value="baselineName") VulnerabilityAssessmentPolicyBaselineName var7, @PathParam(value="subscriptionId") String var8, @QueryParam(value="api-version") String var9, Context var10);
    }
}

