/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.dag.TaskGroup;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.DatabaseAutomaticTuningInner;
import com.azure.resourcemanager.sql.fluent.models.DatabaseInner;
import com.azure.resourcemanager.sql.fluent.models.DatabaseSecurityAlertPolicyInner;
import com.azure.resourcemanager.sql.fluent.models.DatabaseUsageInner;
import com.azure.resourcemanager.sql.fluent.models.MetricDefinitionInner;
import com.azure.resourcemanager.sql.fluent.models.MetricInner;
import com.azure.resourcemanager.sql.fluent.models.ReplicationLinkInner;
import com.azure.resourcemanager.sql.fluent.models.RestorePointInner;
import com.azure.resourcemanager.sql.fluent.models.ServiceTierAdvisorInner;
import com.azure.resourcemanager.sql.fluent.models.TransparentDataEncryptionInner;
import com.azure.resourcemanager.sql.implementation.ReplicationLinkImpl;
import com.azure.resourcemanager.sql.implementation.RestorePointImpl;
import com.azure.resourcemanager.sql.implementation.ServiceTierAdvisorImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseAutomaticTuningImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseExportRequestImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseImportRequestImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseMetricDefinitionImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseMetricImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseThreatDetectionPolicyImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseUsageMetricImpl;
import com.azure.resourcemanager.sql.implementation.SqlElasticPoolForDatabaseImpl;
import com.azure.resourcemanager.sql.implementation.SqlElasticPoolsAsExternalChildResourcesImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.azure.resourcemanager.sql.implementation.SqlSyncGroupOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlWarehouseImpl;
import com.azure.resourcemanager.sql.implementation.TransparentDataEncryptionImpl;
import com.azure.resourcemanager.sql.models.AuthenticationType;
import com.azure.resourcemanager.sql.models.CreateMode;
import com.azure.resourcemanager.sql.models.DatabaseEdition;
import com.azure.resourcemanager.sql.models.DatabaseSku;
import com.azure.resourcemanager.sql.models.DatabaseStatus;
import com.azure.resourcemanager.sql.models.DatabaseUpdate;
import com.azure.resourcemanager.sql.models.ImportRequest;
import com.azure.resourcemanager.sql.models.ReplicationLink;
import com.azure.resourcemanager.sql.models.RestorePoint;
import com.azure.resourcemanager.sql.models.SampleName;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyName;
import com.azure.resourcemanager.sql.models.ServiceObjectiveName;
import com.azure.resourcemanager.sql.models.ServiceTierAdvisor;
import com.azure.resourcemanager.sql.models.Sku;
import com.azure.resourcemanager.sql.models.SqlDatabase;
import com.azure.resourcemanager.sql.models.SqlDatabaseAutomaticTuning;
import com.azure.resourcemanager.sql.models.SqlDatabaseBasicStorage;
import com.azure.resourcemanager.sql.models.SqlDatabaseMetric;
import com.azure.resourcemanager.sql.models.SqlDatabaseMetricDefinition;
import com.azure.resourcemanager.sql.models.SqlDatabaseOperations;
import com.azure.resourcemanager.sql.models.SqlDatabasePremiumServiceObjective;
import com.azure.resourcemanager.sql.models.SqlDatabasePremiumStorage;
import com.azure.resourcemanager.sql.models.SqlDatabaseStandardServiceObjective;
import com.azure.resourcemanager.sql.models.SqlDatabaseStandardStorage;
import com.azure.resourcemanager.sql.models.SqlDatabaseThreatDetectionPolicy;
import com.azure.resourcemanager.sql.models.SqlDatabaseUsageMetric;
import com.azure.resourcemanager.sql.models.SqlElasticPool;
import com.azure.resourcemanager.sql.models.SqlRestorableDroppedDatabase;
import com.azure.resourcemanager.sql.models.SqlServer;
import com.azure.resourcemanager.sql.models.SqlSyncGroupOperations;
import com.azure.resourcemanager.sql.models.SqlWarehouse;
import com.azure.resourcemanager.sql.models.StorageKeyType;
import com.azure.resourcemanager.sql.models.TransparentDataEncryption;
import com.azure.resourcemanager.sql.models.TransparentDataEncryptionName;
import com.azure.resourcemanager.storage.models.StorageAccount;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Mono;

class SqlDatabaseImpl
extends ExternalChildResourceImpl<SqlDatabase, DatabaseInner, SqlServerImpl, SqlServer>
implements SqlDatabase,
SqlDatabase.SqlDatabaseDefinition<SqlServerImpl>,
SqlDatabase.DefinitionStages.WithExistingDatabaseAfterElasticPool<SqlServerImpl>,
SqlDatabase.DefinitionStages.WithStorageKeyAfterElasticPool<SqlServerImpl>,
SqlDatabase.DefinitionStages.WithAuthenticationAfterElasticPool<SqlServerImpl>,
SqlDatabase.DefinitionStages.WithRestorePointDatabaseAfterElasticPool<SqlServerImpl>,
SqlDatabase.Update,
SqlDatabaseOperations.DefinitionStages.WithExistingDatabaseAfterElasticPool,
SqlDatabaseOperations.DefinitionStages.WithStorageKeyAfterElasticPool,
SqlDatabaseOperations.DefinitionStages.WithAuthenticationAfterElasticPool,
SqlDatabaseOperations.DefinitionStages.WithRestorePointDatabaseAfterElasticPool,
SqlDatabaseOperations.DefinitionStages.WithCreateAfterElasticPoolOptions,
SqlDatabaseOperations.SqlDatabaseOperationsDefinition {
    private SqlElasticPoolsAsExternalChildResourcesImpl sqlElasticPools;
    protected SqlServerManager sqlServerManager;
    protected String resourceGroupName;
    protected String sqlServerName;
    protected String sqlServerLocation;
    private boolean isPatchUpdate;
    private ImportRequest importRequestInner;
    private SqlSyncGroupOperationsImpl syncGroups;

    SqlDatabaseImpl(String name, SqlServerImpl parent, DatabaseInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
        this.sqlServerLocation = parent.regionName();
        this.sqlElasticPools = null;
        this.isPatchUpdate = false;
        this.importRequestInner = null;
    }

    SqlDatabaseImpl(String resourceGroupName, String sqlServerName, String sqlServerLocation, String name, DatabaseInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerLocation = sqlServerLocation;
        this.sqlElasticPools = new SqlElasticPoolsAsExternalChildResourcesImpl(this.sqlServerManager, "SqlElasticPool");
        this.isPatchUpdate = false;
        this.importRequestInner = null;
    }

    SqlDatabaseImpl(TaskGroup.HasTaskGroup parentSqlElasticPool, String name, DatabaseInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(parentSqlElasticPool);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.sqlElasticPools = new SqlElasticPoolsAsExternalChildResourcesImpl(this.sqlServerManager, "SqlElasticPool");
        this.isPatchUpdate = false;
        this.importRequestInner = null;
    }

    public String id() {
        return ((DatabaseInner)((Object)this.innerModel())).id();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String collation() {
        return ((DatabaseInner)((Object)this.innerModel())).collation();
    }

    @Override
    public OffsetDateTime creationDate() {
        return ((DatabaseInner)((Object)this.innerModel())).creationDate();
    }

    @Override
    public String currentServiceObjectiveName() {
        return ((DatabaseInner)((Object)this.innerModel())).currentServiceObjectiveName();
    }

    @Override
    public String databaseId() {
        return ((DatabaseInner)((Object)this.innerModel())).databaseId().toString();
    }

    @Override
    public OffsetDateTime earliestRestoreDate() {
        return ((DatabaseInner)((Object)this.innerModel())).earliestRestoreDate();
    }

    @Override
    public DatabaseEdition edition() {
        return DatabaseEdition.fromString(((DatabaseInner)((Object)this.innerModel())).sku().tier());
    }

    @Override
    public long maxSizeBytes() {
        return ((DatabaseInner)((Object)this.innerModel())).maxSizeBytes();
    }

    @Override
    public String requestedServiceObjectiveName() {
        return ((DatabaseInner)((Object)this.innerModel())).requestedServiceObjectiveName();
    }

    @Override
    public DatabaseStatus status() {
        return ((DatabaseInner)((Object)this.innerModel())).status();
    }

    @Override
    public String elasticPoolId() {
        return ((DatabaseInner)((Object)this.innerModel())).elasticPoolId();
    }

    @Override
    public String elasticPoolName() {
        return ResourceUtils.nameFromResourceId((String)((DatabaseInner)((Object)this.innerModel())).elasticPoolId());
    }

    @Override
    public String defaultSecondaryLocation() {
        return ((DatabaseInner)((Object)this.innerModel())).defaultSecondaryLocation();
    }

    @Override
    public boolean isDataWarehouse() {
        return this.edition().toString().equalsIgnoreCase(DatabaseEdition.DATA_WAREHOUSE.toString());
    }

    @Override
    public SqlWarehouse asWarehouse() {
        if (this.isDataWarehouse()) {
            if (this.parent() != null) {
                return new SqlWarehouseImpl(this.name(), (SqlServerImpl)this.parent(), (DatabaseInner)((Object)this.innerModel()), this.sqlServerManager);
            }
            return new SqlWarehouseImpl(this.resourceGroupName, this.sqlServerName, this.sqlServerLocation, this.name(), (DatabaseInner)((Object)this.innerModel()), this.sqlServerManager);
        }
        return null;
    }

    @Override
    public List<RestorePoint> listRestorePoints() {
        ArrayList<RestorePointImpl> restorePoints = new ArrayList<RestorePointImpl>();
        PagedIterable<RestorePointInner> restorePointInners = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getRestorePoints().listByDatabase(this.resourceGroupName, this.sqlServerName, this.name());
        for (RestorePointInner inner : restorePointInners) {
            restorePoints.add(new RestorePointImpl(this.resourceGroupName, this.sqlServerName, inner));
        }
        return Collections.unmodifiableList(restorePoints);
    }

    @Override
    public PagedFlux<RestorePoint> listRestorePointsAsync() {
        SqlDatabaseImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getRestorePoints().listByDatabaseAsync(this.resourceGroupName, this.sqlServerName, this.name()).mapPage(restorePointInner -> new RestorePointImpl(self.resourceGroupName, self.sqlServerName, (RestorePointInner)((Object)restorePointInner)));
    }

    @Override
    public Map<String, ReplicationLink> listReplicationLinks() {
        HashMap<String, ReplicationLinkImpl> replicationLinkMap = new HashMap<String, ReplicationLinkImpl>();
        PagedIterable<ReplicationLinkInner> replicationLinkInners = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getReplicationLinks().listByDatabase(this.resourceGroupName, this.sqlServerName, this.name());
        for (ReplicationLinkInner inner : replicationLinkInners) {
            replicationLinkMap.put(inner.name(), new ReplicationLinkImpl(this.resourceGroupName, this.sqlServerName, inner, this.sqlServerManager));
        }
        return Collections.unmodifiableMap(replicationLinkMap);
    }

    @Override
    public PagedFlux<ReplicationLink> listReplicationLinksAsync() {
        SqlDatabaseImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getReplicationLinks().listByDatabaseAsync(this.resourceGroupName, this.sqlServerName, this.name()).mapPage(replicationLinkInner -> new ReplicationLinkImpl(self.resourceGroupName, self.sqlServerName, (ReplicationLinkInner)((Object)replicationLinkInner), self.sqlServerManager));
    }

    @Override
    public SqlDatabaseExportRequestImpl exportTo(String storageUri) {
        return new SqlDatabaseExportRequestImpl(this, this.sqlServerManager).exportTo(storageUri);
    }

    @Override
    public SqlDatabaseExportRequestImpl exportTo(StorageAccount storageAccount, String containerName, String fileName) {
        Objects.requireNonNull(storageAccount);
        return new SqlDatabaseExportRequestImpl(this, this.sqlServerManager).exportTo(storageAccount, containerName, fileName);
    }

    @Override
    public SqlDatabaseExportRequestImpl exportTo(Creatable<StorageAccount> storageAccountCreatable, String containerName, String fileName) {
        Objects.requireNonNull(storageAccountCreatable);
        return new SqlDatabaseExportRequestImpl(this, this.sqlServerManager).exportTo((Creatable)storageAccountCreatable, containerName, fileName);
    }

    @Override
    public SqlDatabaseImportRequestImpl importBacpac(String storageUri) {
        return new SqlDatabaseImportRequestImpl(this, this.sqlServerManager).importFrom(storageUri);
    }

    @Override
    public SqlDatabaseImportRequestImpl importBacpac(StorageAccount storageAccount, String containerName, String fileName) {
        Objects.requireNonNull(storageAccount);
        return new SqlDatabaseImportRequestImpl(this, this.sqlServerManager).importFrom(storageAccount, containerName, fileName);
    }

    @Override
    public SqlDatabaseThreatDetectionPolicy.DefinitionStages.Blank defineThreatDetectionPolicy(String policyName) {
        return new SqlDatabaseThreatDetectionPolicyImpl(policyName, this, new DatabaseSecurityAlertPolicyInner(), this.sqlServerManager);
    }

    @Override
    public SqlDatabaseThreatDetectionPolicy getThreatDetectionPolicy() {
        DatabaseSecurityAlertPolicyInner policyInner = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabaseThreatDetectionPolicies().get(this.resourceGroupName, this.sqlServerName, this.name(), SecurityAlertPolicyName.DEFAULT);
        return policyInner != null ? new SqlDatabaseThreatDetectionPolicyImpl(policyInner.name(), this, policyInner, this.sqlServerManager) : null;
    }

    @Override
    public SqlDatabaseAutomaticTuning getDatabaseAutomaticTuning() {
        DatabaseAutomaticTuningInner databaseAutomaticTuningInner = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabaseAutomaticTunings().get(this.resourceGroupName, this.sqlServerName, this.name());
        return databaseAutomaticTuningInner != null ? new SqlDatabaseAutomaticTuningImpl(this, databaseAutomaticTuningInner) : null;
    }

    @Override
    public List<SqlDatabaseUsageMetric> listUsageMetrics() {
        ArrayList<SqlDatabaseUsageMetricImpl> databaseUsageMetrics = new ArrayList<SqlDatabaseUsageMetricImpl>();
        PagedIterable<DatabaseUsageInner> databaseUsageInners = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabaseUsages().listByDatabase(this.resourceGroupName, this.sqlServerName, this.name());
        for (DatabaseUsageInner inner : databaseUsageInners) {
            databaseUsageMetrics.add(new SqlDatabaseUsageMetricImpl(inner));
        }
        return Collections.unmodifiableList(databaseUsageMetrics);
    }

    @Override
    public PagedFlux<SqlDatabaseUsageMetric> listUsageMetricsAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabaseUsages().listByDatabaseAsync(this.resourceGroupName, this.sqlServerName, this.name()).mapPage(SqlDatabaseUsageMetricImpl::new);
    }

    @Override
    public SqlDatabase rename(String newDatabaseName) {
        ResourceId resourceId = ResourceId.fromString((String)this.id());
        String newId = resourceId.parent().id() + "/databases/" + newDatabaseName;
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabases().rename(this.resourceGroupName, this.sqlServerName, this.name(), newId);
        return (SqlDatabase)this.sqlServerManager.sqlServers().databases().getBySqlServer(this.resourceGroupName, this.sqlServerName, newDatabaseName);
    }

    @Override
    public Mono<SqlDatabase> renameAsync(String newDatabaseName) {
        SqlDatabaseImpl self = this;
        ResourceId resourceId = ResourceId.fromString((String)this.id());
        String newId = resourceId.parent().id() + "/databases/" + newDatabaseName;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabases().renameAsync(this.resourceGroupName, this.sqlServerName, self.name(), newId).flatMap(aVoid -> self.sqlServerManager.sqlServers().databases().getBySqlServerAsync(self.resourceGroupName, self.sqlServerName, newDatabaseName));
    }

    @Override
    public List<SqlDatabaseMetric> listMetrics(String filter) {
        ArrayList<SqlDatabaseMetricImpl> sqlDatabaseMetrics = new ArrayList<SqlDatabaseMetricImpl>();
        PagedIterable<MetricInner> metricInners = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabases().listMetrics(this.resourceGroupName, this.sqlServerName, this.name(), filter);
        for (MetricInner metricInner : metricInners) {
            sqlDatabaseMetrics.add(new SqlDatabaseMetricImpl(metricInner));
        }
        return Collections.unmodifiableList(sqlDatabaseMetrics);
    }

    @Override
    public PagedFlux<SqlDatabaseMetric> listMetricsAsync(String filter) {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabases().listMetricsAsync(this.resourceGroupName, this.sqlServerName, this.name(), filter).mapPage(SqlDatabaseMetricImpl::new);
    }

    @Override
    public List<SqlDatabaseMetricDefinition> listMetricDefinitions() {
        ArrayList<SqlDatabaseMetricDefinitionImpl> sqlDatabaseMetricDefinitions = new ArrayList<SqlDatabaseMetricDefinitionImpl>();
        PagedIterable<MetricDefinitionInner> metricDefinitionInners = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabases().listMetricDefinitions(this.resourceGroupName, this.sqlServerName, this.name());
        for (MetricDefinitionInner metricDefinitionInner : metricDefinitionInners) {
            sqlDatabaseMetricDefinitions.add(new SqlDatabaseMetricDefinitionImpl(metricDefinitionInner));
        }
        return Collections.unmodifiableList(sqlDatabaseMetricDefinitions);
    }

    @Override
    public PagedFlux<SqlDatabaseMetricDefinition> listMetricDefinitionsAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabases().listMetricDefinitionsAsync(this.resourceGroupName, this.sqlServerName, this.name()).mapPage(SqlDatabaseMetricDefinitionImpl::new);
    }

    @Override
    public TransparentDataEncryption getTransparentDataEncryption() {
        TransparentDataEncryptionInner transparentDataEncryptionInner = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getTransparentDataEncryptions().get(this.resourceGroupName, this.sqlServerName, this.name(), TransparentDataEncryptionName.CURRENT);
        return transparentDataEncryptionInner == null ? null : new TransparentDataEncryptionImpl(this.resourceGroupName, this.sqlServerName, transparentDataEncryptionInner, this.sqlServerManager);
    }

    @Override
    public Mono<TransparentDataEncryption> getTransparentDataEncryptionAsync() {
        SqlDatabaseImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getTransparentDataEncryptions().getAsync(this.resourceGroupName, this.sqlServerName, this.name(), TransparentDataEncryptionName.CURRENT).map(transparentDataEncryptionInner -> new TransparentDataEncryptionImpl(self.resourceGroupName, self.sqlServerName, (TransparentDataEncryptionInner)((Object)transparentDataEncryptionInner), self.sqlServerManager));
    }

    @Override
    public Map<String, ServiceTierAdvisor> listServiceTierAdvisors() {
        HashMap<String, ServiceTierAdvisorImpl> serviceTierAdvisorMap = new HashMap<String, ServiceTierAdvisorImpl>();
        PagedIterable<ServiceTierAdvisorInner> serviceTierAdvisorInners = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServiceTierAdvisors().listByDatabase(this.resourceGroupName, this.sqlServerName, this.name());
        for (ServiceTierAdvisorInner serviceTierAdvisorInner : serviceTierAdvisorInners) {
            serviceTierAdvisorMap.put(serviceTierAdvisorInner.name(), new ServiceTierAdvisorImpl(this.resourceGroupName, this.sqlServerName, serviceTierAdvisorInner, this.sqlServerManager));
        }
        return Collections.unmodifiableMap(serviceTierAdvisorMap);
    }

    @Override
    public PagedFlux<ServiceTierAdvisor> listServiceTierAdvisorsAsync() {
        SqlDatabaseImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServiceTierAdvisors().listByDatabaseAsync(this.resourceGroupName, this.sqlServerName, this.name()).mapPage(serviceTierAdvisorInner -> new ServiceTierAdvisorImpl(self.resourceGroupName, self.sqlServerName, (ServiceTierAdvisorInner)((Object)serviceTierAdvisorInner), self.sqlServerManager));
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)this.id());
    }

    @Override
    public String regionName() {
        return ((DatabaseInner)((Object)this.innerModel())).location();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public SqlSyncGroupOperations.SqlSyncGroupActionsDefinition syncGroups() {
        if (this.syncGroups == null) {
            this.syncGroups = new SqlSyncGroupOperationsImpl(this, this.sqlServerManager);
        }
        return this.syncGroups;
    }

    SqlDatabaseImpl withPatchUpdate() {
        this.isPatchUpdate = true;
        return this;
    }

    protected Mono<DatabaseInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabases().getAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    void addParentDependency(TaskGroup.HasTaskGroup parentDependency) {
        this.addDependency(parentDependency);
    }

    public void beforeGroupCreateOrUpdate() {
        if (this.importRequestInner != null && this.elasticPoolId() != null) {
            SqlDatabaseImpl self = this;
            String epId = this.elasticPoolId();
            this.addPostRunDependent(context -> {
                self.importRequestInner = null;
                self.withExistingElasticPoolId(epId);
                return self.createResourceAsync().flatMap(sqlDatabase -> context.voidMono());
            });
        }
    }

    public Mono<SqlDatabase> createResourceAsync() {
        SqlDatabaseImpl self = this;
        ((DatabaseInner)((Object)this.innerModel())).withLocation(this.sqlServerLocation);
        if (this.importRequestInner != null) {
            this.importRequestInner.withDatabaseName(this.name());
            if (this.importRequestInner.edition() == null) {
                this.importRequestInner.withEdition(this.edition());
            }
            if (this.importRequestInner.serviceObjectiveName() == null && ((DatabaseInner)((Object)this.innerModel())).sku() != null) {
                this.importRequestInner.withServiceObjectiveName(ServiceObjectiveName.fromString(((DatabaseInner)((Object)this.innerModel())).sku().name()));
            }
            if (this.importRequestInner.maxSizeBytes() == null) {
                this.importRequestInner.withMaxSizeBytes(String.valueOf(((DatabaseInner)((Object)this.innerModel())).maxSizeBytes()));
            }
            return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabases().importMethodAsync(this.resourceGroupName, this.sqlServerName, this.importRequestInner).then(Mono.defer(() -> {
                if (self.elasticPoolId() != null) {
                    self.importRequestInner = null;
                    return self.withExistingElasticPoolId(self.elasticPoolId()).withPatchUpdate().updateResourceAsync();
                }
                return self.refreshAsync();
            }));
        }
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabases().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.name(), (DatabaseInner)((Object)this.innerModel())).map(inner -> {
            self.setInner(inner);
            return self;
        });
    }

    public Mono<SqlDatabase> updateResourceAsync() {
        if (this.isPatchUpdate) {
            SqlDatabaseImpl self = this;
            DatabaseUpdate databaseUpdateInner = new DatabaseUpdate().withTags(((DatabaseInner)((Object)self.innerModel())).tags()).withCollation(((DatabaseInner)((Object)self.innerModel())).collation()).withSourceDatabaseId(((DatabaseInner)((Object)self.innerModel())).sourceDatabaseId()).withCreateMode(((DatabaseInner)((Object)self.innerModel())).createMode()).withSku(((DatabaseInner)((Object)self.innerModel())).sku()).withMaxSizeBytes(((DatabaseInner)((Object)this.innerModel())).maxSizeBytes()).withElasticPoolId(((DatabaseInner)((Object)this.innerModel())).elasticPoolId());
            return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabases().updateAsync(this.resourceGroupName, this.sqlServerName, this.name(), databaseUpdateInner).map(inner -> {
                self.setInner(inner);
                self.isPatchUpdate = false;
                return self;
            });
        }
        return this.createResourceAsync();
    }

    public SqlDatabaseImpl update() {
        super.prepareUpdate();
        return this;
    }

    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        if (this.sqlElasticPools != null) {
            this.sqlElasticPools.clear();
        }
        this.importRequestInner = null;
        return Mono.empty();
    }

    public Mono<Void> deleteResourceAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabases().deleteAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    public void delete() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getDatabases().delete(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    public Mono<Void> deleteAsync() {
        return this.deleteResourceAsync();
    }

    @Override
    public SqlDatabaseImpl withExistingSqlServer(String resourceGroupName, String sqlServerName, String sqlServerLocation) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerLocation = sqlServerLocation;
        return this;
    }

    @Override
    public SqlDatabaseImpl withExistingSqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        this.resourceGroupName = sqlServer.resourceGroupName();
        this.sqlServerName = sqlServer.name();
        this.sqlServerLocation = sqlServer.regionName();
        return this;
    }

    public SqlServerImpl attach() {
        return (SqlServerImpl)this.parent();
    }

    @Override
    public SqlDatabaseImpl withoutElasticPool() {
        ((DatabaseInner)((Object)this.innerModel())).withElasticPoolId(null);
        return this;
    }

    private String generateElasticPoolIdFromName(String elasticPoolName) {
        if (this.parentId() == null) {
            return ResourceUtils.constructResourceId((String)this.sqlServerManager.subscriptionId(), (String)this.resourceGroupName, (String)"Microsoft.Sql", (String)"elasticPools", (String)elasticPoolName, (String)String.format("servers/%s", this.sqlServerName));
        }
        return String.format("%s/elasticPools/%s", this.parentId(), elasticPoolName);
    }

    @Override
    public SqlDatabaseImpl withExistingElasticPool(String elasticPoolName) {
        ((DatabaseInner)((Object)this.innerModel())).withSku(null);
        ((DatabaseInner)((Object)this.innerModel())).withElasticPoolId(this.generateElasticPoolIdFromName(elasticPoolName));
        return this;
    }

    @Override
    public SqlDatabaseImpl withExistingElasticPoolId(String elasticPoolId) {
        ((DatabaseInner)((Object)this.innerModel())).withSku(null);
        ((DatabaseInner)((Object)this.innerModel())).withElasticPoolId(elasticPoolId);
        return this;
    }

    @Override
    public SqlDatabaseImpl withExistingElasticPool(SqlElasticPool sqlElasticPool) {
        Objects.requireNonNull(sqlElasticPool);
        ((DatabaseInner)((Object)this.innerModel())).withSku(null);
        ((DatabaseInner)((Object)this.innerModel())).withElasticPoolId(sqlElasticPool.id());
        return this;
    }

    @Override
    public SqlDatabaseImpl withNewElasticPool(Creatable<SqlElasticPool> sqlElasticPool) {
        Objects.requireNonNull(sqlElasticPool);
        ((DatabaseInner)((Object)this.innerModel())).withSku(null);
        ((DatabaseInner)((Object)this.innerModel())).withElasticPoolId(this.generateElasticPoolIdFromName(sqlElasticPool.name()));
        this.addDependency(sqlElasticPool);
        return this;
    }

    public SqlElasticPoolForDatabaseImpl defineElasticPool(String elasticPoolName) {
        if (this.sqlElasticPools == null) {
            this.sqlElasticPools = new SqlElasticPoolsAsExternalChildResourcesImpl(this.taskGroup(), this.sqlServerManager, "SqlElasticPool");
        }
        ((DatabaseInner)((Object)this.innerModel())).withSku(null);
        ((DatabaseInner)((Object)this.innerModel())).withElasticPoolId(this.generateElasticPoolIdFromName(elasticPoolName));
        return new SqlElasticPoolForDatabaseImpl(this, this.sqlElasticPools.defineIndependentElasticPool(elasticPoolName).withExistingSqlServer(this.resourceGroupName, this.sqlServerName, this.sqlServerLocation));
    }

    @Override
    public SqlDatabaseImpl fromRestorableDroppedDatabase(SqlRestorableDroppedDatabase restorableDroppedDatabase) {
        Objects.requireNonNull(restorableDroppedDatabase);
        ((DatabaseInner)((Object)this.innerModel())).withRestorableDroppedDatabaseId(restorableDroppedDatabase.id()).withCreateMode(CreateMode.RESTORE);
        return this;
    }

    private void initializeImportRequestInner() {
        this.importRequestInner = new ImportRequest();
        if (this.elasticPoolId() != null) {
            this.importRequestInner.withEdition(DatabaseEdition.BASIC);
            this.importRequestInner.withServiceObjectiveName(ServiceObjectiveName.BASIC);
            this.importRequestInner.withMaxSizeBytes(Long.toString(SqlDatabaseBasicStorage.MAX_2_GB.capacity()));
        } else {
            this.withStandardEdition(SqlDatabaseStandardServiceObjective.S0);
        }
    }

    @Override
    public SqlDatabaseImpl importFrom(String storageUri) {
        this.initializeImportRequestInner();
        this.importRequestInner.withStorageUri(storageUri);
        return this;
    }

    @Override
    public SqlDatabaseImpl importFrom(StorageAccount storageAccount, String containerName, String fileName) {
        SqlDatabaseImpl self = this;
        Objects.requireNonNull(storageAccount);
        this.initializeImportRequestInner();
        this.addDependency(context -> storageAccount.getKeysAsync().flatMap(storageAccountKeys -> Mono.justOrEmpty(storageAccountKeys.stream().findFirst())).flatMap(storageAccountKey -> {
            self.importRequestInner.withStorageUri(String.format("%s%s/%s", storageAccount.endPoints().primary().blob(), containerName, fileName));
            self.importRequestInner.withStorageKeyType(StorageKeyType.STORAGE_ACCESS_KEY);
            self.importRequestInner.withStorageKey(storageAccountKey.value());
            return context.voidMono();
        }));
        return this;
    }

    @Override
    public SqlDatabaseImpl withStorageAccessKey(String storageAccessKey) {
        this.importRequestInner.withStorageKeyType(StorageKeyType.STORAGE_ACCESS_KEY);
        this.importRequestInner.withStorageKey(storageAccessKey);
        return this;
    }

    @Override
    public SqlDatabaseImpl withSharedAccessKey(String sharedAccessKey) {
        this.importRequestInner.withStorageKeyType(StorageKeyType.SHARED_ACCESS_KEY);
        this.importRequestInner.withStorageKey(sharedAccessKey);
        return this;
    }

    @Override
    public SqlDatabaseImpl withSqlAdministratorLoginAndPassword(String administratorLogin, String administratorPassword) {
        this.importRequestInner.withAuthenticationType(AuthenticationType.SQL);
        this.importRequestInner.withAdministratorLogin(administratorLogin);
        this.importRequestInner.withAdministratorLoginPassword(administratorPassword);
        return this;
    }

    @Override
    public SqlDatabaseImpl withActiveDirectoryLoginAndPassword(String administratorLogin, String administratorPassword) {
        this.importRequestInner.withAuthenticationType(AuthenticationType.ADPASSWORD);
        this.importRequestInner.withAdministratorLogin(administratorLogin);
        this.importRequestInner.withAdministratorLoginPassword(administratorPassword);
        return this;
    }

    @Override
    public SqlDatabaseImpl fromRestorePoint(RestorePoint restorePoint) {
        return this.fromRestorePoint(restorePoint, restorePoint.earliestRestoreDate());
    }

    @Override
    public SqlDatabaseImpl fromRestorePoint(RestorePoint restorePoint, OffsetDateTime restorePointDateTime) {
        Objects.requireNonNull(restorePoint);
        ((DatabaseInner)((Object)this.innerModel())).withRestorePointInTime(restorePointDateTime);
        return this.withSourceDatabase(restorePoint.databaseId()).withMode(CreateMode.POINT_IN_TIME_RESTORE);
    }

    @Override
    public SqlDatabaseImpl withSourceDatabase(String sourceDatabaseId) {
        ((DatabaseInner)((Object)this.innerModel())).withSourceDatabaseId(sourceDatabaseId);
        return this;
    }

    @Override
    public SqlDatabaseImpl withSourceDatabase(SqlDatabase sourceDatabase) {
        return this.withSourceDatabase(sourceDatabase.id());
    }

    @Override
    public SqlDatabaseImpl withMode(CreateMode createMode) {
        ((DatabaseInner)((Object)this.innerModel())).withCreateMode(createMode);
        return this;
    }

    @Override
    public SqlDatabaseImpl withCollation(String collation) {
        ((DatabaseInner)((Object)this.innerModel())).withCollation(collation);
        return this;
    }

    @Override
    public SqlDatabaseImpl withMaxSizeBytes(long maxSizeBytes) {
        ((DatabaseInner)((Object)this.innerModel())).withMaxSizeBytes(maxSizeBytes);
        return this;
    }

    @Override
    public SqlDatabaseImpl withBasicEdition() {
        return this.withBasicEdition(SqlDatabaseBasicStorage.MAX_2_GB);
    }

    @Override
    public SqlDatabaseImpl withBasicEdition(SqlDatabaseBasicStorage maxStorageCapacity) {
        Sku sku = new Sku().withName(ServiceObjectiveName.BASIC.toString()).withTier(DatabaseEdition.BASIC.toString());
        ((DatabaseInner)((Object)this.innerModel())).withSku(sku);
        ((DatabaseInner)((Object)this.innerModel())).withMaxSizeBytes(maxStorageCapacity.capacity());
        ((DatabaseInner)((Object)this.innerModel())).withElasticPoolId(null);
        return this;
    }

    @Override
    public SqlDatabaseImpl withStandardEdition(SqlDatabaseStandardServiceObjective serviceObjective) {
        return this.withStandardEdition(serviceObjective, SqlDatabaseStandardStorage.MAX_250_GB);
    }

    @Override
    public SqlDatabaseImpl withStandardEdition(SqlDatabaseStandardServiceObjective serviceObjective, SqlDatabaseStandardStorage maxStorageCapacity) {
        Sku sku = new Sku().withName(serviceObjective.toString()).withTier(DatabaseEdition.STANDARD.toString());
        ((DatabaseInner)((Object)this.innerModel())).withSku(sku);
        ((DatabaseInner)((Object)this.innerModel())).withMaxSizeBytes(maxStorageCapacity.capacity());
        ((DatabaseInner)((Object)this.innerModel())).withElasticPoolId(null);
        return this;
    }

    @Override
    public SqlDatabaseImpl withPremiumEdition(SqlDatabasePremiumServiceObjective serviceObjective) {
        return this.withPremiumEdition(serviceObjective, SqlDatabasePremiumStorage.MAX_500_GB);
    }

    @Override
    public SqlDatabaseImpl withPremiumEdition(SqlDatabasePremiumServiceObjective serviceObjective, SqlDatabasePremiumStorage maxStorageCapacity) {
        Sku sku = new Sku().withName(serviceObjective.toString()).withTier(DatabaseEdition.PREMIUM.toString());
        ((DatabaseInner)((Object)this.innerModel())).withSku(sku);
        ((DatabaseInner)((Object)this.innerModel())).withMaxSizeBytes(maxStorageCapacity.capacity());
        ((DatabaseInner)((Object)this.innerModel())).withElasticPoolId(null);
        return this;
    }

    @Override
    public SqlDatabaseImpl withSku(DatabaseSku sku) {
        return this.withSku(sku.toSku());
    }

    @Override
    public SqlDatabaseImpl withSku(Sku sku) {
        ((DatabaseInner)((Object)this.innerModel())).withSku(sku);
        ((DatabaseInner)((Object)this.innerModel())).withElasticPoolId(null);
        return this;
    }

    public SqlDatabaseImpl withTags(Map<String, String> tags) {
        ((DatabaseInner)((Object)this.innerModel())).withTags(new HashMap<String, String>(tags));
        return this;
    }

    public SqlDatabaseImpl withTag(String key, String value) {
        if (((DatabaseInner)((Object)this.innerModel())).tags() == null) {
            ((DatabaseInner)((Object)this.innerModel())).withTags(new HashMap());
        }
        ((DatabaseInner)((Object)this.innerModel())).tags().put(key, value);
        return this;
    }

    public SqlDatabaseImpl withoutTag(String key) {
        if (((DatabaseInner)((Object)this.innerModel())).tags() != null) {
            ((DatabaseInner)((Object)this.innerModel())).tags().remove(key);
        }
        return this;
    }

    @Override
    public SqlDatabaseImpl fromSample(SampleName sampleName) {
        ((DatabaseInner)((Object)this.innerModel())).withSampleName(sampleName);
        return this;
    }
}

