/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.ElasticPoolsClient;
import com.azure.resourcemanager.sql.fluent.models.ElasticPoolInner;
import com.azure.resourcemanager.sql.fluent.models.MetricDefinitionInner;
import com.azure.resourcemanager.sql.fluent.models.MetricInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.ElasticPoolListResult;
import com.azure.resourcemanager.sql.models.ElasticPoolUpdate;
import com.azure.resourcemanager.sql.models.MetricDefinitionListResult;
import com.azure.resourcemanager.sql.models.MetricListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ElasticPoolsClientImpl
implements ElasticPoolsClient {
    private final ClientLogger logger = new ClientLogger(ElasticPoolsClientImpl.class);
    private final ElasticPoolsService service;
    private final SqlManagementClientImpl client;

    ElasticPoolsClientImpl(SqlManagementClientImpl client) {
        this.service = (ElasticPoolsService)RestProxy.create(ElasticPoolsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<MetricInner>> listMetricsSinglePageAsync(String resourceGroupName, String serverName, String elasticPoolName, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (elasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        return FluxUtil.withContext(context -> this.service.listMetrics(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, elasticPoolName, filter, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricListResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MetricInner>> listMetricsSinglePageAsync(String resourceGroupName, String serverName, String elasticPoolName, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (elasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null."));
        }
        if (filter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter filter is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        context = this.client.mergeContext(context);
        return this.service.listMetrics(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, elasticPoolName, filter, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<MetricInner> listMetricsAsync(String resourceGroupName, String serverName, String elasticPoolName, String filter) {
        return new PagedFlux(() -> this.listMetricsSinglePageAsync(resourceGroupName, serverName, elasticPoolName, filter));
    }

    private PagedFlux<MetricInner> listMetricsAsync(String resourceGroupName, String serverName, String elasticPoolName, String filter, Context context) {
        return new PagedFlux(() -> this.listMetricsSinglePageAsync(resourceGroupName, serverName, elasticPoolName, filter, context));
    }

    @Override
    public PagedIterable<MetricInner> listMetrics(String resourceGroupName, String serverName, String elasticPoolName, String filter) {
        return new PagedIterable(this.listMetricsAsync(resourceGroupName, serverName, elasticPoolName, filter));
    }

    @Override
    public PagedIterable<MetricInner> listMetrics(String resourceGroupName, String serverName, String elasticPoolName, String filter, Context context) {
        return new PagedIterable(this.listMetricsAsync(resourceGroupName, serverName, elasticPoolName, filter, context));
    }

    private Mono<PagedResponse<MetricDefinitionInner>> listMetricDefinitionsSinglePageAsync(String resourceGroupName, String serverName, String elasticPoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (elasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        return FluxUtil.withContext(context -> this.service.listMetricDefinitions(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, elasticPoolName, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricDefinitionListResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MetricDefinitionInner>> listMetricDefinitionsSinglePageAsync(String resourceGroupName, String serverName, String elasticPoolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (elasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        context = this.client.mergeContext(context);
        return this.service.listMetricDefinitions(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, elasticPoolName, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MetricDefinitionListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<MetricDefinitionInner> listMetricDefinitionsAsync(String resourceGroupName, String serverName, String elasticPoolName) {
        return new PagedFlux(() -> this.listMetricDefinitionsSinglePageAsync(resourceGroupName, serverName, elasticPoolName));
    }

    private PagedFlux<MetricDefinitionInner> listMetricDefinitionsAsync(String resourceGroupName, String serverName, String elasticPoolName, Context context) {
        return new PagedFlux(() -> this.listMetricDefinitionsSinglePageAsync(resourceGroupName, serverName, elasticPoolName, context));
    }

    @Override
    public PagedIterable<MetricDefinitionInner> listMetricDefinitions(String resourceGroupName, String serverName, String elasticPoolName) {
        return new PagedIterable(this.listMetricDefinitionsAsync(resourceGroupName, serverName, elasticPoolName));
    }

    @Override
    public PagedIterable<MetricDefinitionInner> listMetricDefinitions(String resourceGroupName, String serverName, String elasticPoolName, Context context) {
        return new PagedIterable(this.listMetricDefinitionsAsync(resourceGroupName, serverName, elasticPoolName, context));
    }

    private Mono<PagedResponse<ElasticPoolInner>> listByServerSinglePageAsync(String resourceGroupName, String serverName, Integer skip) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        return FluxUtil.withContext(context -> this.service.listByServer(this.client.getEndpoint(), resourceGroupName, serverName, skip, this.client.getSubscriptionId(), "2017-10-01-preview", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ElasticPoolListResult)res.getValue()).value(), ((ElasticPoolListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ElasticPoolInner>> listByServerSinglePageAsync(String resourceGroupName, String serverName, Integer skip, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        context = this.client.mergeContext(context);
        return this.service.listByServer(this.client.getEndpoint(), resourceGroupName, serverName, skip, this.client.getSubscriptionId(), "2017-10-01-preview", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ElasticPoolListResult)res.getValue()).value(), ((ElasticPoolListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<ElasticPoolInner> listByServerAsync(String resourceGroupName, String serverName, Integer skip) {
        return new PagedFlux(() -> this.listByServerSinglePageAsync(resourceGroupName, serverName, skip), nextLink -> this.listByServerNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<ElasticPoolInner> listByServerAsync(String resourceGroupName, String serverName) {
        Integer skip = null;
        return new PagedFlux(() -> this.listByServerSinglePageAsync(resourceGroupName, serverName, skip), nextLink -> this.listByServerNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<ElasticPoolInner> listByServerAsync(String resourceGroupName, String serverName, Integer skip, Context context) {
        return new PagedFlux(() -> this.listByServerSinglePageAsync(resourceGroupName, serverName, skip, context), nextLink -> this.listByServerNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<ElasticPoolInner> listByServer(String resourceGroupName, String serverName, Integer skip, Context context) {
        return new PagedIterable(this.listByServerAsync(resourceGroupName, serverName, skip, context));
    }

    @Override
    public PagedIterable<ElasticPoolInner> listByServer(String resourceGroupName, String serverName) {
        Integer skip = null;
        return new PagedIterable(this.listByServerAsync(resourceGroupName, serverName, skip));
    }

    @Override
    public Mono<Response<ElasticPoolInner>> getWithResponseAsync(String resourceGroupName, String serverName, String elasticPoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (elasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, elasticPoolName, this.client.getSubscriptionId(), "2017-10-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ElasticPoolInner>> getWithResponseAsync(String resourceGroupName, String serverName, String elasticPoolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (elasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, elasticPoolName, this.client.getSubscriptionId(), "2017-10-01-preview", context);
    }

    @Override
    public Mono<ElasticPoolInner> getAsync(String resourceGroupName, String serverName, String elasticPoolName) {
        return this.getWithResponseAsync(resourceGroupName, serverName, elasticPoolName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ElasticPoolInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ElasticPoolInner get(String resourceGroupName, String serverName, String elasticPoolName) {
        return (ElasticPoolInner)((Object)this.getAsync(resourceGroupName, serverName, elasticPoolName).block());
    }

    @Override
    public Response<ElasticPoolInner> getWithResponse(String resourceGroupName, String serverName, String elasticPoolName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serverName, elasticPoolName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (elasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2017-10-01-preview";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, elasticPoolName, this.client.getSubscriptionId(), "2017-10-01-preview", parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (elasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2017-10-01-preview";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, elasticPoolName, this.client.getSubscriptionId(), "2017-10-01-preview", parameters, context);
    }

    @Override
    public PollerFlux<PollResult<ElasticPoolInner>, ElasticPoolInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, elasticPoolName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ElasticPoolInner.class), (Type)((Object)ElasticPoolInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ElasticPoolInner>, ElasticPoolInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, elasticPoolName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ElasticPoolInner.class), (Type)((Object)ElasticPoolInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ElasticPoolInner>, ElasticPoolInner> beginCreateOrUpdate(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, elasticPoolName, parameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ElasticPoolInner>, ElasticPoolInner> beginCreateOrUpdate(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, elasticPoolName, parameters, context).getSyncPoller();
    }

    @Override
    public Mono<ElasticPoolInner> createOrUpdateAsync(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, elasticPoolName, parameters).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ElasticPoolInner> createOrUpdateAsync(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, elasticPoolName, parameters, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ElasticPoolInner createOrUpdate(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolInner parameters) {
        return (ElasticPoolInner)((Object)this.createOrUpdateAsync(resourceGroupName, serverName, elasticPoolName, parameters).block());
    }

    @Override
    public ElasticPoolInner createOrUpdate(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolInner parameters, Context context) {
        return (ElasticPoolInner)((Object)this.createOrUpdateAsync(resourceGroupName, serverName, elasticPoolName, parameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serverName, String elasticPoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (elasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, serverName, elasticPoolName, this.client.getSubscriptionId(), "2017-10-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serverName, String elasticPoolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (elasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, serverName, elasticPoolName, this.client.getSubscriptionId(), "2017-10-01-preview", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serverName, String elasticPoolName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serverName, elasticPoolName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serverName, String elasticPoolName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serverName, elasticPoolName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serverName, String elasticPoolName) {
        return this.beginDeleteAsync(resourceGroupName, serverName, elasticPoolName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serverName, String elasticPoolName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serverName, elasticPoolName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String serverName, String elasticPoolName) {
        return this.beginDeleteAsync(resourceGroupName, serverName, elasticPoolName).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String serverName, String elasticPoolName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serverName, elasticPoolName, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void delete(String resourceGroupName, String serverName, String elasticPoolName) {
        this.deleteAsync(resourceGroupName, serverName, elasticPoolName).block();
    }

    @Override
    public void delete(String resourceGroupName, String serverName, String elasticPoolName, Context context) {
        this.deleteAsync(resourceGroupName, serverName, elasticPoolName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolUpdate parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (elasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2017-10-01-preview";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, serverName, elasticPoolName, this.client.getSubscriptionId(), "2017-10-01-preview", parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolUpdate parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (elasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2017-10-01-preview";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, serverName, elasticPoolName, this.client.getSubscriptionId(), "2017-10-01-preview", parameters, context);
    }

    @Override
    public PollerFlux<PollResult<ElasticPoolInner>, ElasticPoolInner> beginUpdateAsync(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolUpdate parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, serverName, elasticPoolName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ElasticPoolInner.class), (Type)((Object)ElasticPoolInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ElasticPoolInner>, ElasticPoolInner> beginUpdateAsync(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolUpdate parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, serverName, elasticPoolName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ElasticPoolInner.class), (Type)((Object)ElasticPoolInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ElasticPoolInner>, ElasticPoolInner> beginUpdate(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolUpdate parameters) {
        return this.beginUpdateAsync(resourceGroupName, serverName, elasticPoolName, parameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ElasticPoolInner>, ElasticPoolInner> beginUpdate(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolUpdate parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, serverName, elasticPoolName, parameters, context).getSyncPoller();
    }

    @Override
    public Mono<ElasticPoolInner> updateAsync(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolUpdate parameters) {
        return this.beginUpdateAsync(resourceGroupName, serverName, elasticPoolName, parameters).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ElasticPoolInner> updateAsync(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolUpdate parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, serverName, elasticPoolName, parameters, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ElasticPoolInner update(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolUpdate parameters) {
        return (ElasticPoolInner)((Object)this.updateAsync(resourceGroupName, serverName, elasticPoolName, parameters).block());
    }

    @Override
    public ElasticPoolInner update(String resourceGroupName, String serverName, String elasticPoolName, ElasticPoolUpdate parameters, Context context) {
        return (ElasticPoolInner)((Object)this.updateAsync(resourceGroupName, serverName, elasticPoolName, parameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> failoverWithResponseAsync(String resourceGroupName, String serverName, String elasticPoolName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (elasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-06-01-preview";
        return FluxUtil.withContext(context -> this.service.failover(this.client.getEndpoint(), resourceGroupName, serverName, elasticPoolName, this.client.getSubscriptionId(), "2018-06-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> failoverWithResponseAsync(String resourceGroupName, String serverName, String elasticPoolName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (elasticPoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter elasticPoolName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-06-01-preview";
        context = this.client.mergeContext(context);
        return this.service.failover(this.client.getEndpoint(), resourceGroupName, serverName, elasticPoolName, this.client.getSubscriptionId(), "2018-06-01-preview", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginFailoverAsync(String resourceGroupName, String serverName, String elasticPoolName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.failoverWithResponseAsync(resourceGroupName, serverName, elasticPoolName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginFailoverAsync(String resourceGroupName, String serverName, String elasticPoolName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.failoverWithResponseAsync(resourceGroupName, serverName, elasticPoolName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginFailover(String resourceGroupName, String serverName, String elasticPoolName) {
        return this.beginFailoverAsync(resourceGroupName, serverName, elasticPoolName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginFailover(String resourceGroupName, String serverName, String elasticPoolName, Context context) {
        return this.beginFailoverAsync(resourceGroupName, serverName, elasticPoolName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> failoverAsync(String resourceGroupName, String serverName, String elasticPoolName) {
        return this.beginFailoverAsync(resourceGroupName, serverName, elasticPoolName).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> failoverAsync(String resourceGroupName, String serverName, String elasticPoolName, Context context) {
        return this.beginFailoverAsync(resourceGroupName, serverName, elasticPoolName, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void failover(String resourceGroupName, String serverName, String elasticPoolName) {
        this.failoverAsync(resourceGroupName, serverName, elasticPoolName).block();
    }

    @Override
    public void failover(String resourceGroupName, String serverName, String elasticPoolName, Context context) {
        this.failoverAsync(resourceGroupName, serverName, elasticPoolName, context).block();
    }

    private Mono<PagedResponse<ElasticPoolInner>> listByServerNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByServerNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ElasticPoolListResult)res.getValue()).value(), ((ElasticPoolListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ElasticPoolInner>> listByServerNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByServerNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ElasticPoolListResult)res.getValue()).value(), ((ElasticPoolListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientE")
    private static interface ElasticPoolsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}/metrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MetricListResult>> listMetrics(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @PathParam(value="elasticPoolName") String var6, @QueryParam(value="$filter") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}/metricDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MetricDefinitionListResult>> listMetricDefinitions(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @PathParam(value="elasticPoolName") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ElasticPoolListResult>> listByServer(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @QueryParam(value="$skip") Integer var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ElasticPoolInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="elasticPoolName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="elasticPoolName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ElasticPoolInner var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="elasticPoolName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="elasticPoolName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ElasticPoolUpdate var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/elasticPools/{elasticPoolName}/failover")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> failover(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="elasticPoolName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ElasticPoolListResult>> listByServerNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

