/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sitemanager.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sitemanager.models.SiteAddressProperties;
import java.io.IOException;
import java.util.Map;

public final class SiteUpdateProperties
implements JsonSerializable<SiteUpdateProperties> {
    private String displayName;
    private String description;
    private SiteAddressProperties siteAddress;
    private Map<String, String> labels;

    public String displayName() {
        return this.displayName;
    }

    public SiteUpdateProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public SiteUpdateProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public SiteAddressProperties siteAddress() {
        return this.siteAddress;
    }

    public SiteUpdateProperties withSiteAddress(SiteAddressProperties siteAddress) {
        this.siteAddress = siteAddress;
        return this;
    }

    public Map<String, String> labels() {
        return this.labels;
    }

    public SiteUpdateProperties withLabels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("siteAddress", (JsonSerializable)this.siteAddress);
        jsonWriter.writeMapField("labels", this.labels, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static SiteUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SiteUpdateProperties)jsonReader.readObject(reader -> {
            SiteUpdateProperties deserializedSiteUpdateProperties = new SiteUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedSiteUpdateProperties.displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSiteUpdateProperties.description = reader.getString();
                    continue;
                }
                if ("siteAddress".equals(fieldName)) {
                    deserializedSiteUpdateProperties.siteAddress = SiteAddressProperties.fromJson(reader);
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    Map labels;
                    deserializedSiteUpdateProperties.labels = labels = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSiteUpdateProperties;
        });
    }
}

