/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sitemanager.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sitemanager.models.ResourceProvisioningState;
import com.azure.resourcemanager.sitemanager.models.SiteAddressProperties;
import java.io.IOException;
import java.util.Map;

public final class SiteProperties
implements JsonSerializable<SiteProperties> {
    private String displayName;
    private String description;
    private SiteAddressProperties siteAddress;
    private Map<String, String> labels;
    private ResourceProvisioningState provisioningState;

    public String displayName() {
        return this.displayName;
    }

    public SiteProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public SiteProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public SiteAddressProperties siteAddress() {
        return this.siteAddress;
    }

    public SiteProperties withSiteAddress(SiteAddressProperties siteAddress) {
        this.siteAddress = siteAddress;
        return this;
    }

    public Map<String, String> labels() {
        return this.labels;
    }

    public SiteProperties withLabels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public ResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("siteAddress", (JsonSerializable)this.siteAddress);
        jsonWriter.writeMapField("labels", this.labels, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static SiteProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SiteProperties)jsonReader.readObject(reader -> {
            SiteProperties deserializedSiteProperties = new SiteProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedSiteProperties.displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSiteProperties.description = reader.getString();
                    continue;
                }
                if ("siteAddress".equals(fieldName)) {
                    deserializedSiteProperties.siteAddress = SiteAddressProperties.fromJson(reader);
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    Map labels;
                    deserializedSiteProperties.labels = labels = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSiteProperties.provisioningState = ResourceProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSiteProperties;
        });
    }
}

