/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sitemanager.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sitemanager.SiteManagerManager;
import com.azure.resourcemanager.sitemanager.fluent.SitesClient;
import com.azure.resourcemanager.sitemanager.fluent.models.SiteInner;
import com.azure.resourcemanager.sitemanager.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.sitemanager.implementation.SiteImpl;
import com.azure.resourcemanager.sitemanager.models.Site;
import com.azure.resourcemanager.sitemanager.models.Sites;

public final class SitesImpl
implements Sites {
    private static final ClientLogger LOGGER = new ClientLogger(SitesImpl.class);
    private final SitesClient innerClient;
    private final SiteManagerManager serviceManager;

    public SitesImpl(SitesClient innerClient, SiteManagerManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Site> getByResourceGroupWithResponse(String resourceGroupName, String siteName, Context context) {
        Response<SiteInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, siteName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SiteImpl((SiteInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Site getByResourceGroup(String resourceGroupName, String siteName) {
        SiteInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, siteName);
        if (inner != null) {
            return new SiteImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String resourceGroupName, String siteName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, siteName, context);
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String siteName) {
        this.serviceClient().delete(resourceGroupName, siteName);
    }

    @Override
    public PagedIterable<Site> listByResourceGroup(String resourceGroupName) {
        PagedIterable<SiteInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SiteImpl((SiteInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Site> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<SiteInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SiteImpl((SiteInner)((Object)inner1), this.manager()));
    }

    @Override
    public Site getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String siteName = ResourceManagerUtils.getValueFromIdByName(id, "sites");
        if (siteName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sites'.", id)));
        }
        return (Site)this.getByResourceGroupWithResponse(resourceGroupName, siteName, Context.NONE).getValue();
    }

    @Override
    public Response<Site> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String siteName = ResourceManagerUtils.getValueFromIdByName(id, "sites");
        if (siteName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sites'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, siteName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String siteName = ResourceManagerUtils.getValueFromIdByName(id, "sites");
        if (siteName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sites'.", id)));
        }
        this.deleteByResourceGroupWithResponse(resourceGroupName, siteName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String siteName = ResourceManagerUtils.getValueFromIdByName(id, "sites");
        if (siteName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sites'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(resourceGroupName, siteName, context);
    }

    private SitesClient serviceClient() {
        return this.innerClient;
    }

    private SiteManagerManager manager() {
        return this.serviceManager;
    }

    @Override
    public SiteImpl define(String name) {
        return new SiteImpl(name, this.manager());
    }
}

