/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sitemanager.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sitemanager.SiteManagerManager;
import com.azure.resourcemanager.sitemanager.fluent.SitesBySubscriptionsClient;
import com.azure.resourcemanager.sitemanager.fluent.models.SiteInner;
import com.azure.resourcemanager.sitemanager.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.sitemanager.implementation.SiteImpl;
import com.azure.resourcemanager.sitemanager.models.Site;
import com.azure.resourcemanager.sitemanager.models.SiteUpdate;
import com.azure.resourcemanager.sitemanager.models.SitesBySubscriptions;

public final class SitesBySubscriptionsImpl
implements SitesBySubscriptions {
    private static final ClientLogger LOGGER = new ClientLogger(SitesBySubscriptionsImpl.class);
    private final SitesBySubscriptionsClient innerClient;
    private final SiteManagerManager serviceManager;

    public SitesBySubscriptionsImpl(SitesBySubscriptionsClient innerClient, SiteManagerManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Site> list() {
        PagedIterable<SiteInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SiteImpl((SiteInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Site> list(Context context) {
        PagedIterable<SiteInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SiteImpl((SiteInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Site> getWithResponse(String siteName, Context context) {
        Response<SiteInner> inner = this.serviceClient().getWithResponse(siteName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SiteImpl((SiteInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Site get(String siteName) {
        SiteInner inner = this.serviceClient().get(siteName);
        if (inner != null) {
            return new SiteImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Site createOrUpdate(String siteName, SiteInner resource) {
        SiteInner inner = this.serviceClient().createOrUpdate(siteName, resource);
        if (inner != null) {
            return new SiteImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Site createOrUpdate(String siteName, SiteInner resource, Context context) {
        SiteInner inner = this.serviceClient().createOrUpdate(siteName, resource, context);
        if (inner != null) {
            return new SiteImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Site> updateWithResponse(String siteName, SiteUpdate properties, Context context) {
        Response<SiteInner> inner = this.serviceClient().updateWithResponse(siteName, properties, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SiteImpl((SiteInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Site update(String siteName, SiteUpdate properties) {
        SiteInner inner = this.serviceClient().update(siteName, properties);
        if (inner != null) {
            return new SiteImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String siteName, Context context) {
        return this.serviceClient().deleteWithResponse(siteName, context);
    }

    @Override
    public void delete(String siteName) {
        this.serviceClient().delete(siteName);
    }

    private SitesBySubscriptionsClient serviceClient() {
        return this.innerClient;
    }

    private SiteManagerManager manager() {
        return this.serviceManager;
    }
}

