/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sitemanager.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sitemanager.SiteManagerManager;
import com.azure.resourcemanager.sitemanager.fluent.SitesByServiceGroupsClient;
import com.azure.resourcemanager.sitemanager.fluent.models.SiteInner;
import com.azure.resourcemanager.sitemanager.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.sitemanager.implementation.SiteImpl;
import com.azure.resourcemanager.sitemanager.models.Site;
import com.azure.resourcemanager.sitemanager.models.SiteUpdate;
import com.azure.resourcemanager.sitemanager.models.SitesByServiceGroups;

public final class SitesByServiceGroupsImpl
implements SitesByServiceGroups {
    private static final ClientLogger LOGGER = new ClientLogger(SitesByServiceGroupsImpl.class);
    private final SitesByServiceGroupsClient innerClient;
    private final SiteManagerManager serviceManager;

    public SitesByServiceGroupsImpl(SitesByServiceGroupsClient innerClient, SiteManagerManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Site> listByServiceGroup(String servicegroupName) {
        PagedIterable<SiteInner> inner = this.serviceClient().listByServiceGroup(servicegroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SiteImpl((SiteInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Site> listByServiceGroup(String servicegroupName, Context context) {
        PagedIterable<SiteInner> inner = this.serviceClient().listByServiceGroup(servicegroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SiteImpl((SiteInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Site> getWithResponse(String servicegroupName, String siteName, Context context) {
        Response<SiteInner> inner = this.serviceClient().getWithResponse(servicegroupName, siteName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SiteImpl((SiteInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Site get(String servicegroupName, String siteName) {
        SiteInner inner = this.serviceClient().get(servicegroupName, siteName);
        if (inner != null) {
            return new SiteImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Site createOrUpdate(String servicegroupName, String siteName, SiteInner resource) {
        SiteInner inner = this.serviceClient().createOrUpdate(servicegroupName, siteName, resource);
        if (inner != null) {
            return new SiteImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Site createOrUpdate(String servicegroupName, String siteName, SiteInner resource, Context context) {
        SiteInner inner = this.serviceClient().createOrUpdate(servicegroupName, siteName, resource, context);
        if (inner != null) {
            return new SiteImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Site> updateWithResponse(String servicegroupName, String siteName, SiteUpdate properties, Context context) {
        Response<SiteInner> inner = this.serviceClient().updateWithResponse(servicegroupName, siteName, properties, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SiteImpl((SiteInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Site update(String servicegroupName, String siteName, SiteUpdate properties) {
        SiteInner inner = this.serviceClient().update(servicegroupName, siteName, properties);
        if (inner != null) {
            return new SiteImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String servicegroupName, String siteName, Context context) {
        return this.serviceClient().deleteWithResponse(servicegroupName, siteName, context);
    }

    @Override
    public void deleteByResourceGroup(String servicegroupName, String siteName) {
        this.serviceClient().delete(servicegroupName, siteName);
    }

    private SitesByServiceGroupsClient serviceClient() {
        return this.innerClient;
    }

    private SiteManagerManager manager() {
        return this.serviceManager;
    }
}

