/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sitemanager.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.sitemanager.SiteManagerManager;
import com.azure.resourcemanager.sitemanager.fluent.models.SiteInner;
import com.azure.resourcemanager.sitemanager.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.sitemanager.models.Site;
import com.azure.resourcemanager.sitemanager.models.SiteProperties;
import com.azure.resourcemanager.sitemanager.models.SiteUpdate;
import com.azure.resourcemanager.sitemanager.models.SiteUpdateProperties;

public final class SiteImpl
implements Site,
Site.Definition,
Site.Update {
    private SiteInner innerObject;
    private final SiteManagerManager serviceManager;
    private String resourceGroupName;
    private String siteName;
    private SiteUpdate updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SiteProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SiteInner innerModel() {
        return this.innerObject;
    }

    private SiteManagerManager manager() {
        return this.serviceManager;
    }

    @Override
    public SiteImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Site create() {
        this.innerObject = this.serviceManager.serviceClient().getSites().createOrUpdate(this.resourceGroupName, this.siteName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Site create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSites().createOrUpdate(this.resourceGroupName, this.siteName, this.innerModel(), context);
        return this;
    }

    SiteImpl(String name, SiteManagerManager serviceManager) {
        this.innerObject = new SiteInner();
        this.serviceManager = serviceManager;
        this.siteName = name;
    }

    @Override
    public SiteImpl update() {
        this.updateProperties = new SiteUpdate();
        return this;
    }

    @Override
    public Site apply() {
        this.innerObject = (SiteInner)((Object)this.serviceManager.serviceClient().getSites().updateWithResponse(this.resourceGroupName, this.siteName, this.updateProperties, Context.NONE).getValue());
        return this;
    }

    @Override
    public Site apply(Context context) {
        this.innerObject = (SiteInner)((Object)this.serviceManager.serviceClient().getSites().updateWithResponse(this.resourceGroupName, this.siteName, this.updateProperties, context).getValue());
        return this;
    }

    SiteImpl(SiteInner innerObject, SiteManagerManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.siteName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "sites");
    }

    @Override
    public Site refresh() {
        this.innerObject = (SiteInner)((Object)this.serviceManager.serviceClient().getSites().getByResourceGroupWithResponse(this.resourceGroupName, this.siteName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Site refresh(Context context) {
        this.innerObject = (SiteInner)((Object)this.serviceManager.serviceClient().getSites().getByResourceGroupWithResponse(this.resourceGroupName, this.siteName, context).getValue());
        return this;
    }

    @Override
    public SiteImpl withProperties(SiteProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public SiteImpl withProperties(SiteUpdateProperties properties) {
        this.updateProperties.withProperties(properties);
        return this;
    }
}

