/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.search.models.NetworkSecurityPerimeter;
import com.azure.resourcemanager.search.models.NetworkSecurityPerimeterConfigurationProvisioningState;
import com.azure.resourcemanager.search.models.NetworkSecurityProfile;
import com.azure.resourcemanager.search.models.ProvisioningIssue;
import com.azure.resourcemanager.search.models.ResourceAssociation;
import java.io.IOException;
import java.util.List;

public final class NetworkSecurityPerimeterConfigurationProperties
implements JsonSerializable<NetworkSecurityPerimeterConfigurationProperties> {
    private NetworkSecurityPerimeterConfigurationProvisioningState provisioningState;
    private List<ProvisioningIssue> provisioningIssues;
    private NetworkSecurityPerimeter networkSecurityPerimeter;
    private ResourceAssociation resourceAssociation;
    private NetworkSecurityProfile profile;

    public NetworkSecurityPerimeterConfigurationProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<ProvisioningIssue> provisioningIssues() {
        return this.provisioningIssues;
    }

    public NetworkSecurityPerimeter networkSecurityPerimeter() {
        return this.networkSecurityPerimeter;
    }

    public NetworkSecurityPerimeterConfigurationProperties withNetworkSecurityPerimeter(NetworkSecurityPerimeter networkSecurityPerimeter) {
        this.networkSecurityPerimeter = networkSecurityPerimeter;
        return this;
    }

    public ResourceAssociation resourceAssociation() {
        return this.resourceAssociation;
    }

    public NetworkSecurityPerimeterConfigurationProperties withResourceAssociation(ResourceAssociation resourceAssociation) {
        this.resourceAssociation = resourceAssociation;
        return this;
    }

    public NetworkSecurityProfile profile() {
        return this.profile;
    }

    public NetworkSecurityPerimeterConfigurationProperties withProfile(NetworkSecurityProfile profile) {
        this.profile = profile;
        return this;
    }

    public void validate() {
        if (this.provisioningIssues() != null) {
            this.provisioningIssues().forEach(e -> e.validate());
        }
        if (this.networkSecurityPerimeter() != null) {
            this.networkSecurityPerimeter().validate();
        }
        if (this.resourceAssociation() != null) {
            this.resourceAssociation().validate();
        }
        if (this.profile() != null) {
            this.profile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("networkSecurityPerimeter", (JsonSerializable)this.networkSecurityPerimeter);
        jsonWriter.writeJsonField("resourceAssociation", (JsonSerializable)this.resourceAssociation);
        jsonWriter.writeJsonField("profile", (JsonSerializable)this.profile);
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityPerimeterConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSecurityPerimeterConfigurationProperties)jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterConfigurationProperties deserializedNetworkSecurityPerimeterConfigurationProperties = new NetworkSecurityPerimeterConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.provisioningState = NetworkSecurityPerimeterConfigurationProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningIssues".equals(fieldName)) {
                    List provisioningIssues;
                    deserializedNetworkSecurityPerimeterConfigurationProperties.provisioningIssues = provisioningIssues = reader.readArray(reader1 -> ProvisioningIssue.fromJson(reader1));
                    continue;
                }
                if ("networkSecurityPerimeter".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.networkSecurityPerimeter = NetworkSecurityPerimeter.fromJson(reader);
                    continue;
                }
                if ("resourceAssociation".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.resourceAssociation = ResourceAssociation.fromJson(reader);
                    continue;
                }
                if ("profile".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.profile = NetworkSecurityProfile.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityPerimeterConfigurationProperties;
        });
    }
}

