/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.search.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.search.fluent.models.SharedPrivateLinkResourceInner;
import com.azure.resourcemanager.search.models.ComputeType;
import com.azure.resourcemanager.search.models.DataPlaneAuthOptions;
import com.azure.resourcemanager.search.models.EncryptionWithCmk;
import com.azure.resourcemanager.search.models.HostingMode;
import com.azure.resourcemanager.search.models.NetworkRuleSet;
import com.azure.resourcemanager.search.models.ProvisioningState;
import com.azure.resourcemanager.search.models.PublicNetworkAccess;
import com.azure.resourcemanager.search.models.SearchDataExfiltrationProtection;
import com.azure.resourcemanager.search.models.SearchSemanticSearch;
import com.azure.resourcemanager.search.models.SearchServiceStatus;
import com.azure.resourcemanager.search.models.UpgradeAvailable;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class SearchServiceProperties
implements JsonSerializable<SearchServiceProperties> {
    private Integer replicaCount;
    private Integer partitionCount;
    private String endpoint;
    private HostingMode hostingMode;
    private ComputeType computeType;
    private PublicNetworkAccess publicNetworkAccess;
    private SearchServiceStatus status;
    private String statusDetails;
    private ProvisioningState provisioningState;
    private NetworkRuleSet networkRuleSet;
    private List<SearchDataExfiltrationProtection> dataExfiltrationProtections;
    private EncryptionWithCmk encryptionWithCmk;
    private Boolean disableLocalAuth;
    private DataPlaneAuthOptions authOptions;
    private SearchSemanticSearch semanticSearch;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private List<SharedPrivateLinkResourceInner> sharedPrivateLinkResources;
    private String etag;
    private UpgradeAvailable upgradeAvailable;
    private OffsetDateTime serviceUpgradedAt;

    public Integer replicaCount() {
        return this.replicaCount;
    }

    public SearchServiceProperties withReplicaCount(Integer replicaCount) {
        this.replicaCount = replicaCount;
        return this;
    }

    public Integer partitionCount() {
        return this.partitionCount;
    }

    public SearchServiceProperties withPartitionCount(Integer partitionCount) {
        this.partitionCount = partitionCount;
        return this;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public SearchServiceProperties withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public HostingMode hostingMode() {
        return this.hostingMode;
    }

    public SearchServiceProperties withHostingMode(HostingMode hostingMode) {
        this.hostingMode = hostingMode;
        return this;
    }

    public ComputeType computeType() {
        return this.computeType;
    }

    public SearchServiceProperties withComputeType(ComputeType computeType) {
        this.computeType = computeType;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public SearchServiceProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public SearchServiceStatus status() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.networkRuleSet;
    }

    public SearchServiceProperties withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        this.networkRuleSet = networkRuleSet;
        return this;
    }

    public List<SearchDataExfiltrationProtection> dataExfiltrationProtections() {
        return this.dataExfiltrationProtections;
    }

    public SearchServiceProperties withDataExfiltrationProtections(List<SearchDataExfiltrationProtection> dataExfiltrationProtections) {
        this.dataExfiltrationProtections = dataExfiltrationProtections;
        return this;
    }

    public EncryptionWithCmk encryptionWithCmk() {
        return this.encryptionWithCmk;
    }

    public SearchServiceProperties withEncryptionWithCmk(EncryptionWithCmk encryptionWithCmk) {
        this.encryptionWithCmk = encryptionWithCmk;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public SearchServiceProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public DataPlaneAuthOptions authOptions() {
        return this.authOptions;
    }

    public SearchServiceProperties withAuthOptions(DataPlaneAuthOptions authOptions) {
        this.authOptions = authOptions;
        return this;
    }

    public SearchSemanticSearch semanticSearch() {
        return this.semanticSearch;
    }

    public SearchServiceProperties withSemanticSearch(SearchSemanticSearch semanticSearch) {
        this.semanticSearch = semanticSearch;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public List<SharedPrivateLinkResourceInner> sharedPrivateLinkResources() {
        return this.sharedPrivateLinkResources;
    }

    public String etag() {
        return this.etag;
    }

    public UpgradeAvailable upgradeAvailable() {
        return this.upgradeAvailable;
    }

    public SearchServiceProperties withUpgradeAvailable(UpgradeAvailable upgradeAvailable) {
        this.upgradeAvailable = upgradeAvailable;
        return this;
    }

    public OffsetDateTime serviceUpgradedAt() {
        return this.serviceUpgradedAt;
    }

    public void validate() {
        if (this.networkRuleSet() != null) {
            this.networkRuleSet().validate();
        }
        if (this.encryptionWithCmk() != null) {
            this.encryptionWithCmk().validate();
        }
        if (this.authOptions() != null) {
            this.authOptions().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.sharedPrivateLinkResources() != null) {
            this.sharedPrivateLinkResources().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("replicaCount", (Number)this.replicaCount);
        jsonWriter.writeNumberField("partitionCount", (Number)this.partitionCount);
        jsonWriter.writeStringField("endpoint", this.endpoint);
        jsonWriter.writeStringField("hostingMode", this.hostingMode == null ? null : this.hostingMode.toString());
        jsonWriter.writeStringField("computeType", this.computeType == null ? null : this.computeType.toString());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeJsonField("networkRuleSet", (JsonSerializable)this.networkRuleSet);
        jsonWriter.writeArrayField("dataExfiltrationProtections", this.dataExfiltrationProtections, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("encryptionWithCmk", (JsonSerializable)this.encryptionWithCmk);
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        jsonWriter.writeJsonField("authOptions", (JsonSerializable)this.authOptions);
        jsonWriter.writeStringField("semanticSearch", this.semanticSearch == null ? null : this.semanticSearch.toString());
        jsonWriter.writeStringField("upgradeAvailable", this.upgradeAvailable == null ? null : this.upgradeAvailable.toString());
        return jsonWriter.writeEndObject();
    }

    public static SearchServiceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SearchServiceProperties)jsonReader.readObject(reader -> {
            SearchServiceProperties deserializedSearchServiceProperties = new SearchServiceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("replicaCount".equals(fieldName)) {
                    deserializedSearchServiceProperties.replicaCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("partitionCount".equals(fieldName)) {
                    deserializedSearchServiceProperties.partitionCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("endpoint".equals(fieldName)) {
                    deserializedSearchServiceProperties.endpoint = reader.getString();
                    continue;
                }
                if ("hostingMode".equals(fieldName)) {
                    deserializedSearchServiceProperties.hostingMode = HostingMode.fromString(reader.getString());
                    continue;
                }
                if ("computeType".equals(fieldName)) {
                    deserializedSearchServiceProperties.computeType = ComputeType.fromString(reader.getString());
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedSearchServiceProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSearchServiceProperties.status = SearchServiceStatus.fromString(reader.getString());
                    continue;
                }
                if ("statusDetails".equals(fieldName)) {
                    deserializedSearchServiceProperties.statusDetails = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSearchServiceProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("networkRuleSet".equals(fieldName)) {
                    deserializedSearchServiceProperties.networkRuleSet = NetworkRuleSet.fromJson(reader);
                    continue;
                }
                if ("dataExfiltrationProtections".equals(fieldName)) {
                    List dataExfiltrationProtections;
                    deserializedSearchServiceProperties.dataExfiltrationProtections = dataExfiltrationProtections = reader.readArray(reader1 -> SearchDataExfiltrationProtection.fromString(reader1.getString()));
                    continue;
                }
                if ("encryptionWithCmk".equals(fieldName)) {
                    deserializedSearchServiceProperties.encryptionWithCmk = EncryptionWithCmk.fromJson(reader);
                    continue;
                }
                if ("disableLocalAuth".equals(fieldName)) {
                    deserializedSearchServiceProperties.disableLocalAuth = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("authOptions".equals(fieldName)) {
                    deserializedSearchServiceProperties.authOptions = DataPlaneAuthOptions.fromJson(reader);
                    continue;
                }
                if ("semanticSearch".equals(fieldName)) {
                    deserializedSearchServiceProperties.semanticSearch = SearchSemanticSearch.fromString(reader.getString());
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedSearchServiceProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("sharedPrivateLinkResources".equals(fieldName)) {
                    List sharedPrivateLinkResources;
                    deserializedSearchServiceProperties.sharedPrivateLinkResources = sharedPrivateLinkResources = reader.readArray(reader1 -> SharedPrivateLinkResourceInner.fromJson(reader1));
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedSearchServiceProperties.etag = reader.getString();
                    continue;
                }
                if ("upgradeAvailable".equals(fieldName)) {
                    deserializedSearchServiceProperties.upgradeAvailable = UpgradeAvailable.fromString(reader.getString());
                    continue;
                }
                if ("serviceUpgradedAt".equals(fieldName)) {
                    deserializedSearchServiceProperties.serviceUpgradedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSearchServiceProperties;
        });
    }
}

