/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.resources.fluent.ProvidersClient;
import com.azure.resourcemanager.resources.fluent.models.ProviderInner;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.resources.implementation.ProviderImpl;
import com.azure.resourcemanager.resources.models.Provider;
import com.azure.resourcemanager.resources.models.Providers;
import reactor.core.publisher.Mono;

public final class ProvidersImpl
extends ReadableWrappersImpl<Provider, ProviderImpl, ProviderInner>
implements Providers {
    private final ProvidersClient client;

    public ProvidersImpl(ProvidersClient client) {
        this.client = client;
    }

    @Override
    public PagedIterable<Provider> list() {
        return this.wrapList(this.client.list());
    }

    @Override
    public Provider unregister(String resourceProviderNamespace) {
        return (Provider)this.unregisterAsync(resourceProviderNamespace).block();
    }

    @Override
    public Mono<Provider> unregisterAsync(String resourceProviderNamespace) {
        return this.client.unregisterAsync(resourceProviderNamespace).map(providerInner -> this.wrapModel((ProviderInner)providerInner));
    }

    @Override
    public Provider register(String resourceProviderNamespace) {
        return (Provider)this.registerAsync(resourceProviderNamespace).block();
    }

    @Override
    public Mono<Provider> registerAsync(String resourceProviderNamespace) {
        return this.client.registerAsync(resourceProviderNamespace).map(providerInner -> this.wrapModel((ProviderInner)providerInner));
    }

    @Override
    public Mono<Provider> getByNameAsync(String name) {
        return this.client.getAsync(name).map(providerInner -> this.wrapModel((ProviderInner)providerInner));
    }

    @Override
    public Provider getByName(String resourceProviderNamespace) {
        return this.wrapModel(this.client.get(resourceProviderNamespace));
    }

    @Override
    public PagedFlux<Provider> listAsync() {
        return PagedConverter.mapPage(this.client.listAsync(), inner -> this.wrapModel((ProviderInner)inner));
    }

    @Override
    protected ProviderImpl wrapModel(ProviderInner inner) {
        if (inner == null) {
            return null;
        }
        return new ProviderImpl(inner);
    }
}

