/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.DeploymentDiagnosticsDefinition;
import com.azure.resourcemanager.resources.models.WhatIfChange;
import java.io.IOException;
import java.util.List;

public final class WhatIfOperationProperties
implements JsonSerializable<WhatIfOperationProperties> {
    private List<WhatIfChange> changes;
    private List<WhatIfChange> potentialChanges;
    private List<DeploymentDiagnosticsDefinition> diagnostics;

    public List<WhatIfChange> changes() {
        return this.changes;
    }

    public WhatIfOperationProperties withChanges(List<WhatIfChange> changes) {
        this.changes = changes;
        return this;
    }

    public List<WhatIfChange> potentialChanges() {
        return this.potentialChanges;
    }

    public WhatIfOperationProperties withPotentialChanges(List<WhatIfChange> potentialChanges) {
        this.potentialChanges = potentialChanges;
        return this;
    }

    public List<DeploymentDiagnosticsDefinition> diagnostics() {
        return this.diagnostics;
    }

    public void validate() {
        if (this.changes() != null) {
            this.changes().forEach(e -> e.validate());
        }
        if (this.potentialChanges() != null) {
            this.potentialChanges().forEach(e -> e.validate());
        }
        if (this.diagnostics() != null) {
            this.diagnostics().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("changes", this.changes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("potentialChanges", this.potentialChanges, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static WhatIfOperationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WhatIfOperationProperties)jsonReader.readObject(reader -> {
            WhatIfOperationProperties deserializedWhatIfOperationProperties = new WhatIfOperationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("changes".equals(fieldName)) {
                    List changes;
                    deserializedWhatIfOperationProperties.changes = changes = reader.readArray(reader1 -> WhatIfChange.fromJson(reader1));
                    continue;
                }
                if ("potentialChanges".equals(fieldName)) {
                    List potentialChanges;
                    deserializedWhatIfOperationProperties.potentialChanges = potentialChanges = reader.readArray(reader1 -> WhatIfChange.fromJson(reader1));
                    continue;
                }
                if ("diagnostics".equals(fieldName)) {
                    List diagnostics;
                    deserializedWhatIfOperationProperties.diagnostics = diagnostics = reader.readArray(reader1 -> DeploymentDiagnosticsDefinition.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWhatIfOperationProperties;
        });
    }
}

