/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.Selector;
import java.io.IOException;
import java.util.List;

public final class ResourceSelector
implements JsonSerializable<ResourceSelector> {
    private String name;
    private List<Selector> selectors;

    public String name() {
        return this.name;
    }

    public ResourceSelector withName(String name) {
        this.name = name;
        return this;
    }

    public List<Selector> selectors() {
        return this.selectors;
    }

    public ResourceSelector withSelectors(List<Selector> selectors) {
        this.selectors = selectors;
        return this;
    }

    public void validate() {
        if (this.selectors() != null) {
            this.selectors().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("selectors", this.selectors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceSelector fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceSelector)jsonReader.readObject(reader -> {
            ResourceSelector deserializedResourceSelector = new ResourceSelector();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedResourceSelector.name = reader.getString();
                    continue;
                }
                if ("selectors".equals(fieldName)) {
                    List selectors;
                    deserializedResourceSelector.selectors = selectors = reader.readArray(reader1 -> Selector.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceSelector;
        });
    }
}

