/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.BasicDependency;
import java.io.IOException;
import java.util.List;

public final class Dependency
implements JsonSerializable<Dependency> {
    private List<BasicDependency> dependsOn;
    private String id;
    private String resourceType;
    private String resourceName;

    public List<BasicDependency> dependsOn() {
        return this.dependsOn;
    }

    public Dependency withDependsOn(List<BasicDependency> dependsOn) {
        this.dependsOn = dependsOn;
        return this;
    }

    public String id() {
        return this.id;
    }

    public Dependency withId(String id) {
        this.id = id;
        return this;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Dependency withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public Dependency withResourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    public void validate() {
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("dependsOn", this.dependsOn, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("resourceType", this.resourceType);
        jsonWriter.writeStringField("resourceName", this.resourceName);
        return jsonWriter.writeEndObject();
    }

    public static Dependency fromJson(JsonReader jsonReader) throws IOException {
        return (Dependency)jsonReader.readObject(reader -> {
            Dependency deserializedDependency = new Dependency();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn;
                    deserializedDependency.dependsOn = dependsOn = reader.readArray(reader1 -> BasicDependency.fromJson(reader1));
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedDependency.id = reader.getString();
                    continue;
                }
                if ("resourceType".equals(fieldName)) {
                    deserializedDependency.resourceType = reader.getString();
                    continue;
                }
                if ("resourceName".equals(fieldName)) {
                    deserializedDependency.resourceName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDependency;
        });
    }
}

