/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.AssignmentScopeValidation;
import com.azure.resourcemanager.resources.models.ResourceSelector;
import java.io.IOException;
import java.util.List;

public final class PolicyExemptionUpdateProperties
implements JsonSerializable<PolicyExemptionUpdateProperties> {
    private List<ResourceSelector> resourceSelectors;
    private AssignmentScopeValidation assignmentScopeValidation;

    public List<ResourceSelector> resourceSelectors() {
        return this.resourceSelectors;
    }

    public PolicyExemptionUpdateProperties withResourceSelectors(List<ResourceSelector> resourceSelectors) {
        this.resourceSelectors = resourceSelectors;
        return this;
    }

    public AssignmentScopeValidation assignmentScopeValidation() {
        return this.assignmentScopeValidation;
    }

    public PolicyExemptionUpdateProperties withAssignmentScopeValidation(AssignmentScopeValidation assignmentScopeValidation) {
        this.assignmentScopeValidation = assignmentScopeValidation;
        return this;
    }

    public void validate() {
        if (this.resourceSelectors() != null) {
            this.resourceSelectors().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("resourceSelectors", this.resourceSelectors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("assignmentScopeValidation", this.assignmentScopeValidation == null ? null : this.assignmentScopeValidation.toString());
        return jsonWriter.writeEndObject();
    }

    public static PolicyExemptionUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyExemptionUpdateProperties)jsonReader.readObject(reader -> {
            PolicyExemptionUpdateProperties deserializedPolicyExemptionUpdateProperties = new PolicyExemptionUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceSelectors".equals(fieldName)) {
                    List resourceSelectors;
                    deserializedPolicyExemptionUpdateProperties.resourceSelectors = resourceSelectors = reader.readArray(reader1 -> ResourceSelector.fromJson(reader1));
                    continue;
                }
                if ("assignmentScopeValidation".equals(fieldName)) {
                    deserializedPolicyExemptionUpdateProperties.assignmentScopeValidation = AssignmentScopeValidation.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyExemptionUpdateProperties;
        });
    }
}

