/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.fluent.models.PolicyAssignmentUpdateProperties;
import com.azure.resourcemanager.resources.models.Identity;
import com.azure.resourcemanager.resources.models.OverrideModel;
import com.azure.resourcemanager.resources.models.ResourceSelector;
import java.io.IOException;
import java.util.List;

public final class PolicyAssignmentUpdate
implements JsonSerializable<PolicyAssignmentUpdate> {
    private PolicyAssignmentUpdateProperties innerProperties;
    private String location;
    private Identity identity;

    private PolicyAssignmentUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String location() {
        return this.location;
    }

    public PolicyAssignmentUpdate withLocation(String location) {
        this.location = location;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public PolicyAssignmentUpdate withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public List<ResourceSelector> resourceSelectors() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceSelectors();
    }

    public PolicyAssignmentUpdate withResourceSelectors(List<ResourceSelector> resourceSelectors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentUpdateProperties();
        }
        this.innerProperties().withResourceSelectors(resourceSelectors);
        return this;
    }

    public List<OverrideModel> overrides() {
        return this.innerProperties() == null ? null : this.innerProperties().overrides();
    }

    public PolicyAssignmentUpdate withOverrides(List<OverrideModel> overrides) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentUpdateProperties();
        }
        this.innerProperties().withOverrides(overrides);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static PolicyAssignmentUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyAssignmentUpdate)jsonReader.readObject(reader -> {
            PolicyAssignmentUpdate deserializedPolicyAssignmentUpdate = new PolicyAssignmentUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedPolicyAssignmentUpdate.innerProperties = PolicyAssignmentUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedPolicyAssignmentUpdate.location = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedPolicyAssignmentUpdate.identity = Identity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyAssignmentUpdate;
        });
    }
}

