/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.deploymentstacks.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.deploymentstacks.models.KeyVaultParameterReference;
import java.io.IOException;

public final class DeploymentParameter
implements JsonSerializable<DeploymentParameter> {
    private Object value;
    private String type;
    private KeyVaultParameterReference reference;

    public Object value() {
        return this.value;
    }

    public DeploymentParameter withValue(Object value) {
        this.value = value;
        return this;
    }

    public String type() {
        return this.type;
    }

    public DeploymentParameter withType(String type) {
        this.type = type;
        return this;
    }

    public KeyVaultParameterReference reference() {
        return this.reference;
    }

    public DeploymentParameter withReference(KeyVaultParameterReference reference) {
        this.reference = reference;
        return this;
    }

    public void validate() {
        if (this.reference() != null) {
            this.reference().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.value != null) {
            jsonWriter.writeUntypedField("value", this.value);
        }
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("reference", (JsonSerializable)this.reference);
        return jsonWriter.writeEndObject();
    }

    public static DeploymentParameter fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentParameter)jsonReader.readObject(reader -> {
            DeploymentParameter deserializedDeploymentParameter = new DeploymentParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedDeploymentParameter.value = reader.readUntyped();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDeploymentParameter.type = reader.getString();
                    continue;
                }
                if ("reference".equals(fieldName)) {
                    deserializedDeploymentParameter.reference = KeyVaultParameterReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentParameter;
        });
    }
}

