/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.deploymentstacks.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.deploymentstacks.fluent.DeploymentStacksClient;
import com.azure.resourcemanager.resources.deploymentstacks.fluent.models.DeploymentStackInner;
import com.azure.resourcemanager.resources.deploymentstacks.fluent.models.DeploymentStackTemplateDefinitionInner;
import com.azure.resourcemanager.resources.deploymentstacks.fluent.models.DeploymentStackValidateResultInner;
import com.azure.resourcemanager.resources.deploymentstacks.implementation.DeploymentStacksManagementClientImpl;
import com.azure.resourcemanager.resources.deploymentstacks.models.DeploymentStackListResult;
import com.azure.resourcemanager.resources.deploymentstacks.models.UnmanageActionManagementGroupMode;
import com.azure.resourcemanager.resources.deploymentstacks.models.UnmanageActionResourceGroupMode;
import com.azure.resourcemanager.resources.deploymentstacks.models.UnmanageActionResourceMode;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DeploymentStacksClientImpl
implements DeploymentStacksClient {
    private final DeploymentStacksService service;
    private final DeploymentStacksManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(DeploymentStacksClientImpl.class);

    DeploymentStacksClientImpl(DeploymentStacksManagementClientImpl client) {
        this.service = (DeploymentStacksService)RestProxy.create(DeploymentStacksService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentStackInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentStackListResult)res.getValue()).value(), ((DeploymentStackListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DeploymentStackInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listAtResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DeploymentStackInner> listByResourceGroupSinglePage(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DeploymentStackListResult> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentStackListResult)res.getValue()).value(), ((DeploymentStackListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DeploymentStackInner> listByResourceGroupSinglePage(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DeploymentStackListResult> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentStackListResult)res.getValue()).value(), ((DeploymentStackListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentStackInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName), nextLink -> this.listAtResourceGroupNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentStackInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName, context), nextLink -> this.listAtResourceGroupNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentStackInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentStackListResult)res.getValue()).value(), ((DeploymentStackListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DeploymentStackInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listAtSubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DeploymentStackInner> listSinglePage() {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DeploymentStackListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentStackListResult)res.getValue()).value(), ((DeploymentStackListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DeploymentStackInner> listSinglePage(Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DeploymentStackListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentStackListResult)res.getValue()).value(), ((DeploymentStackListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentStackInner> list() {
        return new PagedIterable(() -> this.listSinglePage(), nextLink -> this.listAtSubscriptionNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentStackInner> list(Context context) {
        return new PagedIterable(() -> this.listSinglePage(context), nextLink -> this.listAtSubscriptionNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentStackInner>> listAtManagementGroupSinglePageAsync(String managementGroupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAtManagementGroup(this.client.getEndpoint(), managementGroupId, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentStackListResult)res.getValue()).value(), ((DeploymentStackListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DeploymentStackInner> listAtManagementGroupAsync(String managementGroupId) {
        return new PagedFlux(() -> this.listAtManagementGroupSinglePageAsync(managementGroupId), nextLink -> this.listAtManagementGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DeploymentStackInner> listAtManagementGroupSinglePage(String managementGroupId) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DeploymentStackListResult> res = this.service.listAtManagementGroupSync(this.client.getEndpoint(), managementGroupId, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentStackListResult)res.getValue()).value(), ((DeploymentStackListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DeploymentStackInner> listAtManagementGroupSinglePage(String managementGroupId, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DeploymentStackListResult> res = this.service.listAtManagementGroupSync(this.client.getEndpoint(), managementGroupId, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentStackListResult)res.getValue()).value(), ((DeploymentStackListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentStackInner> listAtManagementGroup(String managementGroupId) {
        return new PagedIterable(() -> this.listAtManagementGroupSinglePage(managementGroupId), nextLink -> this.listAtManagementGroupNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentStackInner> listAtManagementGroup(String managementGroupId, Context context) {
        return new PagedIterable(() -> this.listAtManagementGroupSinglePage(managementGroupId, context), nextLink -> this.listAtManagementGroupNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtResourceGroupWithResponseAsync(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        }
        deploymentStack.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateAtResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, deploymentStackName, this.client.getApiVersion(), deploymentStack, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateAtResourceGroupWithResponse(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        }
        deploymentStack.validate();
        String accept = "application/json";
        return this.service.createOrUpdateAtResourceGroupSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, deploymentStackName, this.client.getApiVersion(), deploymentStack, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateAtResourceGroupWithResponse(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        }
        deploymentStack.validate();
        String accept = "application/json";
        return this.service.createOrUpdateAtResourceGroupSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, deploymentStackName, this.client.getApiVersion(), deploymentStack, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtResourceGroupAsync(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateAtResourceGroupWithResponseAsync(resourceGroupName, deploymentStackName, deploymentStack);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentStackInner.class), (Type)((Object)DeploymentStackInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtResourceGroup(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack) {
        Response<BinaryData> response = this.createOrUpdateAtResourceGroupWithResponse(resourceGroupName, deploymentStackName, deploymentStack);
        return this.client.getLroResult(response, (Type)((Object)DeploymentStackInner.class), (Type)((Object)DeploymentStackInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtResourceGroup(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        Response<BinaryData> response = this.createOrUpdateAtResourceGroupWithResponse(resourceGroupName, deploymentStackName, deploymentStack, context);
        return this.client.getLroResult(response, (Type)((Object)DeploymentStackInner.class), (Type)((Object)DeploymentStackInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentStackInner> createOrUpdateAtResourceGroupAsync(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack) {
        return this.beginCreateOrUpdateAtResourceGroupAsync(resourceGroupName, deploymentStackName, deploymentStack).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentStackInner createOrUpdateAtResourceGroup(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack) {
        return (DeploymentStackInner)((Object)this.beginCreateOrUpdateAtResourceGroup(resourceGroupName, deploymentStackName, deploymentStack).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentStackInner createOrUpdateAtResourceGroup(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        return (DeploymentStackInner)((Object)this.beginCreateOrUpdateAtResourceGroup(resourceGroupName, deploymentStackName, deploymentStack, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentStackInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String deploymentStackName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, deploymentStackName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentStackInner> getByResourceGroupAsync(String resourceGroupName, String deploymentStackName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, deploymentStackName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DeploymentStackInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentStackInner> getByResourceGroupWithResponse(String resourceGroupName, String deploymentStackName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getByResourceGroupSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, deploymentStackName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentStackInner getByResourceGroup(String resourceGroupName, String deploymentStackName) {
        return (DeploymentStackInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, deploymentStackName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, this.client.getApiVersion(), "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String deploymentStackName) {
        UnmanageActionResourceMode unmanageActionResources = null;
        UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        Boolean bypassStackOutOfSyncError = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String deploymentStackName) {
        UnmanageActionResourceMode unmanageActionResources = null;
        UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        Boolean bypassStackOutOfSyncError = null;
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        return this.beginDeleteAsync(resourceGroupName, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String deploymentStackName) {
        UnmanageActionResourceMode unmanageActionResources = null;
        UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        Boolean bypassStackOutOfSyncError = null;
        return this.beginDeleteAsync(resourceGroupName, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String deploymentStackName) {
        UnmanageActionResourceMode unmanageActionResources = null;
        UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        Boolean bypassStackOutOfSyncError = null;
        this.beginDelete(resourceGroupName, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError, Context context) {
        this.beginDelete(resourceGroupName, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtSubscriptionWithResponseAsync(String deploymentStackName, DeploymentStackInner deploymentStack) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        }
        deploymentStack.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), deploymentStackName, this.client.getApiVersion(), deploymentStack, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateAtSubscriptionWithResponse(String deploymentStackName, DeploymentStackInner deploymentStack) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        }
        deploymentStack.validate();
        String accept = "application/json";
        return this.service.createOrUpdateAtSubscriptionSync(this.client.getEndpoint(), this.client.getSubscriptionId(), deploymentStackName, this.client.getApiVersion(), deploymentStack, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateAtSubscriptionWithResponse(String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        }
        deploymentStack.validate();
        String accept = "application/json";
        return this.service.createOrUpdateAtSubscriptionSync(this.client.getEndpoint(), this.client.getSubscriptionId(), deploymentStackName, this.client.getApiVersion(), deploymentStack, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtSubscriptionAsync(String deploymentStackName, DeploymentStackInner deploymentStack) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateAtSubscriptionWithResponseAsync(deploymentStackName, deploymentStack);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentStackInner.class), (Type)((Object)DeploymentStackInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack) {
        Response<BinaryData> response = this.createOrUpdateAtSubscriptionWithResponse(deploymentStackName, deploymentStack);
        return this.client.getLroResult(response, (Type)((Object)DeploymentStackInner.class), (Type)((Object)DeploymentStackInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        Response<BinaryData> response = this.createOrUpdateAtSubscriptionWithResponse(deploymentStackName, deploymentStack, context);
        return this.client.getLroResult(response, (Type)((Object)DeploymentStackInner.class), (Type)((Object)DeploymentStackInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentStackInner> createOrUpdateAtSubscriptionAsync(String deploymentStackName, DeploymentStackInner deploymentStack) {
        return this.beginCreateOrUpdateAtSubscriptionAsync(deploymentStackName, deploymentStack).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentStackInner createOrUpdateAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack) {
        return (DeploymentStackInner)((Object)this.beginCreateOrUpdateAtSubscription(deploymentStackName, deploymentStack).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentStackInner createOrUpdateAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        return (DeploymentStackInner)((Object)this.beginCreateOrUpdateAtSubscription(deploymentStackName, deploymentStack, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentStackInner>> getAtSubscriptionWithResponseAsync(String deploymentStackName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), deploymentStackName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentStackInner> getAtSubscriptionAsync(String deploymentStackName) {
        return this.getAtSubscriptionWithResponseAsync(deploymentStackName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DeploymentStackInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentStackInner> getAtSubscriptionWithResponse(String deploymentStackName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getAtSubscriptionSync(this.client.getEndpoint(), this.client.getSubscriptionId(), deploymentStackName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentStackInner getAtSubscription(String deploymentStackName) {
        return (DeploymentStackInner)((Object)this.getAtSubscriptionWithResponse(deploymentStackName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteAtSubscriptionWithResponseAsync(String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteAtSubscriptionWithResponse(String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteAtSubscriptionSync(this.client.getEndpoint(), this.client.getSubscriptionId(), deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, this.client.getApiVersion(), "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteAtSubscriptionWithResponse(String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteAtSubscriptionSync(this.client.getEndpoint(), this.client.getSubscriptionId(), deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAtSubscriptionAsync(String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteAtSubscriptionWithResponseAsync(deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAtSubscriptionAsync(String deploymentStackName) {
        UnmanageActionResourceMode unmanageActionResources = null;
        UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        Boolean bypassStackOutOfSyncError = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteAtSubscriptionWithResponseAsync(deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtSubscription(String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        Response<BinaryData> response = this.deleteAtSubscriptionWithResponse(deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtSubscription(String deploymentStackName) {
        UnmanageActionResourceMode unmanageActionResources = null;
        UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        Boolean bypassStackOutOfSyncError = null;
        Response<BinaryData> response = this.deleteAtSubscriptionWithResponse(deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtSubscription(String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError, Context context) {
        Response<BinaryData> response = this.deleteAtSubscriptionWithResponse(deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAtSubscriptionAsync(String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        return this.beginDeleteAtSubscriptionAsync(deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAtSubscriptionAsync(String deploymentStackName) {
        UnmanageActionResourceMode unmanageActionResources = null;
        UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        Boolean bypassStackOutOfSyncError = null;
        return this.beginDeleteAtSubscriptionAsync(deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAtSubscription(String deploymentStackName) {
        UnmanageActionResourceMode unmanageActionResources = null;
        UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        Boolean bypassStackOutOfSyncError = null;
        this.beginDeleteAtSubscription(deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAtSubscription(String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError, Context context) {
        this.beginDeleteAtSubscription(deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtManagementGroupWithResponseAsync(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        }
        deploymentStack.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateAtManagementGroup(this.client.getEndpoint(), managementGroupId, deploymentStackName, this.client.getApiVersion(), deploymentStack, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateAtManagementGroupWithResponse(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        }
        deploymentStack.validate();
        String accept = "application/json";
        return this.service.createOrUpdateAtManagementGroupSync(this.client.getEndpoint(), managementGroupId, deploymentStackName, this.client.getApiVersion(), deploymentStack, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateAtManagementGroupWithResponse(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        }
        deploymentStack.validate();
        String accept = "application/json";
        return this.service.createOrUpdateAtManagementGroupSync(this.client.getEndpoint(), managementGroupId, deploymentStackName, this.client.getApiVersion(), deploymentStack, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtManagementGroupAsync(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateAtManagementGroupWithResponseAsync(managementGroupId, deploymentStackName, deploymentStack);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentStackInner.class), (Type)((Object)DeploymentStackInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtManagementGroup(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack) {
        Response<BinaryData> response = this.createOrUpdateAtManagementGroupWithResponse(managementGroupId, deploymentStackName, deploymentStack);
        return this.client.getLroResult(response, (Type)((Object)DeploymentStackInner.class), (Type)((Object)DeploymentStackInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtManagementGroup(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        Response<BinaryData> response = this.createOrUpdateAtManagementGroupWithResponse(managementGroupId, deploymentStackName, deploymentStack, context);
        return this.client.getLroResult(response, (Type)((Object)DeploymentStackInner.class), (Type)((Object)DeploymentStackInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentStackInner> createOrUpdateAtManagementGroupAsync(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack) {
        return this.beginCreateOrUpdateAtManagementGroupAsync(managementGroupId, deploymentStackName, deploymentStack).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentStackInner createOrUpdateAtManagementGroup(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack) {
        return (DeploymentStackInner)((Object)this.beginCreateOrUpdateAtManagementGroup(managementGroupId, deploymentStackName, deploymentStack).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentStackInner createOrUpdateAtManagementGroup(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        return (DeploymentStackInner)((Object)this.beginCreateOrUpdateAtManagementGroup(managementGroupId, deploymentStackName, deploymentStack, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentStackInner>> getAtManagementGroupWithResponseAsync(String managementGroupId, String deploymentStackName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAtManagementGroup(this.client.getEndpoint(), managementGroupId, deploymentStackName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentStackInner> getAtManagementGroupAsync(String managementGroupId, String deploymentStackName) {
        return this.getAtManagementGroupWithResponseAsync(managementGroupId, deploymentStackName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DeploymentStackInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentStackInner> getAtManagementGroupWithResponse(String managementGroupId, String deploymentStackName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getAtManagementGroupSync(this.client.getEndpoint(), managementGroupId, deploymentStackName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentStackInner getAtManagementGroup(String managementGroupId, String deploymentStackName) {
        return (DeploymentStackInner)((Object)this.getAtManagementGroupWithResponse(managementGroupId, deploymentStackName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteAtManagementGroupWithResponseAsync(String managementGroupId, String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAtManagementGroup(this.client.getEndpoint(), managementGroupId, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteAtManagementGroupWithResponse(String managementGroupId, String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteAtManagementGroupSync(this.client.getEndpoint(), managementGroupId, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, this.client.getApiVersion(), "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteAtManagementGroupWithResponse(String managementGroupId, String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteAtManagementGroupSync(this.client.getEndpoint(), managementGroupId, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAtManagementGroupAsync(String managementGroupId, String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteAtManagementGroupWithResponseAsync(managementGroupId, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAtManagementGroupAsync(String managementGroupId, String deploymentStackName) {
        UnmanageActionResourceMode unmanageActionResources = null;
        UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        Boolean bypassStackOutOfSyncError = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteAtManagementGroupWithResponseAsync(managementGroupId, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtManagementGroup(String managementGroupId, String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        Response<BinaryData> response = this.deleteAtManagementGroupWithResponse(managementGroupId, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtManagementGroup(String managementGroupId, String deploymentStackName) {
        UnmanageActionResourceMode unmanageActionResources = null;
        UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        Boolean bypassStackOutOfSyncError = null;
        Response<BinaryData> response = this.deleteAtManagementGroupWithResponse(managementGroupId, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtManagementGroup(String managementGroupId, String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError, Context context) {
        Response<BinaryData> response = this.deleteAtManagementGroupWithResponse(managementGroupId, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAtManagementGroupAsync(String managementGroupId, String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        return this.beginDeleteAtManagementGroupAsync(managementGroupId, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAtManagementGroupAsync(String managementGroupId, String deploymentStackName) {
        UnmanageActionResourceMode unmanageActionResources = null;
        UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        Boolean bypassStackOutOfSyncError = null;
        return this.beginDeleteAtManagementGroupAsync(managementGroupId, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAtManagementGroup(String managementGroupId, String deploymentStackName) {
        UnmanageActionResourceMode unmanageActionResources = null;
        UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        Boolean bypassStackOutOfSyncError = null;
        this.beginDeleteAtManagementGroup(managementGroupId, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAtManagementGroup(String managementGroupId, String deploymentStackName, UnmanageActionResourceMode unmanageActionResources, UnmanageActionResourceGroupMode unmanageActionResourceGroups, UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError, Context context) {
        this.beginDeleteAtManagementGroup(managementGroupId, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentStackTemplateDefinitionInner>> exportTemplateAtResourceGroupWithResponseAsync(String resourceGroupName, String deploymentStackName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.exportTemplateAtResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, deploymentStackName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentStackTemplateDefinitionInner> exportTemplateAtResourceGroupAsync(String resourceGroupName, String deploymentStackName) {
        return this.exportTemplateAtResourceGroupWithResponseAsync(resourceGroupName, deploymentStackName).flatMap(res -> Mono.justOrEmpty((Object)((DeploymentStackTemplateDefinitionInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentStackTemplateDefinitionInner> exportTemplateAtResourceGroupWithResponse(String resourceGroupName, String deploymentStackName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.exportTemplateAtResourceGroupSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, deploymentStackName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentStackTemplateDefinitionInner exportTemplateAtResourceGroup(String resourceGroupName, String deploymentStackName) {
        return (DeploymentStackTemplateDefinitionInner)this.exportTemplateAtResourceGroupWithResponse(resourceGroupName, deploymentStackName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentStackTemplateDefinitionInner>> exportTemplateAtSubscriptionWithResponseAsync(String deploymentStackName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.exportTemplateAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), deploymentStackName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentStackTemplateDefinitionInner> exportTemplateAtSubscriptionAsync(String deploymentStackName) {
        return this.exportTemplateAtSubscriptionWithResponseAsync(deploymentStackName).flatMap(res -> Mono.justOrEmpty((Object)((DeploymentStackTemplateDefinitionInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentStackTemplateDefinitionInner> exportTemplateAtSubscriptionWithResponse(String deploymentStackName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.exportTemplateAtSubscriptionSync(this.client.getEndpoint(), this.client.getSubscriptionId(), deploymentStackName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentStackTemplateDefinitionInner exportTemplateAtSubscription(String deploymentStackName) {
        return (DeploymentStackTemplateDefinitionInner)this.exportTemplateAtSubscriptionWithResponse(deploymentStackName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentStackTemplateDefinitionInner>> exportTemplateAtManagementGroupWithResponseAsync(String managementGroupId, String deploymentStackName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.exportTemplateAtManagementGroup(this.client.getEndpoint(), managementGroupId, deploymentStackName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentStackTemplateDefinitionInner> exportTemplateAtManagementGroupAsync(String managementGroupId, String deploymentStackName) {
        return this.exportTemplateAtManagementGroupWithResponseAsync(managementGroupId, deploymentStackName).flatMap(res -> Mono.justOrEmpty((Object)((DeploymentStackTemplateDefinitionInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentStackTemplateDefinitionInner> exportTemplateAtManagementGroupWithResponse(String managementGroupId, String deploymentStackName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.exportTemplateAtManagementGroupSync(this.client.getEndpoint(), managementGroupId, deploymentStackName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentStackTemplateDefinitionInner exportTemplateAtManagementGroup(String managementGroupId, String deploymentStackName) {
        return (DeploymentStackTemplateDefinitionInner)this.exportTemplateAtManagementGroupWithResponse(managementGroupId, deploymentStackName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateStackAtResourceGroupWithResponseAsync(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        }
        deploymentStack.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateStackAtResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, deploymentStackName, this.client.getApiVersion(), deploymentStack, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> validateStackAtResourceGroupWithResponse(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        }
        deploymentStack.validate();
        String accept = "application/json";
        return this.service.validateStackAtResourceGroupSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, deploymentStackName, this.client.getApiVersion(), deploymentStack, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> validateStackAtResourceGroupWithResponse(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        }
        deploymentStack.validate();
        String accept = "application/json";
        return this.service.validateStackAtResourceGroupSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, deploymentStackName, this.client.getApiVersion(), deploymentStack, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner> beginValidateStackAtResourceGroupAsync(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateStackAtResourceGroupWithResponseAsync(resourceGroupName, deploymentStackName, deploymentStack);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentStackValidateResultInner.class), (Type)((Object)DeploymentStackValidateResultInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner> beginValidateStackAtResourceGroup(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack) {
        Response<BinaryData> response = this.validateStackAtResourceGroupWithResponse(resourceGroupName, deploymentStackName, deploymentStack);
        return this.client.getLroResult(response, (Type)((Object)DeploymentStackValidateResultInner.class), (Type)((Object)DeploymentStackValidateResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner> beginValidateStackAtResourceGroup(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        Response<BinaryData> response = this.validateStackAtResourceGroupWithResponse(resourceGroupName, deploymentStackName, deploymentStack, context);
        return this.client.getLroResult(response, (Type)((Object)DeploymentStackValidateResultInner.class), (Type)((Object)DeploymentStackValidateResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentStackValidateResultInner> validateStackAtResourceGroupAsync(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack) {
        return this.beginValidateStackAtResourceGroupAsync(resourceGroupName, deploymentStackName, deploymentStack).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentStackValidateResultInner validateStackAtResourceGroup(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack) {
        return (DeploymentStackValidateResultInner)((Object)this.beginValidateStackAtResourceGroup(resourceGroupName, deploymentStackName, deploymentStack).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentStackValidateResultInner validateStackAtResourceGroup(String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        return (DeploymentStackValidateResultInner)((Object)this.beginValidateStackAtResourceGroup(resourceGroupName, deploymentStackName, deploymentStack, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateStackAtSubscriptionWithResponseAsync(String deploymentStackName, DeploymentStackInner deploymentStack) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        }
        deploymentStack.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateStackAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), deploymentStackName, this.client.getApiVersion(), deploymentStack, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> validateStackAtSubscriptionWithResponse(String deploymentStackName, DeploymentStackInner deploymentStack) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        }
        deploymentStack.validate();
        String accept = "application/json";
        return this.service.validateStackAtSubscriptionSync(this.client.getEndpoint(), this.client.getSubscriptionId(), deploymentStackName, this.client.getApiVersion(), deploymentStack, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> validateStackAtSubscriptionWithResponse(String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        }
        deploymentStack.validate();
        String accept = "application/json";
        return this.service.validateStackAtSubscriptionSync(this.client.getEndpoint(), this.client.getSubscriptionId(), deploymentStackName, this.client.getApiVersion(), deploymentStack, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner> beginValidateStackAtSubscriptionAsync(String deploymentStackName, DeploymentStackInner deploymentStack) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateStackAtSubscriptionWithResponseAsync(deploymentStackName, deploymentStack);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentStackValidateResultInner.class), (Type)((Object)DeploymentStackValidateResultInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner> beginValidateStackAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack) {
        Response<BinaryData> response = this.validateStackAtSubscriptionWithResponse(deploymentStackName, deploymentStack);
        return this.client.getLroResult(response, (Type)((Object)DeploymentStackValidateResultInner.class), (Type)((Object)DeploymentStackValidateResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner> beginValidateStackAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        Response<BinaryData> response = this.validateStackAtSubscriptionWithResponse(deploymentStackName, deploymentStack, context);
        return this.client.getLroResult(response, (Type)((Object)DeploymentStackValidateResultInner.class), (Type)((Object)DeploymentStackValidateResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentStackValidateResultInner> validateStackAtSubscriptionAsync(String deploymentStackName, DeploymentStackInner deploymentStack) {
        return this.beginValidateStackAtSubscriptionAsync(deploymentStackName, deploymentStack).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentStackValidateResultInner validateStackAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack) {
        return (DeploymentStackValidateResultInner)((Object)this.beginValidateStackAtSubscription(deploymentStackName, deploymentStack).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentStackValidateResultInner validateStackAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        return (DeploymentStackValidateResultInner)((Object)this.beginValidateStackAtSubscription(deploymentStackName, deploymentStack, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateStackAtManagementGroupWithResponseAsync(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        }
        deploymentStack.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateStackAtManagementGroup(this.client.getEndpoint(), managementGroupId, deploymentStackName, this.client.getApiVersion(), deploymentStack, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> validateStackAtManagementGroupWithResponse(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        }
        deploymentStack.validate();
        String accept = "application/json";
        return this.service.validateStackAtManagementGroupSync(this.client.getEndpoint(), managementGroupId, deploymentStackName, this.client.getApiVersion(), deploymentStack, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> validateStackAtManagementGroupWithResponse(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        }
        deploymentStack.validate();
        String accept = "application/json";
        return this.service.validateStackAtManagementGroupSync(this.client.getEndpoint(), managementGroupId, deploymentStackName, this.client.getApiVersion(), deploymentStack, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner> beginValidateStackAtManagementGroupAsync(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateStackAtManagementGroupWithResponseAsync(managementGroupId, deploymentStackName, deploymentStack);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DeploymentStackValidateResultInner.class), (Type)((Object)DeploymentStackValidateResultInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner> beginValidateStackAtManagementGroup(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack) {
        Response<BinaryData> response = this.validateStackAtManagementGroupWithResponse(managementGroupId, deploymentStackName, deploymentStack);
        return this.client.getLroResult(response, (Type)((Object)DeploymentStackValidateResultInner.class), (Type)((Object)DeploymentStackValidateResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner> beginValidateStackAtManagementGroup(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        Response<BinaryData> response = this.validateStackAtManagementGroupWithResponse(managementGroupId, deploymentStackName, deploymentStack, context);
        return this.client.getLroResult(response, (Type)((Object)DeploymentStackValidateResultInner.class), (Type)((Object)DeploymentStackValidateResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeploymentStackValidateResultInner> validateStackAtManagementGroupAsync(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack) {
        return this.beginValidateStackAtManagementGroupAsync(managementGroupId, deploymentStackName, deploymentStack).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentStackValidateResultInner validateStackAtManagementGroup(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack) {
        return (DeploymentStackValidateResultInner)((Object)this.beginValidateStackAtManagementGroup(managementGroupId, deploymentStackName, deploymentStack).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentStackValidateResultInner validateStackAtManagementGroup(String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        return (DeploymentStackValidateResultInner)((Object)this.beginValidateStackAtManagementGroup(managementGroupId, deploymentStackName, deploymentStack, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentStackInner>> listAtResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAtResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentStackListResult)res.getValue()).value(), ((DeploymentStackListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DeploymentStackInner> listAtResourceGroupNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DeploymentStackListResult> res = this.service.listAtResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentStackListResult)res.getValue()).value(), ((DeploymentStackListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DeploymentStackInner> listAtResourceGroupNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DeploymentStackListResult> res = this.service.listAtResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentStackListResult)res.getValue()).value(), ((DeploymentStackListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentStackInner>> listAtSubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAtSubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentStackListResult)res.getValue()).value(), ((DeploymentStackListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DeploymentStackInner> listAtSubscriptionNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DeploymentStackListResult> res = this.service.listAtSubscriptionNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentStackListResult)res.getValue()).value(), ((DeploymentStackListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DeploymentStackInner> listAtSubscriptionNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DeploymentStackListResult> res = this.service.listAtSubscriptionNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentStackListResult)res.getValue()).value(), ((DeploymentStackListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentStackInner>> listAtManagementGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAtManagementGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentStackListResult)res.getValue()).value(), ((DeploymentStackListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DeploymentStackInner> listAtManagementGroupNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DeploymentStackListResult> res = this.service.listAtManagementGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentStackListResult)res.getValue()).value(), ((DeploymentStackListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DeploymentStackInner> listAtManagementGroupNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DeploymentStackListResult> res = this.service.listAtManagementGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentStackListResult)res.getValue()).value(), ((DeploymentStackListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DeploymentStacksManagementClientDeploymentStacks")
    public static interface DeploymentStacksService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentStackListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DeploymentStackListResult> listByResourceGroupSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentStackListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DeploymentStackListResult> listSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentStackListResult>> listAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DeploymentStackListResult> listAtManagementGroupSync(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="deploymentStackName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") DeploymentStackInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateAtResourceGroupSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="deploymentStackName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") DeploymentStackInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentStackInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="deploymentStackName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DeploymentStackInner> getByResourceGroupSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="deploymentStackName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="deploymentStackName") String var4, @QueryParam(value="unmanageAction.Resources") UnmanageActionResourceMode var5, @QueryParam(value="unmanageAction.ResourceGroups") UnmanageActionResourceGroupMode var6, @QueryParam(value="unmanageAction.ManagementGroups") UnmanageActionManagementGroupMode var7, @QueryParam(value="bypassStackOutOfSyncError") Boolean var8, @QueryParam(value="api-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="deploymentStackName") String var4, @QueryParam(value="unmanageAction.Resources") UnmanageActionResourceMode var5, @QueryParam(value="unmanageAction.ResourceGroups") UnmanageActionResourceGroupMode var6, @QueryParam(value="unmanageAction.ManagementGroups") UnmanageActionManagementGroupMode var7, @QueryParam(value="bypassStackOutOfSyncError") Boolean var8, @QueryParam(value="api-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtSubscription(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") DeploymentStackInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateAtSubscriptionSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") DeploymentStackInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentStackInner>> getAtSubscription(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DeploymentStackInner> getAtSubscriptionSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteAtSubscription(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="unmanageAction.Resources") UnmanageActionResourceMode var4, @QueryParam(value="unmanageAction.ResourceGroups") UnmanageActionResourceGroupMode var5, @QueryParam(value="unmanageAction.ManagementGroups") UnmanageActionManagementGroupMode var6, @QueryParam(value="bypassStackOutOfSyncError") Boolean var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteAtSubscriptionSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="unmanageAction.Resources") UnmanageActionResourceMode var4, @QueryParam(value="unmanageAction.ResourceGroups") UnmanageActionResourceGroupMode var5, @QueryParam(value="unmanageAction.ManagementGroups") UnmanageActionManagementGroupMode var6, @QueryParam(value="bypassStackOutOfSyncError") Boolean var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") DeploymentStackInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateAtManagementGroupSync(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") DeploymentStackInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentStackInner>> getAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DeploymentStackInner> getAtManagementGroupSync(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deleteAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="unmanageAction.Resources") UnmanageActionResourceMode var4, @QueryParam(value="unmanageAction.ResourceGroups") UnmanageActionResourceGroupMode var5, @QueryParam(value="unmanageAction.ManagementGroups") UnmanageActionManagementGroupMode var6, @QueryParam(value="bypassStackOutOfSyncError") Boolean var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteAtManagementGroupSync(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="unmanageAction.Resources") UnmanageActionResourceMode var4, @QueryParam(value="unmanageAction.ResourceGroups") UnmanageActionResourceGroupMode var5, @QueryParam(value="unmanageAction.ManagementGroups") UnmanageActionManagementGroupMode var6, @QueryParam(value="bypassStackOutOfSyncError") Boolean var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/exportTemplate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentStackTemplateDefinitionInner>> exportTemplateAtResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="deploymentStackName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/exportTemplate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DeploymentStackTemplateDefinitionInner> exportTemplateAtResourceGroupSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="deploymentStackName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/exportTemplate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentStackTemplateDefinitionInner>> exportTemplateAtSubscription(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/exportTemplate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DeploymentStackTemplateDefinitionInner> exportTemplateAtSubscriptionSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/exportTemplate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentStackTemplateDefinitionInner>> exportTemplateAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/exportTemplate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DeploymentStackTemplateDefinitionInner> exportTemplateAtManagementGroupSync(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/validate")
        @ExpectedResponses(value={200, 202, 400})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> validateStackAtResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="deploymentStackName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") DeploymentStackInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/validate")
        @ExpectedResponses(value={200, 202, 400})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> validateStackAtResourceGroupSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="deploymentStackName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") DeploymentStackInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/validate")
        @ExpectedResponses(value={200, 202, 400})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> validateStackAtSubscription(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") DeploymentStackInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/validate")
        @ExpectedResponses(value={200, 202, 400})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> validateStackAtSubscriptionSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") DeploymentStackInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/validate")
        @ExpectedResponses(value={200, 202, 400})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> validateStackAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") DeploymentStackInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/validate")
        @ExpectedResponses(value={200, 202, 400})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> validateStackAtManagementGroupSync(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @PathParam(value="deploymentStackName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") DeploymentStackInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentStackListResult>> listAtResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DeploymentStackListResult> listAtResourceGroupNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentStackListResult>> listAtSubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DeploymentStackListResult> listAtSubscriptionNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeploymentStackListResult>> listAtManagementGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DeploymentStackListResult> listAtManagementGroupNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

